/*
 * Decompiled with CFR 0.152.
 */
package javatests;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.python.core.PySet;
import org.python.core.PyTuple;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySetInJavaTest {
    public static Set<Object> createPySetContainingJavaObjects() {
        PySet pySet = new PySet();
        pySet.add("value");
        pySet.add(new Random());
        return pySet;
    }

    public static void testPySetAsJavaSet() {
        PySet pySet = new PySet();
        String string = "value";
        PySetInJavaTest.check(pySet.add(string));
        PySetInJavaTest.check(!pySet.add(string));
        String[] stringArray = (String[])pySet.toArray(new String[0]);
        PySetInJavaTest.check(stringArray.length == 1);
        PySetInJavaTest.check(stringArray[0] == string);
        Object[] objectArray = pySet.toArray();
        PySetInJavaTest.check(objectArray.length == 1);
        PySetInJavaTest.check(objectArray[0] == string);
        Random random = new Random();
        PySetInJavaTest.check(pySet.addAll((Collection)Generic.list(random)));
        PySetInJavaTest.check(!pySet.addAll((Collection)Generic.list(random, string)));
        objectArray = pySet.toArray();
        PySetInJavaTest.check(objectArray.length == 2);
        for (Object object : objectArray) {
            if (object instanceof String) {
                PySetInJavaTest.check(object == string);
                continue;
            }
            PySetInJavaTest.check(object == random, "Should be 'value' or rand, not " + object);
        }
        PySetInJavaTest.check(!pySet.remove(new Random()), "The Random in the set shouldn't match a new Random");
        PySetInJavaTest.check(pySet.remove(random));
        PySetInJavaTest.check(pySet.removeAll((Collection)Generic.list(random, string)), "The set should contain v and indicate it removed it");
        PySetInJavaTest.check(pySet.isEmpty());
        PySetInJavaTest.check(pySet.addAll((Collection)Generic.list(random, string)));
        PySetInJavaTest.check(2 == pySet.size(), "There should be 2 items, not " + pySet.size());
        PySetInJavaTest.check(pySet.containsAll((Collection)Generic.list(random, string)));
        PySetInJavaTest.check(!pySet.containsAll((Collection)Generic.list(random, string, "other")));
        PySetInJavaTest.check(pySet.retainAll((Collection)Generic.list(random)));
        PySetInJavaTest.check(!pySet.retainAll((Collection)Generic.list(random)));
        PySetInJavaTest.check(pySet.addAll((Collection)Generic.list(random, string)));
        PySetInJavaTest.check(2 == pySet.size(), "There should be 2 items, not " + pySet.size());
        PySetInJavaTest.check(!pySet.addAll((Collection)Generic.list(random, string)));
        PySetInJavaTest.check(2 == pySet.size(), "There should be 2 items, not " + pySet.size());
    }

    public static void accessAndRemovePySetItems(Set<Object> set) {
        PySetInJavaTest.check(set instanceof PySet, "The set shouldn't be __tojava'd into " + set.getClass());
        PySetInJavaTest.check(set.size() == 3, "Should be 3 items, not " + set.size());
        PySetInJavaTest.check(set.contains("value"), "The set from Python should contain 'value'");
        PySetInJavaTest.check(!set.contains(new Random()), "The set contains a particular Random");
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            PySetInJavaTest.check(set.contains(object), "The set should contain all items from its iterator");
            if (object instanceof String) {
                PySetInJavaTest.check(object.equals("value"), "The string should be 'value', not '" + object + "'");
            } else {
                PySetInJavaTest.check(object instanceof Random || object instanceof PyTuple, "The objects in the set should be a String, a Random or a PyTuple, not a " + object.getClass());
            }
            iterator.remove();
        }
    }

    private static void check(boolean bl) {
        PySetInJavaTest.check(bl, "");
    }

    private static void check(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(string);
        }
    }
}

