/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import jline.CandidateListCompletionHandler;
import jline.CompletionHandler;
import jline.Completor;
import jline.ConsoleOperations;
import jline.CursorBuffer;
import jline.History;
import jline.Terminal;

public class ConsoleReader
implements ConsoleOperations {
    static final int TAB_WIDTH = 4;
    String prompt;
    private boolean useHistory;
    private boolean usePagination;
    public static final String CR = System.getProperty("line.separator");
    private static ResourceBundle loc = ResourceBundle.getBundle((class$jline$CandidateListCompletionHandler == null ? (class$jline$CandidateListCompletionHandler = ConsoleReader.class$("jline.CandidateListCompletionHandler")) : class$jline$CandidateListCompletionHandler).getName());
    public static SortedMap KEYMAP_NAMES;
    private final short[] keybindings;
    private boolean bellEnabled;
    private Character mask;
    private static final Character NULL_MASK;
    private int autoprintThreshhold;
    private final Terminal terminal;
    private CompletionHandler completionHandler;
    InputStream in;
    final Writer out;
    final CursorBuffer buf;
    static PrintWriter debugger;
    History history;
    final List completors;
    private Character echoCharacter;
    private Map triggeredActions;
    static /* synthetic */ Class class$jline$CandidateListCompletionHandler;

    public void addTriggeredAction(char c, ActionListener actionListener) {
        this.triggeredActions.put(new Character(c), actionListener);
    }

    public ConsoleReader() throws IOException {
        this(new FileInputStream(FileDescriptor.in), new PrintWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("jline.WindowsTerminal.output.encoding", System.getProperty("file.encoding")))));
    }

    public ConsoleReader(InputStream inputStream, Writer writer) throws IOException {
        this(inputStream, writer, null);
    }

    public ConsoleReader(InputStream inputStream, Writer writer, InputStream inputStream2) throws IOException {
        this(inputStream, writer, inputStream2, Terminal.getTerminal());
    }

    public ConsoleReader(InputStream inputStream, Writer writer, InputStream inputStream2, Terminal terminal) throws IOException {
        Object object;
        Object object2;
        block9: {
            this.useHistory = true;
            this.usePagination = false;
            this.bellEnabled = true;
            this.mask = null;
            this.autoprintThreshhold = Integer.getInteger("jline.completion.threshold", 100);
            this.completionHandler = new CandidateListCompletionHandler();
            this.buf = new CursorBuffer();
            this.history = new History();
            this.completors = new LinkedList();
            this.echoCharacter = null;
            this.triggeredActions = new HashMap();
            this.terminal = terminal;
            this.setInput(inputStream);
            this.out = writer;
            if (inputStream2 == null) {
                try {
                    object2 = new File(System.getProperty("user.home"), ".jlinebindings.properties").getAbsolutePath();
                    object = System.getProperty("jline.keybindings", (String)object2);
                    if (new File((String)object).isFile()) {
                        inputStream2 = new FileInputStream(new File((String)object));
                    }
                }
                catch (Exception exception) {
                    if (debugger == null) break block9;
                    exception.printStackTrace(debugger);
                }
            }
        }
        if (inputStream2 == null) {
            inputStream2 = this.terminal.getDefaultBindings();
        }
        this.keybindings = new short[131070];
        Arrays.fill(this.keybindings, (short)-99);
        if (inputStream2 != null) {
            object2 = new Properties();
            ((Properties)object2).load(inputStream2);
            inputStream2.close();
            object = ((Properties)object2).keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                try {
                    Short s = new Short(string);
                    String string2 = ((Properties)object2).getProperty(string);
                    Short s2 = (Short)KEYMAP_NAMES.get(string2);
                    if (s2 == null) continue;
                    this.keybindings[s.shortValue()] = s2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.consumeException(numberFormatException);
                }
            }
        }
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setDebug(PrintWriter printWriter) {
        debugger = printWriter;
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
    }

    public InputStream getInput() {
        return this.in;
    }

    public String readLine() throws IOException {
        return this.readLine((String)null);
    }

    public String readLine(Character c) throws IOException {
        return this.readLine(null, c);
    }

    public void setBellEnabled(boolean bl) {
        this.bellEnabled = bl;
    }

    public boolean getBellEnabled() {
        return this.bellEnabled;
    }

    public int getTermwidth() {
        return Terminal.setupTerminal().getTerminalWidth();
    }

    public int getTermheight() {
        return Terminal.setupTerminal().getTerminalHeight();
    }

    public void setAutoprintThreshhold(int n) {
        this.autoprintThreshhold = n;
    }

    public int getAutoprintThreshhold() {
        return this.autoprintThreshhold;
    }

    int getKeyForAction(short s) {
        for (int i = 0; i < this.keybindings.length; ++i) {
            if (this.keybindings[i] != s) continue;
            return i;
        }
        return -1;
    }

    int clearEcho(int n) throws IOException {
        if (!this.terminal.getEcho()) {
            return 0;
        }
        int n2 = this.countEchoCharacters((char)n);
        this.back(n2);
        this.drawBuffer(n2);
        return n2;
    }

    int countEchoCharacters(char c) {
        if (c == '\t') {
            int n = 8;
            int n2 = this.getCursorPosition();
            return n - n2 % n;
        }
        return this.getPrintableCharacters(c).length();
    }

    StringBuffer getPrintableCharacters(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        if (c >= ' ') {
            if (c < '\u007f') {
                stringBuffer.append(c);
            } else if (c == '\u007f') {
                stringBuffer.append('^');
                stringBuffer.append('?');
            } else {
                stringBuffer.append('M');
                stringBuffer.append('-');
                if (c >= '\u00a0') {
                    if (c < '\u00ff') {
                        stringBuffer.append((char)(c - 128));
                    } else {
                        stringBuffer.append('^');
                        stringBuffer.append('?');
                    }
                } else {
                    stringBuffer.append('^');
                    stringBuffer.append((char)(c - 128 + 64));
                }
            }
        } else {
            stringBuffer.append('^');
            stringBuffer.append((char)(c + 64));
        }
        return stringBuffer;
    }

    int getCursorPosition() {
        return (this.prompt == null ? 0 : this.prompt.length()) + this.buf.cursor;
    }

    public String readLine(String string) throws IOException {
        return this.readLine(string, null);
    }

    public void setDefaultPrompt(String string) {
        this.prompt = string;
    }

    public String getDefaultPrompt() {
        return this.prompt;
    }

    public String readLine(String string, Character c) throws IOException {
        this.mask = c;
        if (string != null) {
            this.prompt = string;
        }
        try {
            this.terminal.beforeReadLine(this, this.prompt, c);
            if (this.prompt != null && this.prompt.length() > 0) {
                this.out.write(this.prompt);
                this.out.flush();
            }
            if (!this.terminal.isSupported()) {
                String string2 = this.readLine(this.in);
                return string2;
            }
            while (true) {
                int[] nArray;
                if ((nArray = this.readBinding()) == null) {
                    String string3 = null;
                    return string3;
                }
                int n = nArray[0];
                int n2 = nArray[1];
                if (n == -1) {
                    String string4 = null;
                    return string4;
                }
                boolean bl = true;
                switch (n2) {
                    case -59: {
                        if (this.buf.buffer.length() != 0) break;
                        Object object = null;
                        return object;
                    }
                    case -58: {
                        bl = this.complete();
                        break;
                    }
                    case -1: {
                        bl = this.setCursorPosition(0);
                        break;
                    }
                    case -7: {
                        bl = this.killLine();
                        break;
                    }
                    case -8: {
                        bl = this.clearScreen();
                        break;
                    }
                    case -15: {
                        bl = this.resetLine();
                        break;
                    }
                    case -6: {
                        this.moveToEnd();
                        this.printNewline();
                        Object object = this.finishBuffer();
                        return object;
                    }
                    case -41: {
                        bl = this.backspace();
                        break;
                    }
                    case -56: {
                        bl = this.deleteCurrentCharacter();
                        break;
                    }
                    case -3: {
                        bl = this.moveToEnd();
                        break;
                    }
                    case -4: {
                        bl = this.moveCursor(-1) != 0;
                        break;
                    }
                    case -19: {
                        bl = this.moveCursor(1) != 0;
                        break;
                    }
                    case -9: {
                        bl = this.moveHistory(true);
                        break;
                    }
                    case -11: {
                        bl = this.moveHistory(false);
                        break;
                    }
                    case -13: {
                        break;
                    }
                    case -60: {
                        bl = this.paste();
                        break;
                    }
                    case -16: {
                        bl = this.deletePreviousWord();
                        break;
                    }
                    case -43: {
                        bl = this.previousWord();
                        break;
                    }
                    case -55: {
                        bl = this.nextWord();
                        break;
                    }
                    case -61: {
                        bl = this.history.moveToFirstEntry();
                        if (!bl) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case -62: {
                        bl = this.history.moveToLastEntry();
                        if (!bl) break;
                        this.setBuffer(this.history.current());
                        break;
                    }
                    case -63: {
                        this.moveInternal(-this.buf.buffer.length());
                        this.killLine();
                        break;
                    }
                    case -48: {
                        this.buf.setOvertyping(!this.buf.isOvertyping());
                        break;
                    }
                    default: {
                        Object object;
                        if (n != 0) {
                            object = (ActionListener)this.triggeredActions.get(new Character((char)n));
                            if (object != null) {
                                object.actionPerformed(null);
                                break;
                            }
                            this.putChar(n, true);
                            break;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    this.beep();
                }
                this.flushConsole();
            }
        }
        finally {
            this.terminal.afterReadLine(this, this.prompt, c);
        }
    }

    private String readLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n;
        while ((n = inputStream.read()) != -1 && n != 10 && n != 13) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private int[] readBinding() throws IOException {
        int n = this.readVirtualKey();
        if (n == -1) {
            return null;
        }
        int n2 = this.keybindings[n];
        if (debugger != null) {
            ConsoleReader.debug("    translated: " + n + ": " + n2);
        }
        return new int[]{n, n2};
    }

    private final boolean moveHistory(boolean bl) throws IOException {
        if (bl && !this.history.next()) {
            return false;
        }
        if (!bl && !this.history.previous()) {
            return false;
        }
        this.setBuffer(this.history.current());
        return true;
    }

    public boolean paste() throws IOException {
        Clipboard clipboard;
        try {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception exception) {
            return false;
        }
        if (clipboard == null) {
            return false;
        }
        Transferable transferable = clipboard.getContents(null);
        if (transferable == null) {
            return false;
        }
        try {
            String string;
            Object object = transferable.getTransferData(DataFlavor.plainTextFlavor);
            if (object == null) {
                try {
                    object = new DataFlavor().getReaderForText(transferable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object == null) {
                return false;
            }
            if (object instanceof Reader) {
                string = "";
                String string2 = null;
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string.length() > 0) {
                        string = string + "\n";
                    }
                    string = string + string2;
                }
            } else {
                string = object.toString();
            }
            if (string == null) {
                return true;
            }
            this.putString(string);
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            if (debugger != null) {
                ConsoleReader.debug(unsupportedFlavorException + "");
            }
            return false;
        }
    }

    public boolean killLine() throws IOException {
        int n = this.buf.cursor;
        int n2 = this.buf.buffer.length();
        if (n >= n2) {
            return false;
        }
        int n3 = this.buf.buffer.length() - n;
        this.clearAhead(n3);
        for (int i = 0; i < n3; ++i) {
            this.buf.buffer.deleteCharAt(n2 - i - 1);
        }
        return true;
    }

    public boolean clearScreen() throws IOException {
        if (!this.terminal.isANSISupported()) {
            return false;
        }
        this.printString("\u001b[2J");
        this.flushConsole();
        this.printString("\u001b[1;1H");
        this.flushConsole();
        this.redrawLine();
        return true;
    }

    private final boolean complete() throws IOException {
        Completor completor;
        if (this.completors.size() == 0) {
            return false;
        }
        LinkedList linkedList = new LinkedList();
        String string = this.buf.buffer.toString();
        int n = this.buf.cursor;
        int n2 = -1;
        Iterator iterator = this.completors.iterator();
        while (iterator.hasNext() && (n2 = (completor = (Completor)iterator.next()).complete(string, n, linkedList)) == -1) {
        }
        if (linkedList.size() == 0) {
            return false;
        }
        return this.completionHandler.complete(this, linkedList, n2);
    }

    public CursorBuffer getCursorBuffer() {
        return this.buf;
    }

    public void printColumns(Collection collection) throws IOException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        int n = this.getTermwidth();
        int n2 = 0;
        Object object = collection.iterator();
        while (object.hasNext()) {
            n2 = Math.max(n2, object.next().toString().length());
        }
        object = new StringBuffer();
        int n3 = this.usePagination ? this.getTermheight() - 1 : Integer.MAX_VALUE;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (((StringBuffer)object).length() + n2 > n) {
                this.printString(((StringBuffer)object).toString().trim());
                this.printNewline();
                ((StringBuffer)object).setLength(0);
                if (--n3 == 0) {
                    this.printString(loc.getString("display-more"));
                    this.flushConsole();
                    int n4 = this.readVirtualKey();
                    if (n4 == 13 || n4 == 10) {
                        n3 = 1;
                    } else if (n4 != 113) {
                        n3 = this.getTermheight() - 1;
                    }
                    this.back(loc.getString("display-more").length());
                    if (n4 == 113) break;
                }
            }
            this.pad(string, n2 + 3, (StringBuffer)object);
        }
        if (((StringBuffer)object).length() > 0) {
            this.printString(((StringBuffer)object).toString().trim());
            this.printNewline();
            ((StringBuffer)object).setLength(0);
        }
    }

    private final void pad(String string, int n, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(' ');
        }
    }

    public boolean addCompletor(Completor completor) {
        return this.completors.add(completor);
    }

    public boolean removeCompletor(Completor completor) {
        return this.completors.remove(completor);
    }

    public Collection getCompletors() {
        return Collections.unmodifiableList(this.completors);
    }

    final boolean resetLine() throws IOException {
        if (this.buf.cursor == 0) {
            return false;
        }
        this.backspaceAll();
        return true;
    }

    public final boolean setCursorPosition(int n) throws IOException {
        return this.moveCursor(n - this.buf.cursor) != 0;
    }

    private final void setBuffer(String string) throws IOException {
        int n;
        if (string.equals(this.buf.buffer.toString())) {
            return;
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = this.buf.buffer.length();
        for (n = 0; n < n3 && n < n4 && string.charAt(n) == this.buf.buffer.charAt(n); ++n) {
            ++n2;
        }
        n = this.buf.buffer.length() - n2;
        this.backspace(n);
        this.killLine();
        this.buf.buffer.setLength(n2);
        this.putString(string.substring(n2));
    }

    public final void redrawLine() throws IOException {
        this.printCharacter(13);
        this.flushConsole();
        this.drawLine();
    }

    public final void drawLine() throws IOException {
        if (this.prompt != null) {
            this.printString(this.prompt);
        }
        this.printString(this.buf.buffer.toString());
        if (this.buf.length() != this.buf.cursor) {
            this.back(this.buf.length() - this.buf.cursor);
        }
    }

    public final void printNewline() throws IOException {
        this.printString(CR);
        this.flushConsole();
    }

    final String finishBuffer() {
        String string = this.buf.buffer.toString();
        if (string.length() > 0) {
            if (this.mask == null && this.useHistory) {
                this.history.addToHistory(string);
            } else {
                this.mask = null;
            }
        }
        this.history.moveToEnd();
        this.buf.buffer.setLength(0);
        this.buf.cursor = 0;
        return string;
    }

    public final void putString(String string) throws IOException {
        this.buf.write(string);
        this.printString(string);
        this.drawBuffer();
    }

    public final void printString(String string) throws IOException {
        this.printCharacters(string.toCharArray());
    }

    private final void putChar(int n, boolean bl) throws IOException {
        this.buf.write((char)n);
        if (bl) {
            if (this.mask == null) {
                this.printCharacter(n);
            } else if (this.mask.charValue() != '\u0000') {
                this.printCharacter(this.mask.charValue());
            }
            this.drawBuffer();
        }
    }

    private final void drawBuffer(int n) throws IOException {
        char[] cArray = this.buf.buffer.substring(this.buf.cursor).toCharArray();
        if (this.mask != null) {
            Arrays.fill(cArray, this.mask.charValue());
        }
        this.printCharacters(cArray);
        this.clearAhead(n);
        this.back(cArray.length);
        this.flushConsole();
    }

    private final void drawBuffer() throws IOException {
        this.drawBuffer(0);
    }

    private final void clearAhead(int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.printCharacters(' ', n);
        this.flushConsole();
        this.back(n);
        this.flushConsole();
    }

    private final void back(int n) throws IOException {
        this.printCharacters('\b', n);
        this.flushConsole();
    }

    public final void beep() throws IOException {
        if (!this.getBellEnabled()) {
            return;
        }
        this.printCharacter(7);
        this.flushConsole();
    }

    private final void printCharacter(int n) throws IOException {
        if (n == 9) {
            char[] cArray = new char[4];
            Arrays.fill(cArray, ' ');
            this.out.write(cArray);
            return;
        }
        this.out.write(n);
    }

    private final void printCharacters(char[] cArray) throws IOException {
        char[] cArray2;
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\t') {
                n += 4;
                continue;
            }
            ++n;
        }
        if (n == cArray.length) {
            cArray2 = cArray;
        } else {
            cArray2 = new char[n];
            int n2 = 0;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\t') {
                    Arrays.fill(cArray2, n2, n2 + 4, ' ');
                    n2 += 4;
                    continue;
                }
                cArray2[n2] = cArray[i];
                ++n2;
            }
        }
        this.out.write(cArray2);
    }

    private final void printCharacters(char c, int n) throws IOException {
        if (n == 1) {
            this.printCharacter(c);
        } else {
            char[] cArray = new char[n];
            Arrays.fill(cArray, c);
            this.printCharacters(cArray);
        }
    }

    public final void flushConsole() throws IOException {
        this.out.flush();
    }

    private final int backspaceAll() throws IOException {
        return this.backspace(Integer.MAX_VALUE);
    }

    private final int backspace(int n) throws IOException {
        if (this.buf.cursor == 0) {
            return 0;
        }
        int n2 = 0;
        n2 = this.moveCursor(-1 * n) * -1;
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + n2);
        this.drawBuffer(n2);
        return n2;
    }

    public final boolean backspace() throws IOException {
        return this.backspace(1) == 1;
    }

    private final boolean moveToEnd() throws IOException {
        if (this.moveCursor(1) == 0) {
            return false;
        }
        while (this.moveCursor(1) != 0) {
        }
        return true;
    }

    private final boolean deleteCurrentCharacter() throws IOException {
        boolean bl;
        boolean bl2 = bl = this.buf.buffer.length() > 0;
        if (!bl) {
            return false;
        }
        if (this.buf.cursor == this.buf.buffer.length()) {
            return false;
        }
        this.buf.buffer.deleteCharAt(this.buf.cursor);
        this.drawBuffer(1);
        return true;
    }

    private final boolean previousWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.moveCursor(-1) != 0) {
        }
        return true;
    }

    private final boolean nextWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.moveCursor(1) != 0) {
        }
        return true;
    }

    private final boolean deletePreviousWord() throws IOException {
        while (this.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        while (!this.isDelimiter(this.buf.current()) && this.backspace()) {
        }
        return true;
    }

    public final int moveCursor(int n) throws IOException {
        int n2 = n;
        if (this.buf.cursor == 0 && n2 < 0) {
            return 0;
        }
        if (this.buf.cursor == this.buf.buffer.length() && n2 > 0) {
            return 0;
        }
        if (this.buf.cursor + n2 < 0) {
            n2 = -this.buf.cursor;
        } else if (this.buf.cursor + n2 > this.buf.buffer.length()) {
            n2 = this.buf.buffer.length() - this.buf.cursor;
        }
        this.moveInternal(n2);
        return n2;
    }

    public static void debug(String string) {
        if (debugger != null) {
            debugger.println(string);
            debugger.flush();
        }
    }

    private final void moveInternal(int n) throws IOException {
        this.buf.cursor += n;
        if (n < 0) {
            int n2 = 0;
            for (int i = this.buf.cursor; i < this.buf.cursor - n; ++i) {
                if (this.buf.getBuffer().charAt(i) == '\t') {
                    n2 += 4;
                    continue;
                }
                ++n2;
            }
            char[] cArray = new char[n2];
            Arrays.fill(cArray, '\b');
            this.out.write(cArray);
            return;
        }
        if (this.buf.cursor == 0) {
            return;
        }
        if (this.mask == null) {
            this.printCharacters(this.buf.buffer.substring(this.buf.cursor - n, this.buf.cursor).toCharArray());
            return;
        }
        char c = this.mask.charValue();
        if (NULL_MASK.equals(this.mask)) {
            return;
        }
        this.printCharacters(c, Math.abs(n));
    }

    public final int readVirtualKey() throws IOException {
        int n = this.terminal.readVirtualKey(this.in);
        if (debugger != null) {
            ConsoleReader.debug("keystroke: " + n + "");
        }
        this.clearEcho(n);
        return n;
    }

    public final int readCharacter(char[] cArray) throws IOException {
        char c;
        Arrays.sort(cArray);
        while (Arrays.binarySearch(cArray, c = (char)this.readVirtualKey()) < 0) {
        }
        return c;
    }

    private final int delete(int n) throws IOException {
        this.buf.buffer.delete(this.buf.cursor, this.buf.cursor + 1);
        this.drawBuffer(1);
        return 1;
    }

    public final boolean replace(int n, String string) {
        this.buf.buffer.replace(this.buf.cursor - n, this.buf.cursor, string);
        try {
            this.moveCursor(-n);
            this.drawBuffer(Math.max(0, n - string.length()));
            this.moveCursor(string.length());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    public final boolean delete() throws IOException {
        return this.delete(1) == 1;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    public History getHistory() {
        return this.history;
    }

    public void setCompletionHandler(CompletionHandler completionHandler) {
        this.completionHandler = completionHandler;
    }

    public CompletionHandler getCompletionHandler() {
        return this.completionHandler;
    }

    public void setEchoCharacter(Character c) {
        this.echoCharacter = c;
    }

    public Character getEchoCharacter() {
        return this.echoCharacter;
    }

    private void consumeException(Throwable throwable) {
    }

    private boolean isDelimiter(char c) {
        return !Character.isLetterOrDigit(c);
    }

    public void setUseHistory(boolean bl) {
        this.useHistory = bl;
    }

    public boolean getUseHistory() {
        return this.useHistory;
    }

    public void setUsePagination(boolean bl) {
        this.usePagination = bl;
    }

    public boolean getUsePagination() {
        return this.usePagination;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TreeMap<String, Short> treeMap = new TreeMap<String, Short>();
        treeMap.put("MOVE_TO_BEG", new Short(-1));
        treeMap.put("MOVE_TO_END", new Short(-3));
        treeMap.put("PREV_CHAR", new Short(-4));
        treeMap.put("NEWLINE", new Short(-6));
        treeMap.put("KILL_LINE", new Short(-7));
        treeMap.put("PASTE", new Short(-60));
        treeMap.put("CLEAR_SCREEN", new Short(-8));
        treeMap.put("NEXT_HISTORY", new Short(-9));
        treeMap.put("PREV_HISTORY", new Short(-11));
        treeMap.put("START_OF_HISTORY", new Short(-61));
        treeMap.put("END_OF_HISTORY", new Short(-62));
        treeMap.put("REDISPLAY", new Short(-13));
        treeMap.put("KILL_LINE_PREV", new Short(-15));
        treeMap.put("DELETE_PREV_WORD", new Short(-16));
        treeMap.put("NEXT_CHAR", new Short(-19));
        treeMap.put("REPEAT_PREV_CHAR", new Short(-20));
        treeMap.put("SEARCH_PREV", new Short(-21));
        treeMap.put("REPEAT_NEXT_CHAR", new Short(-24));
        treeMap.put("SEARCH_NEXT", new Short(-25));
        treeMap.put("PREV_SPACE_WORD", new Short(-27));
        treeMap.put("TO_END_WORD", new Short(-29));
        treeMap.put("REPEAT_SEARCH_PREV", new Short(-34));
        treeMap.put("PASTE_PREV", new Short(-36));
        treeMap.put("REPLACE_MODE", new Short(-37));
        treeMap.put("SUBSTITUTE_LINE", new Short(-38));
        treeMap.put("TO_PREV_CHAR", new Short(-39));
        treeMap.put("NEXT_SPACE_WORD", new Short(-40));
        treeMap.put("DELETE_PREV_CHAR", new Short(-41));
        treeMap.put("ADD", new Short(-42));
        treeMap.put("PREV_WORD", new Short(-43));
        treeMap.put("CHANGE_META", new Short(-44));
        treeMap.put("DELETE_META", new Short(-45));
        treeMap.put("END_WORD", new Short(-46));
        treeMap.put("NEXT_CHAR", new Short(-19));
        treeMap.put("INSERT", new Short(-48));
        treeMap.put("REPEAT_SEARCH_NEXT", new Short(-49));
        treeMap.put("PASTE_NEXT", new Short(-50));
        treeMap.put("REPLACE_CHAR", new Short(-51));
        treeMap.put("SUBSTITUTE_CHAR", new Short(-52));
        treeMap.put("TO_NEXT_CHAR", new Short(-53));
        treeMap.put("UNDO", new Short(-54));
        treeMap.put("NEXT_WORD", new Short(-55));
        treeMap.put("DELETE_NEXT_CHAR", new Short(-56));
        treeMap.put("CHANGE_CASE", new Short(-57));
        treeMap.put("COMPLETE", new Short(-58));
        treeMap.put("EXIT", new Short(-59));
        treeMap.put("CLEAR_LINE", new Short(-63));
        KEYMAP_NAMES = new TreeMap(Collections.unmodifiableMap(treeMap));
        NULL_MASK = new Character('\u0000');
    }
}

