/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import jnr.netdb.NetDBEntry;
import jnr.netdb.NetDBParser;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileProtocolsDB
implements ProtocolsDB {
    private final File protocolsFile;

    public static final FileProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    FileProtocolsDB(File file) {
        this.protocolsFile = file;
    }

    private static final File locateProtocolsFile() {
        if (Platform.getPlatform().getOS().equals((Object)Platform.OS.WINDOWS)) {
            String string;
            try {
                string = System.getProperty("SystemRoot", "C:\\windows");
            }
            catch (SecurityException securityException) {
                string = "C:\\windows";
            }
            return new File(string + "\\system32\\drivers\\etc\\protocol");
        }
        return new File("/etc/protocols");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileProtocolsDB load() {
        try {
            File file = FileProtocolsDB.locateProtocolsFile();
            NetDBParser netDBParser = new NetDBParser(new FileReader(file));
            try {
                netDBParser.iterator().next();
            }
            finally {
                netDBParser.close();
            }
            return new FileProtocolsDB(file);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public Protocol getProtocolByName(final String string) {
        return this.parse(new Filter(){

            public boolean filter(Protocol protocol) {
                if (protocol.getName().equals(string)) {
                    return true;
                }
                for (String string2 : protocol.getAliases()) {
                    if (!string2.equals(string)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Protocol getProtocolByNumber(final Integer n) {
        return this.parse(new Filter(){

            public boolean filter(Protocol protocol) {
                return protocol.getProto() == n.intValue();
            }
        });
    }

    @Override
    public Collection<Protocol> getAllProtocols() {
        final LinkedList linkedList = new LinkedList();
        this.parse(new Filter(){

            public boolean filter(Protocol protocol) {
                linkedList.add(protocol);
                return false;
            }
        });
        return Collections.unmodifiableList(linkedList);
    }

    private final NetDBParser loadProtocolsFile() {
        try {
            return new NetDBParser(new FileReader(this.protocolsFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new NetDBParser(new StringReader(""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Protocol parse(Filter filter) {
        NetDBParser netDBParser = this.loadProtocolsFile();
        try {
            for (NetDBEntry netDBEntry : netDBParser) {
                try {
                    Protocol protocol = new Protocol(netDBEntry.name, Integer.parseInt(netDBEntry.data, 10), netDBEntry.aliases);
                    if (!filter.filter(protocol)) continue;
                    Protocol protocol2 = protocol;
                    return protocol2;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        finally {
            try {
                netDBParser.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    static /* synthetic */ FileProtocolsDB access$000() {
        return FileProtocolsDB.load();
    }

    private static interface Filter {
        public boolean filter(Protocol var1);
    }

    private static final class SingletonHolder {
        public static final FileProtocolsDB INSTANCE = FileProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

