/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import jnr.netdb.NetDBEntry;
import jnr.netdb.NetDBParser;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileServicesDB
implements ServicesDB {
    public static String fileName = "/etc/services";

    FileServicesDB() {
    }

    public static final ServicesDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ServicesDB load() {
        try {
            NetDBParser netDBParser = FileServicesDB.parseServicesFile();
            try {
                netDBParser.iterator().next();
            }
            finally {
                netDBParser.close();
            }
            return new FileServicesDB();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static final NetDBParser parseServicesFile() {
        try {
            return new NetDBParser(new FileReader(new File(fileName)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return new NetDBParser(new StringReader(""));
        }
    }

    private static final Service parseServicesEntry(NetDBEntry netDBEntry) {
        int n;
        String[] stringArray = netDBEntry.data.split("/");
        if (stringArray.length < 2) {
            return null;
        }
        try {
            n = Integer.parseInt(stringArray[0], 10);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Service(netDBEntry.name, n, stringArray[1], netDBEntry.aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Service parse(Filter filter) {
        NetDBParser netDBParser = FileServicesDB.parseServicesFile();
        try {
            for (NetDBEntry netDBEntry : netDBParser) {
                Service service = FileServicesDB.parseServicesEntry(netDBEntry);
                if (service == null || !filter.filter(service)) continue;
                Service service2 = service;
                return service2;
            }
        }
        finally {
            try {
                netDBParser.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    @Override
    public Service getServiceByName(final String string, final String string2) {
        return this.parse(new Filter(){

            public boolean filter(Service service) {
                if (!service.proto.equals(string2) && string2 != null) {
                    return false;
                }
                if (service.getName().equals(string)) {
                    return true;
                }
                for (String string3 : service.getAliases()) {
                    if (!string3.equals(string)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public Service getServiceByPort(final Integer n, final String string) {
        return this.parse(new Filter(){

            public boolean filter(Service service) {
                return service.getPort() == n.intValue() && (service.proto.equals(string) || string == null);
            }
        });
    }

    @Override
    public Collection<Service> getAllServices() {
        final LinkedList linkedList = new LinkedList();
        this.parse(new Filter(){

            public boolean filter(Service service) {
                linkedList.add(service);
                return false;
            }
        });
        return Collections.unmodifiableList(linkedList);
    }

    static /* synthetic */ ServicesDB access$000() {
        return FileServicesDB.load();
    }

    private static interface Filter {
        public boolean filter(Service var1);
    }

    private static final class SingletonHolder {
        public static final ServicesDB INSTANCE = FileServicesDB.access$000();

        private SingletonHolder() {
        }
    }
}

