/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IANAProtocolsDB
implements ProtocolsDB {
    private final Map<String, Protocol> nameToProto;
    private final Map<Integer, Protocol> numberToProto;

    public static final IANAProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private IANAProtocolsDB(Map<String, Protocol> map, Map<Integer, Protocol> map2) {
        this.nameToProto = map;
        this.numberToProto = map2;
    }

    @Override
    public Protocol getProtocolByName(String string) {
        return this.nameToProto.get(string);
    }

    @Override
    public Protocol getProtocolByNumber(Integer n) {
        return this.numberToProto.get(n);
    }

    @Override
    public Collection<Protocol> getAllProtocols() {
        return Collections.unmodifiableCollection(this.nameToProto.values());
    }

    private static final ProtocolDBBuilder initProtocolDB() {
        ProtocolDBBuilder protocolDBBuilder = new ProtocolDBBuilder();
        protocolDBBuilder.add("ip", 0, "IP");
        protocolDBBuilder.add("icmp", 1, "ICMP");
        protocolDBBuilder.add("igmp", 2, "IGMP");
        protocolDBBuilder.add("ggp", 3, "GGP");
        protocolDBBuilder.add("ipencap", 4, "IP-ENCAP");
        protocolDBBuilder.add("st2", 5, "ST2");
        protocolDBBuilder.add("tcp", 6, "TCP");
        protocolDBBuilder.add("cbt", 7, "CBT");
        protocolDBBuilder.add("egp", 8, "EGP");
        protocolDBBuilder.add("igp", 9, "IGP");
        protocolDBBuilder.add("bbn-rcc", 10, "BBN-RCC-MON");
        protocolDBBuilder.add("nvp", 11, "NVP-II");
        protocolDBBuilder.add("pup", 12, "PUP");
        protocolDBBuilder.add("argus", 13, "ARGUS");
        protocolDBBuilder.add("emcon", 14, "EMCON");
        protocolDBBuilder.add("xnet", 15, "XNET");
        protocolDBBuilder.add("chaos", 16, "CHAOS");
        protocolDBBuilder.add("udp", 17, "UDP");
        protocolDBBuilder.add("mux", 18, "MUX");
        protocolDBBuilder.add("dcn", 19, "DCN-MEAS");
        protocolDBBuilder.add("hmp", 20, "HMP");
        protocolDBBuilder.add("prm", 21, "PRM");
        protocolDBBuilder.add("xns-idp", 22, "XNS-IDP");
        protocolDBBuilder.add("trunk-1", 23, "TRUNK-1");
        protocolDBBuilder.add("trunk-2", 24, "TRUNK-2");
        protocolDBBuilder.add("leaf-1", 25, "LEAF-1");
        protocolDBBuilder.add("leaf-2", 26, "LEAF-2");
        protocolDBBuilder.add("rdp", 27, "RDP");
        protocolDBBuilder.add("irtp", 28, "IRTP");
        protocolDBBuilder.add("iso-tp4", 29, "ISO-TP4");
        protocolDBBuilder.add("netblt", 30, "NETBLT");
        protocolDBBuilder.add("mfe-nsp", 31, "MFE-NSP");
        protocolDBBuilder.add("merit-inp", 32, "MERIT-INP");
        protocolDBBuilder.add("sep", 33, "SEP");
        protocolDBBuilder.add("3pc", 34, "3PC");
        protocolDBBuilder.add("idpr", 35, "IDPR");
        protocolDBBuilder.add("xtp", 36, "XTP");
        protocolDBBuilder.add("ddp", 37, "DDP");
        protocolDBBuilder.add("idpr-cmtp", 38, "IDPR-CMTP");
        protocolDBBuilder.add("tp++", 39, "TP++");
        protocolDBBuilder.add("il", 40, "IL");
        protocolDBBuilder.add("ipv6", 41, "IPV6");
        protocolDBBuilder.add("sdrp", 42, "SDRP");
        protocolDBBuilder.add("ipv6-route", 43, "IPV6-ROUTE");
        protocolDBBuilder.add("ipv6-frag", 44, "IPV6-FRAG");
        protocolDBBuilder.add("idrp", 45, "IDRP");
        protocolDBBuilder.add("rsvp", 46, "RSVP");
        protocolDBBuilder.add("gre", 47, "GRE");
        protocolDBBuilder.add("mhrp", 48, "MHRP");
        protocolDBBuilder.add("bna", 49, "BNA");
        protocolDBBuilder.add("esp", 50, "ESP");
        protocolDBBuilder.add("ah", 51, "AH");
        protocolDBBuilder.add("i-nlsp", 52, "I-NLSP");
        protocolDBBuilder.add("swipe", 53, "SWIPE");
        protocolDBBuilder.add("narp", 54, "NARP");
        protocolDBBuilder.add("mobile", 55, "MOBILE");
        protocolDBBuilder.add("tlsp", 56, "TLSP");
        protocolDBBuilder.add("skip", 57, "SKIP");
        protocolDBBuilder.add("ipv6-icmp", 58, "IPV6-ICMP");
        protocolDBBuilder.add("ipv6-nonxt", 59, "IPV6-NONXT");
        protocolDBBuilder.add("ipv6-opts", 60, "IPV6-OPTS");
        protocolDBBuilder.add("cftp", 62, "CFTP");
        protocolDBBuilder.add("sat-expak", 64, "SAT-EXPAK");
        protocolDBBuilder.add("kryptolan", 65, "KRYPTOLAN");
        protocolDBBuilder.add("rvd", 66, "RVD");
        protocolDBBuilder.add("ippc", 67, "IPPC");
        protocolDBBuilder.add("sat-mon", 69, "SAT-MON");
        protocolDBBuilder.add("visa", 70, "VISA");
        protocolDBBuilder.add("ipcv", 71, "IPCV");
        protocolDBBuilder.add("cpnx", 72, "CPNX");
        protocolDBBuilder.add("cphb", 73, "CPHB");
        protocolDBBuilder.add("wsn", 74, "WSN");
        protocolDBBuilder.add("pvp", 75, "PVP");
        protocolDBBuilder.add("br-sat-mon", 76, "BR-SAT-MON");
        protocolDBBuilder.add("sun-nd", 77, "SUN-ND");
        protocolDBBuilder.add("wb-mon", 78, "WB-MON");
        protocolDBBuilder.add("wb-expak", 79, "WB-EXPAK");
        protocolDBBuilder.add("iso-ip", 80, "ISO-IP");
        protocolDBBuilder.add("vmtp", 81, "VMTP");
        protocolDBBuilder.add("secure-vmtp", 82, "SECURE-VMTP");
        protocolDBBuilder.add("vines", 83, "VINES");
        protocolDBBuilder.add("ttp", 84, "TTP");
        protocolDBBuilder.add("nsfnet-igp", 85, "NSFNET-IGP");
        protocolDBBuilder.add("dgp", 86, "DGP");
        protocolDBBuilder.add("tcf", 87, "TCF");
        protocolDBBuilder.add("eigrp", 88, "EIGRP");
        protocolDBBuilder.add("ospf", 89, "OSPFIGP");
        protocolDBBuilder.add("sprite-rpc", 90, "Sprite-RPC");
        protocolDBBuilder.add("larp", 91, "LARP");
        protocolDBBuilder.add("mtp", 92, "MTP");
        protocolDBBuilder.add("ax.25", 93, "AX.25");
        protocolDBBuilder.add("ipip", 94, "IPIP");
        protocolDBBuilder.add("micp", 95, "MICP");
        protocolDBBuilder.add("scc-sp", 96, "SCC-SP");
        protocolDBBuilder.add("etherip", 97, "ETHERIP");
        protocolDBBuilder.add("encap", 98, "ENCAP");
        protocolDBBuilder.add("gmtp", 100, "GMTP");
        protocolDBBuilder.add("ifmp", 101, "IFMP");
        protocolDBBuilder.add("pnni", 102, "PNNI");
        protocolDBBuilder.add("pim", 103, "PIM");
        protocolDBBuilder.add("aris", 104, "ARIS");
        protocolDBBuilder.add("scps", 105, "SCPS");
        protocolDBBuilder.add("qnx", 106, "QNX");
        protocolDBBuilder.add("a/n", 107, "A/N");
        protocolDBBuilder.add("ipcomp", 108, "IPComp");
        protocolDBBuilder.add("snp", 109, "SNP");
        protocolDBBuilder.add("compaq-peer", 110, "Compaq-Peer");
        protocolDBBuilder.add("ipx-in-ip", 111, "IPX-in-IP");
        protocolDBBuilder.add("vrrp", 112, "VRRP");
        protocolDBBuilder.add("pgm", 113, "PGM");
        protocolDBBuilder.add("l2tp", 115, "L2TP");
        protocolDBBuilder.add("ddx", 116, "DDX");
        protocolDBBuilder.add("iatp", 117, "IATP");
        protocolDBBuilder.add("st", 118, "ST");
        protocolDBBuilder.add("srp", 119, "SRP");
        protocolDBBuilder.add("uti", 120, "UTI");
        protocolDBBuilder.add("smp", 121, "SMP");
        protocolDBBuilder.add("sm", 122, "SM");
        protocolDBBuilder.add("ptp", 123, "PTP");
        protocolDBBuilder.add("isis", 124, "ISIS");
        protocolDBBuilder.add("fire", 125, "FIRE");
        protocolDBBuilder.add("crtp", 126, "CRTP");
        protocolDBBuilder.add("crdup", 127, "CRUDP");
        protocolDBBuilder.add("sscopmce", 128, "SSCOPMCE");
        protocolDBBuilder.add("iplt", 129, "IPLT");
        protocolDBBuilder.add("sps", 130, "SPS");
        protocolDBBuilder.add("pipe", 131, "PIPE");
        protocolDBBuilder.add("sctp", 132, "SCTP");
        protocolDBBuilder.add("fc", 133, "FC");
        protocolDBBuilder.add("divert", 254, "DIVERT");
        return protocolDBBuilder;
    }

    static /* synthetic */ ProtocolDBBuilder access$000() {
        return IANAProtocolsDB.initProtocolDB();
    }

    private static final class ProtocolDBBuilder {
        private static final List<String> emptyAliases = Collections.emptyList();
        private final Map<String, Protocol> nameToProto = new HashMap<String, Protocol>();
        private final Map<Integer, Protocol> numberToProto = new HashMap<Integer, Protocol>();

        private ProtocolDBBuilder() {
        }

        public void add(String string, int n, String ... stringArray) {
            ArrayList<String> arrayList = stringArray.length > 0 ? new ArrayList<String>(Arrays.asList(stringArray)) : emptyAliases;
            Protocol protocol = new Protocol(string, n, arrayList);
            this.nameToProto.put(string, protocol);
            for (String string2 : stringArray) {
                this.nameToProto.put(string2, protocol);
            }
            this.numberToProto.put(n, protocol);
        }

        public IANAProtocolsDB build() {
            return new IANAProtocolsDB(this.nameToProto, this.numberToProto);
        }
    }

    private static final class SingletonHolder {
        public static final IANAProtocolsDB INSTANCE = IANAProtocolsDB.access$000().build();

        private SingletonHolder() {
        }
    }
}

