/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.struct.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;
import jnr.netdb.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeProtocolsDB
implements ProtocolsDB {
    private final LibProto lib;

    public static final NativeProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    NativeProtocolsDB(LibProto libProto) {
        this.lib = libProto;
    }

    private static final NativeProtocolsDB load() {
        try {
            LibProto libProto;
            Platform.OS oS = Platform.getPlatform().getOS();
            if (!(oS.equals((Object)Platform.OS.DARWIN) || oS.equals((Object)Platform.OS.WINDOWS) && Platform.getPlatform().getCPU() == Platform.CPU.I386 || oS.equals((Object)Platform.OS.LINUX) || oS.equals((Object)Platform.OS.SOLARIS) || oS.equals((Object)Platform.OS.FREEBSD) || oS.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (oS.equals((Object)Platform.OS.WINDOWS)) {
                HashMap<LibraryOption, CallingConvention> hashMap = new HashMap<LibraryOption, CallingConvention>();
                hashMap.put(LibraryOption.CallingConvention, CallingConvention.STDCALL);
                libProto = Library.loadLibrary(LibProto.class, hashMap, "Ws2_32");
            } else {
                String[] stringArray;
                if (oS.equals((Object)Platform.OS.SOLARIS)) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                String[] stringArray4 = stringArray;
                libProto = Library.loadLibrary(LibProto.class, stringArray4);
            }
            libProto.getprotobyname("ip");
            libProto.getprotobynumber(0);
            return new NativeProtocolsDB(libProto);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private final Protocol protocolFromNative(UnixProtoent unixProtoent) {
        if (unixProtoent == null) {
            return null;
        }
        List list = Collections.emptyList();
        Pointer pointer = unixProtoent.aliases.get();
        List<String> list2 = pointer != null ? StringUtil.getNullTerminatedStringArray(pointer) : list;
        return new Protocol(unixProtoent.name.get(), (short)unixProtoent.proto.get(), list2);
    }

    @Override
    public Protocol getProtocolByName(String string) {
        return this.protocolFromNative(this.lib.getprotobyname(string));
    }

    @Override
    public Protocol getProtocolByNumber(Integer n) {
        return this.protocolFromNative(this.lib.getprotobynumber(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Protocol> getAllProtocols() {
        ArrayList<Protocol> arrayList = new ArrayList<Protocol>();
        try {
            UnixProtoent unixProtoent;
            while ((unixProtoent = this.lib.getprotoent()) != null) {
                arrayList.add(this.protocolFromNative(unixProtoent));
            }
        }
        finally {
            this.lib.endprotoent();
        }
        return arrayList;
    }

    static /* synthetic */ NativeProtocolsDB access$000() {
        return NativeProtocolsDB.load();
    }

    public static interface LibProto {
        public UnixProtoent getprotobyname(String var1);

        public UnixProtoent getprotobynumber(int var1);

        public UnixProtoent getprotoent();

        public void endprotoent();
    }

    private static final class SingletonHolder {
        public static final NativeProtocolsDB INSTANCE = NativeProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }

    public static class UnixProtoent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef();
        public final Struct.Pointer aliases = new Struct.Pointer();
        public final Struct.Signed32 proto = new Struct.Signed32();
    }
}

