/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.Collection;
import jnr.netdb.FileProtocolsDB;
import jnr.netdb.IANAProtocolsDB;
import jnr.netdb.NativeProtocolsDB;
import jnr.netdb.ProtocolsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Protocol {
    private final String protocolName;
    private final int proto;
    private final Collection<String> aliases;

    Protocol(String string, int n, Collection<String> collection) {
        this.protocolName = string;
        this.proto = n;
        this.aliases = collection;
    }

    public static final Protocol getProtocolByName(String string) {
        return Protocol.getProtocolDB().getProtocolByName(string);
    }

    public static final Protocol getProtocolByNumber(int n) {
        return Protocol.getProtocolDB().getProtocolByNumber(n);
    }

    public final String getName() {
        return this.protocolName;
    }

    public final int getProto() {
        return this.proto;
    }

    public final Collection<String> getAliases() {
        return this.aliases;
    }

    private static final ProtocolsDB getProtocolDB() {
        return ProtocolDBSingletonHolder.INSTANCE;
    }

    public String toString() {
        return String.format("<Protocol: Name: %s, Proto: %d, Aliases: %s>", this.protocolName, this.proto, this.aliases);
    }

    private static final class ProtocolDBSingletonHolder {
        static final ProtocolsDB INSTANCE = ProtocolDBSingletonHolder.load();

        private ProtocolDBSingletonHolder() {
        }

        private static final ProtocolsDB load() {
            ProtocolsDB protocolsDB = NativeProtocolsDB.getInstance();
            if (protocolsDB == null) {
                protocolsDB = FileProtocolsDB.getInstance();
            }
            return protocolsDB != null ? protocolsDB : IANAProtocolsDB.getInstance();
        }
    }
}

