/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.python.antlr.ParseException;
import org.python.antlr.PythonLexer;
import org.python.antlr.runtime.CommonToken;
import org.python.antlr.runtime.CommonTokenStream;
import org.python.antlr.runtime.Token;
import org.python.antlr.runtime.TokenSource;
import org.python.core.Py;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonTokenSource
implements TokenSource {
    public static final int MAX_INDENTS = 100;
    public static final int FIRST_CHAR_POSITION = 0;
    int[] indentStack = new int[100];
    int sp = -1;
    Vector<Token> tokens = new Vector();
    CommonTokenStream stream;
    int lastTokenAddedIndex = -1;
    String filename;
    boolean inSingle;

    public PythonTokenSource(PythonLexer pythonLexer) {
    }

    public PythonTokenSource(CommonTokenStream commonTokenStream, String string) {
        this(commonTokenStream, string, false);
    }

    public PythonTokenSource(CommonTokenStream commonTokenStream, String string, boolean bl) {
        this.stream = commonTokenStream;
        this.filename = string;
        this.inSingle = bl;
        this.push(0);
    }

    @Override
    public Token nextToken() {
        if (this.tokens.size() > 0) {
            Token token = this.tokens.firstElement();
            this.tokens.removeElementAt(0);
            return token;
        }
        this.insertImaginaryIndentDedentTokens();
        return this.nextToken();
    }

    private void generateNewline(Token token) {
        CommonToken commonToken = new CommonToken(7, "\n");
        commonToken.setLine(token.getLine());
        commonToken.setCharPositionInLine(token.getCharPositionInLine());
        this.tokens.addElement(commonToken);
    }

    private void handleEOF(CommonToken commonToken, CommonToken commonToken2) {
        if (commonToken2 != null) {
            commonToken.setStartIndex(commonToken2.getStopIndex());
            commonToken.setStopIndex(commonToken2.getStopIndex());
            commonToken.setLine(commonToken2.getLine());
            commonToken.setCharPositionInLine(commonToken2.getCharPositionInLine());
        }
    }

    protected void insertImaginaryIndentDedentTokens() {
        Token token = this.stream.LT(1);
        this.stream.consume();
        if (token.getType() == -1) {
            Token token2 = this.stream.LT(-1);
            this.handleEOF((CommonToken)token, (CommonToken)token2);
            if (!this.inSingle) {
                if (token2 == null) {
                    this.generateNewline(token);
                } else if (token2.getType() == 8) {
                    this.handleDedents(-1, (CommonToken)token);
                    this.generateNewline(token);
                } else if (token2.getType() != 7) {
                    this.generateNewline(token);
                    this.handleDedents(-1, (CommonToken)token);
                }
            } else {
                this.handleDedents(-1, (CommonToken)token);
            }
            this.enqueue(token);
        } else if (token.getType() == 7) {
            this.enqueueHiddens(token);
            this.tokens.addElement(token);
            Token token3 = token;
            token = this.stream.LT(1);
            this.stream.consume();
            List<Token> list = this.enqueueHiddens(token);
            int n = token.getCharPositionInLine();
            if (token.getType() == -1) {
                this.handleEOF((CommonToken)token, (CommonToken)token3);
                n = -1;
            } else if (token.getType() == 8) {
                Token token4 = this.stream.LT(1);
                if (token4 != null && token4.getType() == -1) {
                    this.stream.consume();
                    return;
                }
                n = token.getText().length();
            }
            int n2 = this.peek();
            if (n > n2) {
                this.handleIndents(n, (CommonToken)token);
            } else if (n < n2) {
                this.handleDedents(n, (CommonToken)token);
            }
            if (token.getType() == -1 && this.inSingle) {
                String string = token3.getText();
                for (int i = 1; i < string.length(); ++i) {
                    this.generateNewline(token3);
                }
                for (Token token5 : list) {
                    this.generateNewline(token5);
                }
            }
            if (token.getType() != 8) {
                this.tokens.addElement(token);
            }
        } else {
            this.enqueue(token);
        }
    }

    private void enqueue(Token token) {
        this.enqueueHiddens(token);
        this.tokens.addElement(token);
    }

    private List<Token> enqueueHiddens(Token token) {
        Object object;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        if (this.inSingle && token.getType() == -1 && this.stream.size() > this.lastTokenAddedIndex + 1 && (object = this.stream.get(this.lastTokenAddedIndex + 1)).getType() == 96) {
            String string = object.getText();
            int n = string.indexOf("\n");
            while (n != -1) {
                arrayList.add((Token)object);
                n = string.indexOf("\n", n + 1);
            }
        }
        if ((object = this.stream.getTokens(this.lastTokenAddedIndex + 1, token.getTokenIndex() - 1)) != null) {
            this.tokens.addAll((Collection<Token>)object);
        }
        this.lastTokenAddedIndex = token.getTokenIndex();
        return arrayList;
    }

    private void handleIndents(int n, CommonToken commonToken) {
        this.push(n);
        CommonToken commonToken2 = new CommonToken(4, "");
        commonToken2.setCharPositionInLine(commonToken.getCharPositionInLine());
        commonToken2.setLine(commonToken.getLine());
        commonToken2.setStartIndex(commonToken.getStartIndex() - 1);
        commonToken2.setStopIndex(commonToken.getStartIndex() - 1);
        this.tokens.addElement(commonToken2);
    }

    private void handleDedents(int n, CommonToken commonToken) {
        int n2 = this.findPreviousIndent(n, commonToken);
        for (int i = this.sp - 1; i >= n2; --i) {
            CommonToken commonToken2 = new CommonToken(5, "");
            commonToken2.setCharPositionInLine(commonToken.getCharPositionInLine());
            commonToken2.setLine(commonToken.getLine());
            commonToken2.setStartIndex(commonToken.getStartIndex() - 1);
            commonToken2.setStopIndex(commonToken.getStartIndex() - 1);
            this.tokens.addElement(commonToken2);
        }
        this.sp = n2;
    }

    protected void push(int n) {
        if (this.sp >= 100) {
            throw new IllegalStateException("stack overflow");
        }
        ++this.sp;
        this.indentStack[this.sp] = n;
    }

    protected int pop() {
        if (this.sp < 0) {
            throw new IllegalStateException("stack underflow");
        }
        int n = this.indentStack[this.sp];
        --this.sp;
        return n;
    }

    protected int peek() {
        return this.indentStack[this.sp];
    }

    protected int findPreviousIndent(int n, Token token) {
        for (int i = this.sp - 1; i >= 0; --i) {
            if (this.indentStack[i] != n) continue;
            return i;
        }
        if (n == -1 || n == -2) {
            return 0;
        }
        ParseException parseException = new ParseException("unindent does not match any outer indentation level", token.getLine(), token.getCharPositionInLine());
        parseException.setType(Py.IndentationError);
        throw parseException;
    }

    public String stackString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.sp; i >= 0; --i) {
            stringBuffer.append(" ");
            stringBuffer.append(this.indentStack[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getSourceName() {
        return this.filename;
    }
}

