/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.python.compiler.Code;
import org.python.core.imp;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.ClassWriter;
import org.python.objectweb.asm.FieldVisitor;
import org.python.objectweb.asm.MethodVisitor;

public class ClassFile {
    ClassWriter cw;
    int access;
    long mtime;
    public String name;
    String superclass;
    String sfilename;
    String[] interfaces;
    List<MethodVisitor> methodVisitors;
    List<FieldVisitor> fieldVisitors;

    public static String fixName(String string) {
        if (string.indexOf(46) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '.') continue;
            cArray[i] = 47;
        }
        return new String(cArray);
    }

    public ClassFile(String string) {
        this(string, "java/lang/Object", 33, -1L);
    }

    public ClassFile(String string, String string2, int n) {
        this(string, string2, n, -1L);
    }

    public ClassFile(String string, String string2, int n, long l) {
        this.name = ClassFile.fixName(string);
        this.superclass = ClassFile.fixName(string2);
        this.interfaces = new String[0];
        this.access = n;
        this.mtime = l;
        this.cw = new ClassWriter(2);
        this.methodVisitors = Collections.synchronizedList(new ArrayList());
        this.fieldVisitors = Collections.synchronizedList(new ArrayList());
    }

    public void setSource(String string) {
        this.sfilename = string;
    }

    public void addInterface(String string) throws IOException {
        String[] stringArray = new String[this.interfaces.length + 1];
        System.arraycopy(this.interfaces, 0, stringArray, 0, this.interfaces.length);
        stringArray[this.interfaces.length] = string;
        this.interfaces = stringArray;
    }

    public Code addMethod(String string, String string2, int n) throws IOException {
        MethodVisitor methodVisitor = this.cw.visitMethod(n, string, string2, null, null);
        Code code = new Code(methodVisitor, string2, n);
        this.methodVisitors.add(code);
        return code;
    }

    public void addField(String string, String string2, int n) throws IOException {
        FieldVisitor fieldVisitor = this.cw.visitField(n, string, string2, null, null);
        this.fieldVisitors.add(fieldVisitor);
    }

    public void endFields() throws IOException {
        for (FieldVisitor fieldVisitor : this.fieldVisitors) {
            fieldVisitor.visitEnd();
        }
    }

    public void endMethods() throws IOException {
        for (int i = 0; i < this.methodVisitors.size(); ++i) {
            MethodVisitor methodVisitor = this.methodVisitors.get(i);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        this.cw.visit(49, 33, this.name, null, this.superclass, this.interfaces);
        AnnotationVisitor annotationVisitor = this.cw.visitAnnotation("Lorg/python/compiler/APIVersion;", true);
        annotationVisitor.visit("value", new Integer(imp.getAPIVersion()));
        annotationVisitor.visitEnd();
        annotationVisitor = this.cw.visitAnnotation("Lorg/python/compiler/MTime;", true);
        annotationVisitor.visit("value", new Long(this.mtime));
        annotationVisitor.visitEnd();
        if (this.sfilename != null) {
            this.cw.visitSource(this.sfilename, null);
        }
        this.endFields();
        this.endMethods();
        byte[] byArray = this.cw.toByteArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byteArrayOutputStream.writeTo(outputStream);
        byteArrayOutputStream.close();
    }
}

