/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.BitSet;
import java.util.Vector;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.Attribute;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.MethodVisitor;
import org.python.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Code
implements MethodVisitor,
Opcodes {
    MethodVisitor mv;
    String sig;
    String[] locals;
    int nlocals;
    int argcount;
    int returnLocal;
    BitSet finallyLocals = new BitSet();

    public Code(MethodVisitor methodVisitor, String string, int n) {
        this.mv = methodVisitor;
        this.sig = string;
        this.nlocals = -this.sigSize(string, false);
        if ((n & 8) != 8) {
            ++this.nlocals;
        }
        this.argcount = this.nlocals;
        this.locals = new String[this.nlocals + 128];
    }

    public int getLocal(String string) {
        for (int i = this.argcount; i < this.nlocals; ++i) {
            if (this.locals[i] != null) continue;
            this.locals[i] = string;
            return i;
        }
        if (this.nlocals >= this.locals.length) {
            String[] stringArray = new String[this.locals.length * 2];
            System.arraycopy(this.locals, 0, stringArray, 0, this.locals.length);
            this.locals = stringArray;
        }
        this.locals[this.nlocals] = string;
        ++this.nlocals;
        return this.nlocals - 1;
    }

    public void freeLocal(int n) {
        if (this.locals[n] == null) {
            System.out.println("Double free:" + n);
        }
        this.locals[n] = null;
    }

    public int getFinallyLocal(String string) {
        int n = this.getLocal(string);
        this.finallyLocals.set(n);
        return n;
    }

    public void freeFinallyLocal(int n) {
        this.finallyLocals.clear(n);
        this.freeLocal(n);
    }

    public int getReturnLocal() {
        if (this.returnLocal == 0) {
            this.returnLocal = this.getLocal("return");
        }
        return this.returnLocal;
    }

    public Vector<String> getActiveLocals() {
        Vector<String> vector = new Vector<String>();
        vector.setSize(this.nlocals);
        for (int i = this.argcount; i < this.nlocals; ++i) {
            if (i == this.returnLocal || this.finallyLocals.get(i)) continue;
            vector.setElementAt(this.locals[i], i);
        }
        return vector;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        return this.mv.visitAnnotation(string, bl);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return this.mv.visitAnnotationDefault();
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.mv.visitAttribute(attribute);
    }

    @Override
    public void visitCode() {
        this.mv.visitCode();
    }

    @Override
    public void visitEnd() {
        this.mv.visitEnd();
    }

    @Override
    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.mv.visitFieldInsn(n, string, string2, string3);
    }

    @Override
    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.mv.visitFrame(n, n2, objectArray, n3, objectArray2);
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.mv.visitIincInsn(n, n2);
    }

    @Override
    public void visitInsn(int n) {
        this.mv.visitInsn(n);
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.mv.visitIntInsn(n, n2);
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        this.mv.visitJumpInsn(n, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.mv.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object object) {
        this.mv.visitLdcInsn(object);
    }

    @Override
    public void visitLineNumber(int n, Label label) {
        this.mv.visitLineNumber(n, label);
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.mv.visitLocalVariable(string, string2, string3, label, label2, n);
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.mv.visitMaxs(n, n2);
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.mv.visitMethodInsn(n, string, string2, string3);
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int n) {
        this.mv.visitMultiANewArrayInsn(string, n);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        return this.mv.visitParameterAnnotation(n, string, bl);
    }

    @Override
    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        this.mv.visitTableSwitchInsn(n, n2, label, labelArray);
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.mv.visitTryCatchBlock(label, label2, label3, string);
    }

    @Override
    public void visitTypeInsn(int n, String string) {
        this.mv.visitTypeInsn(n, string);
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        this.mv.visitVarInsn(n, n2);
    }

    private int sigSize(String string, boolean bl) {
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        boolean bl2 = false;
        boolean bl3 = false;
        block7: while (++n2 < n3) {
            switch (cArray[n2]) {
                case ')': {
                    if (!bl) {
                        return n;
                    }
                    bl2 = true;
                    continue block7;
                }
                case '[': {
                    bl3 = true;
                    continue block7;
                }
                case 'V': {
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    if (bl3) {
                        n = bl2 ? ++n : --n;
                        bl3 = false;
                        continue block7;
                    }
                    if (bl2) {
                        n += 2;
                        continue block7;
                    }
                    n -= 2;
                    continue block7;
                }
                case 'L': {
                    while (cArray[++n2] != ';') {
                    }
                    break;
                }
            }
            n = bl2 ? ++n : --n;
            bl3 = false;
        }
        return n;
    }

    public void aaload() {
        this.mv.visitInsn(50);
    }

    public void aastore() {
        this.mv.visitInsn(83);
    }

    public void aconst_null() {
        this.mv.visitInsn(1);
    }

    public void aload(int n) {
        this.mv.visitVarInsn(25, n);
    }

    public void anewarray(String string) {
        this.mv.visitTypeInsn(189, string);
    }

    public void areturn() {
        this.mv.visitInsn(176);
    }

    public void arraylength() {
        this.mv.visitInsn(190);
    }

    public void astore(int n) {
        this.mv.visitVarInsn(58, n);
    }

    public void athrow() {
        this.mv.visitInsn(191);
    }

    public void baload() {
        this.mv.visitInsn(51);
    }

    public void bastore() {
        this.mv.visitInsn(84);
    }

    public void bipush(int n) {
        this.mv.visitIntInsn(16, n);
    }

    public void checkcast(String string) {
        this.mv.visitTypeInsn(192, string);
    }

    public void dconst_0() {
        this.mv.visitInsn(14);
    }

    public void dload(int n) {
        this.mv.visitVarInsn(24, n);
    }

    public void dreturn() {
        this.mv.visitInsn(175);
    }

    public void dup() {
        this.mv.visitInsn(89);
    }

    public void dup2() {
        this.mv.visitInsn(92);
    }

    public void dup_x1() {
        this.mv.visitInsn(90);
    }

    public void dup_x2() {
        this.mv.visitInsn(91);
    }

    public void dup2_x1() {
        this.mv.visitInsn(93);
    }

    public void dup2_x2() {
        this.mv.visitInsn(94);
    }

    public void fconst_0() {
        this.mv.visitInsn(11);
    }

    public void fload(int n) {
        this.mv.visitVarInsn(23, n);
    }

    public void freturn() {
        this.mv.visitInsn(174);
    }

    public void getfield(String string, String string2, String string3) {
        this.mv.visitFieldInsn(180, string, string2, string3);
    }

    public void getstatic(String string, String string2, String string3) {
        this.mv.visitFieldInsn(178, string, string2, string3);
    }

    public void goto_(Label label) {
        this.mv.visitJumpInsn(167, label);
    }

    public void iconst(int n) {
        if (n <= 127 && n >= -128) {
            switch (n) {
                case -1: {
                    this.iconst_m1();
                    break;
                }
                case 0: {
                    this.iconst_0();
                    break;
                }
                case 1: {
                    this.iconst_1();
                    break;
                }
                case 2: {
                    this.iconst_2();
                    break;
                }
                case 3: {
                    this.iconst_3();
                    break;
                }
                case 4: {
                    this.iconst_4();
                    break;
                }
                case 5: {
                    this.iconst_5();
                    break;
                }
                default: {
                    this.bipush(n);
                    break;
                }
            }
        } else if (n <= Short.MAX_VALUE && n >= Short.MIN_VALUE) {
            this.sipush(n);
        } else {
            this.ldc(n);
        }
    }

    public void iconst_m1() {
        this.mv.visitInsn(2);
    }

    public void iconst_0() {
        this.mv.visitInsn(3);
    }

    public void iconst_1() {
        this.mv.visitInsn(4);
    }

    public void iconst_2() {
        this.mv.visitInsn(5);
    }

    public void iconst_3() {
        this.mv.visitInsn(6);
    }

    public void iconst_4() {
        this.mv.visitInsn(7);
    }

    public void iconst_5() {
        this.mv.visitInsn(8);
    }

    public void ifeq(Label label) {
        this.mv.visitJumpInsn(153, label);
    }

    public void ifle(Label label) {
        this.mv.visitJumpInsn(158, label);
    }

    public void ifne(Label label) {
        this.mv.visitJumpInsn(154, label);
    }

    public void ifnull(Label label) {
        this.mv.visitJumpInsn(198, label);
    }

    public void ifnonnull(Label label) {
        this.mv.visitJumpInsn(199, label);
    }

    public void if_acmpne(Label label) {
        this.mv.visitJumpInsn(166, label);
    }

    public void if_acmpeq(Label label) {
        this.mv.visitJumpInsn(165, label);
    }

    public void if_icmple(Label label) {
        this.mv.visitJumpInsn(164, label);
    }

    public void if_icmpgt(Label label) {
        this.mv.visitJumpInsn(163, label);
    }

    public void if_icmplt(Label label) {
        this.mv.visitJumpInsn(161, label);
    }

    public void if_icmpne(Label label) {
        this.mv.visitJumpInsn(160, label);
    }

    public void if_icmpeq(Label label) {
        this.mv.visitJumpInsn(159, label);
    }

    public void iadd() {
        this.mv.visitInsn(96);
    }

    public void iaload() {
        this.mv.visitInsn(46);
    }

    public void iinc() {
        this.mv.visitInsn(132);
    }

    public void iload(int n) {
        this.mv.visitVarInsn(21, n);
    }

    public void instanceof_(String string) {
        this.mv.visitTypeInsn(193, string);
    }

    public void invokeinterface(String string, String string2, String string3) {
        this.mv.visitMethodInsn(185, string, string2, string3);
    }

    public void invokespecial(String string, String string2, String string3) {
        this.mv.visitMethodInsn(183, string, string2, string3);
    }

    public void invokestatic(String string, String string2, String string3) {
        this.mv.visitMethodInsn(184, string, string2, string3);
    }

    public void invokevirtual(String string, String string2, String string3) {
        this.mv.visitMethodInsn(182, string, string2, string3);
    }

    public void ireturn() {
        this.mv.visitInsn(172);
    }

    public void istore(int n) {
        this.mv.visitVarInsn(54, n);
    }

    public void isub() {
        this.mv.visitInsn(100);
    }

    public void label(Label label) {
        this.mv.visitLabel(label);
    }

    public void lconst_0() {
        this.mv.visitInsn(9);
    }

    public void ldc(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            int n = string.length();
            int n2 = 16000;
            if (n > 16000) {
                this.new_("java/lang/StringBuilder");
                this.dup();
                this.iconst(n);
                this.invokespecial("java/lang/StringBuilder", "<init>", "(I)V");
                for (int i = 0; i < n; i += 16000) {
                    int n3 = i + 16000;
                    if (n3 > n) {
                        n3 = n;
                    }
                    this.mv.visitLdcInsn(string.substring(i, n3));
                    this.invokevirtual("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                }
                this.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
            } else {
                this.mv.visitLdcInsn(string);
            }
        } else {
            this.mv.visitLdcInsn(object);
        }
    }

    public void lload(int n) {
        this.mv.visitVarInsn(22, n);
    }

    public void lreturn() {
        this.mv.visitInsn(173);
    }

    public void newarray(int n) {
        this.mv.visitIntInsn(188, n);
    }

    public void new_(String string) {
        this.mv.visitTypeInsn(187, string);
    }

    public void nop() {
        this.mv.visitInsn(0);
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void pop2() {
        this.mv.visitInsn(88);
    }

    public void putstatic(String string, String string2, String string3) {
        this.mv.visitFieldInsn(179, string, string2, string3);
    }

    public void putfield(String string, String string2, String string3) {
        this.mv.visitFieldInsn(181, string, string2, string3);
    }

    public void ret(int n) {
        this.mv.visitVarInsn(169, n);
    }

    void return_() {
        this.mv.visitInsn(177);
    }

    public void sipush(int n) {
        this.mv.visitIntInsn(17, n);
    }

    public void swap() {
        this.mv.visitInsn(95);
    }

    public void swap2() {
        this.dup2_x2();
        this.pop2();
    }

    public void tableswitch(int n, int n2, Label label, Label[] labelArray) {
        this.mv.visitTableSwitchInsn(n, n2, label, labelArray);
    }

    public void trycatch(Label label, Label label2, Label label3, String string) {
        this.mv.visitTryCatchBlock(label, label2, label3, string);
    }

    public void setline(int n) {
        this.mv.visitLineNumber(n, new Label());
    }
}

