/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.python.antlr.ParseException;
import org.python.antlr.ast.Expr;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.Module;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.alias;
import org.python.antlr.base.mod;
import org.python.antlr.base.stmt;
import org.python.core.CodeFlag;
import org.python.core.CompilerFlags;
import org.python.core.FutureFeature;
import org.python.core.Pragma;
import org.python.core.PragmaReceiver;

public class Future {
    Set<FutureFeature> featureSet = EnumSet.noneOf(FutureFeature.class);
    private final PragmaReceiver features = new PragmaReceiver(){

        public void add(Pragma pragma) {
            if (pragma instanceof FutureFeature) {
                FutureFeature futureFeature = (FutureFeature)pragma;
                Future.this.featureSet.add(futureFeature);
            }
        }
    };

    private boolean check(ImportFrom importFrom) throws Exception {
        if (!importFrom.getInternalModule().equals("__future__")) {
            return false;
        }
        if (importFrom.getInternalNames().isEmpty()) {
            throw new ParseException("future statement does not support import *", importFrom);
        }
        try {
            for (alias alias2 : importFrom.getInternalNames()) {
                FutureFeature.addFeature(alias2.getInternalName(), this.features);
            }
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), importFrom);
        }
        return true;
    }

    public void preprocessFutures(mod mod2, CompilerFlags compilerFlags) throws Exception {
        stmt object2;
        if (compilerFlags != null) {
            if (compilerFlags.isFlagSet(CodeFlag.CO_FUTURE_DIVISION)) {
                FutureFeature.division.addTo(this.features);
            }
            if (compilerFlags.isFlagSet(CodeFlag.CO_FUTURE_WITH_STATEMENT)) {
                FutureFeature.with_statement.addTo(this.features);
            }
            if (compilerFlags.isFlagSet(CodeFlag.CO_FUTURE_ABSOLUTE_IMPORT)) {
                FutureFeature.absolute_import.addTo(this.features);
            }
        }
        int n = 0;
        List<stmt> list = null;
        if (mod2 instanceof Module) {
            list = ((Module)mod2).getInternalBody();
            if (list.size() > 0 && list.get(0) instanceof Expr && ((Expr)list.get(0)).getInternalValue() instanceof Str) {
                ++n;
            }
        } else if (mod2 instanceof Interactive) {
            list = ((Interactive)mod2).getInternalBody();
        } else {
            return;
        }
        for (int i = n; i < list.size() && (object2 = list.get(i)) instanceof ImportFrom; ++i) {
            object2.from_future_checked = true;
            if (!this.check((ImportFrom)object2)) break;
        }
        if (compilerFlags != null) {
            for (FutureFeature futureFeature : this.featureSet) {
                futureFeature.setFlag(compilerFlags);
            }
        }
    }

    public static void checkFromFuture(ImportFrom importFrom) throws Exception {
        if (importFrom.from_future_checked) {
            return;
        }
        if (importFrom.getInternalModule().equals("__future__")) {
            throw new ParseException("from __future__ imports must occur at the beginning of the file", importFrom);
        }
        importFrom.from_future_checked = true;
    }

    public boolean areDivisionOn() {
        return this.featureSet.contains(FutureFeature.division);
    }

    public boolean withStatementSupported() {
        return this.featureSet.contains(FutureFeature.with_statement);
    }

    public boolean isAbsoluteImportOn() {
        return this.featureSet.contains(FutureFeature.absolute_import);
    }
}

