/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.python.antlr.ast.Suite;
import org.python.antlr.base.mod;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.CodeCompiler;
import org.python.compiler.Constant;
import org.python.compiler.Module;
import org.python.compiler.ScopeInfo;
import org.python.core.CodeFlag;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyFunctionTable;
import org.python.objectweb.asm.Opcodes;
import org.python.util.CodegenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PyCodeConstant
extends Constant
implements ClassConstants,
Opcodes {
    final String co_name;
    final int argcount;
    final List<String> names;
    final int id;
    final int co_firstlineno;
    final boolean arglist;
    final boolean keywordlist;
    final String fname;
    final List<String> cellvars;
    final List<String> freevars;
    final int jy_npurecell;
    final int moreflags;

    PyCodeConstant(mod mod2, String string, boolean bl, String string2, boolean bl2, boolean bl3, int n, ScopeInfo scopeInfo, CompilerFlags compilerFlags, Module module) throws Exception {
        this.co_name = string;
        this.co_firstlineno = n;
        this.module = module;
        int n2 = 0;
        if (scopeInfo.ac != null) {
            this.arglist = scopeInfo.ac.arglist;
            this.keywordlist = scopeInfo.ac.keywordlist;
            this.argcount = scopeInfo.ac.names.size();
            if (scopeInfo.ac.init_code.size() > 0) {
                scopeInfo.ac.appendInitCode((Suite)mod2);
            }
        } else {
            this.arglist = false;
            this.keywordlist = false;
            this.argcount = 0;
        }
        this.id = module.codes.size();
        this.fname = this.isJavaIdentifier(string) ? string + "$" + this.id : "f$" + this.id;
        this.name = this.fname;
        this.names = !bl2 ? this.toNameAr(scopeInfo.names, false) : null;
        this.cellvars = this.toNameAr(scopeInfo.cellvars, true);
        this.freevars = this.toNameAr(scopeInfo.freevars, true);
        this.jy_npurecell = scopeInfo.jy_npurecell;
        if (CodeCompiler.checkOptimizeGlobals(bl, scopeInfo)) {
            n2 |= CodeFlag.CO_OPTIMIZED.flag;
        }
        if (scopeInfo.generator) {
            n2 |= CodeFlag.CO_GENERATOR.flag;
        }
        if (compilerFlags != null) {
            if (compilerFlags.isFlagSet(CodeFlag.CO_GENERATOR_ALLOWED)) {
                n2 |= CodeFlag.CO_GENERATOR_ALLOWED.flag;
            }
            if (compilerFlags.isFlagSet(CodeFlag.CO_FUTURE_DIVISION)) {
                n2 |= CodeFlag.CO_FUTURE_DIVISION.flag;
            }
        }
        this.moreflags = n2;
    }

    private List<String> toNameAr(List<String> list, boolean bl) {
        int n = list.size();
        if (n == 0 && bl) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(list);
        return arrayList;
    }

    private boolean isJavaIdentifier(String string) {
        char[] cArray = string.toCharArray();
        if (cArray.length == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(cArray[0])) {
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (Character.isJavaIdentifierPart(cArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    void get(Code code) throws IOException {
        code.getstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyCode.class));
    }

    @Override
    void put(Code code) throws IOException {
        int n;
        this.module.classfile.addField(this.name, CodegenUtils.ci(PyCode.class), access);
        code.iconst(this.argcount);
        int n2 = this.names != null ? CodeCompiler.makeStrings(code, this.names) : CodeCompiler.makeStrings(code, null);
        code.aload(n2);
        code.freeLocal(n2);
        code.aload(1);
        code.ldc(this.co_name);
        code.iconst(this.co_firstlineno);
        code.iconst(this.arglist ? 1 : 0);
        code.iconst(this.keywordlist ? 1 : 0);
        code.getstatic(this.module.classfile.name, "self", "L" + this.module.classfile.name + ";");
        code.iconst(this.id);
        if (this.cellvars != null) {
            n = CodeCompiler.makeStrings(code, this.cellvars);
            code.aload(n);
            code.freeLocal(n);
        } else {
            code.aconst_null();
        }
        if (this.freevars != null) {
            n = CodeCompiler.makeStrings(code, this.freevars);
            code.aload(n);
            code.freeLocal(n);
        } else {
            code.aconst_null();
        }
        code.iconst(this.jy_npurecell);
        code.iconst(this.moreflags);
        code.invokestatic(CodegenUtils.p(Py.class), "newCode", CodegenUtils.sig(PyCode.class, Integer.TYPE, String[].class, String.class, String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, PyFunctionTable.class, Integer.TYPE, String[].class, String[].class, Integer.TYPE, Integer.TYPE));
        code.putstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyCode.class));
    }
}

