/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.Constant;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.objectweb.asm.Opcodes;
import org.python.util.CodegenUtils;

class PyFloatConstant
extends Constant
implements ClassConstants,
Opcodes {
    final double value;

    PyFloatConstant(double d) {
        this.value = d;
    }

    void get(Code code) throws IOException {
        code.getstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyFloat.class));
    }

    void put(Code code) throws IOException {
        this.module.classfile.addField(this.name, CodegenUtils.ci(PyFloat.class), access);
        code.ldc(new Double(this.value));
        code.invokestatic(CodegenUtils.p(Py.class), "newFloat", CodegenUtils.sig(PyFloat.class, Double.TYPE));
        code.putstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyFloat.class));
    }

    public int hashCode() {
        return (int)this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof PyFloatConstant) {
            return ((PyFloatConstant)object).value == this.value;
        }
        return false;
    }
}

