/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.Constant;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.objectweb.asm.Opcodes;
import org.python.util.CodegenUtils;

class PyIntegerConstant
extends Constant
implements ClassConstants,
Opcodes {
    final int value;

    PyIntegerConstant(int n) {
        this.value = n;
    }

    void get(Code code) throws IOException {
        code.getstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyInteger.class));
    }

    void put(Code code) throws IOException {
        this.module.classfile.addField(this.name, CodegenUtils.ci(PyInteger.class), access);
        code.iconst(this.value);
        code.invokestatic(CodegenUtils.p(Py.class), "newInteger", CodegenUtils.sig(PyInteger.class, Integer.TYPE));
        code.putstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyInteger.class));
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof PyIntegerConstant) {
            return ((PyIntegerConstant)object).value == this.value;
        }
        return false;
    }
}

