/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.IOException;
import org.python.compiler.ClassConstants;
import org.python.compiler.Code;
import org.python.compiler.Constant;
import org.python.core.PyString;
import org.python.objectweb.asm.Opcodes;
import org.python.util.CodegenUtils;

class PyStringConstant
extends Constant
implements ClassConstants,
Opcodes {
    final String value;

    PyStringConstant(String string) {
        this.value = string;
    }

    void get(Code code) throws IOException {
        code.getstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyString.class));
    }

    void put(Code code) throws IOException {
        this.module.classfile.addField(this.name, CodegenUtils.ci(PyString.class), access);
        code.ldc(this.value);
        code.invokestatic(CodegenUtils.p(PyString.class), "fromInterned", CodegenUtils.sig(PyString.class, String.class));
        code.putstatic(this.module.classfile.name, this.name, CodegenUtils.ci(PyString.class));
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof PyStringConstant) {
            return ((PyStringConstant)object).value.equals(this.value);
        }
        return false;
    }
}

