/*
 * Decompiled with CFR 0.152.
 */
package org.python.constantine;

import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.python.constantine.Constant;
import org.python.constantine.Platform;
import org.python.constantine.platform.Errno;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantSet
extends AbstractSet<Constant> {
    private final ConcurrentMap<String, Constant> nameToConstant;
    private final ConcurrentMap<Integer, Constant> valueToConstant;
    private final Set<Constant> constants;
    private final Class<Enum> enumClass;
    private volatile Long minValue;
    private volatile Long maxValue;
    private static final ConcurrentMap<String, ConstantSet> constantSets = new ConcurrentHashMap<String, ConstantSet>();
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantSet getConstantSet(String string) {
        ConstantSet constantSet = (ConstantSet)constantSets.get(string);
        if (constantSet == null) {
            Object object = lock;
            synchronized (object) {
                if (!constantSets.containsKey(string)) {
                    Class<Enum> clazz = ConstantSet.getEnumClass(string);
                    if (clazz == null) {
                        return null;
                    }
                    if (!Constant.class.isAssignableFrom(clazz)) {
                        throw new ClassCastException("class for " + string + " does not implement Constant interface");
                    }
                    constantSet = new ConstantSet(clazz);
                    constantSets.put(string, constantSet);
                }
            }
        }
        return constantSet;
    }

    private static final Class<Enum> getEnumClass(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{Platform.getPlatform().getPackageName(), Platform.getPlatform().getOSPackageName(), Platform.class.getPackage().getName() + ".platform.fake"}) {
            try {
                return Class.forName(string2 + "." + string).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private ConstantSet(Class<Enum> clazz) {
        this.enumClass = clazz;
        this.nameToConstant = new ConcurrentHashMap<String, Constant>();
        this.valueToConstant = new ConcurrentHashMap<Integer, Constant>();
        this.constants = EnumSet.allOf(clazz);
    }

    public Constant getConstant(String string) {
        Constant constant = (Constant)this.nameToConstant.get(string);
        if (constant == null) {
            try {
                constant = (Constant)Constant.class.cast(Enum.valueOf(this.enumClass, string));
                this.nameToConstant.put(string, constant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return constant;
    }

    public Constant getConstant(int n) {
        Constant constant = (Constant)this.valueToConstant.get(n);
        if (constant == null && constant == null) {
            for (Constant constant2 : this.constants) {
                if (constant2.value() != n) continue;
                constant = constant2;
                break;
            }
            if (constant != null) {
                this.valueToConstant.put(n, constant);
            }
        }
        return constant;
    }

    public int getValue(String string) {
        Constant constant = this.getConstant(string);
        return constant != null ? constant.value() : 0;
    }

    public String getName(int n) {
        Constant constant = this.getConstant(n);
        return constant != null ? constant.name() : "unknown";
    }

    private Long getLongField(String string, long l) {
        try {
            Field field = this.enumClass.getField("MIN_VALUE");
            return (Long)field.get(this.enumClass);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return l;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public long minValue() {
        if (this.minValue == null) {
            this.minValue = this.getLongField("MIN_VALUE", Integer.MIN_VALUE);
        }
        return this.minValue.intValue();
    }

    public long maxValue() {
        if (this.maxValue == null) {
            this.maxValue = this.getLongField("MAX_VALUE", Integer.MAX_VALUE);
        }
        return this.maxValue.intValue();
    }

    @Override
    public Iterator<Constant> iterator() {
        return new ConstantIterator(this.constants);
    }

    @Override
    public int size() {
        return this.constants.size();
    }

    @Override
    public boolean contains(Object object) {
        return object != null && object.getClass().equals(this.enumClass);
    }

    public static void main(String[] stringArray) {
        ConstantSet constantSet = ConstantSet.getConstantSet("Errno");
        for (Constant constant : constantSet) {
            System.out.println(constant.name() + "=" + constant.value());
        }
        Errno errno2 = Errno.valueOf(22);
        System.out.println("errno for 22=" + errno2);
        System.out.println("errno for 101=" + Errno.valueOf(101));
        System.out.println("errno for 22=" + Errno.valueOf(22));
        System.out.println("EINVAL.value() = " + Errno.EINVAL.value());
        System.out.println("E2BIG.value() = " + Errno.E2BIG.value());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConstantIterator
    implements Iterator<Constant> {
        private final Iterator<Constant> it;

        ConstantIterator(Collection<Constant> collection) {
            this.it = collection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Constant next() {
            return this.it.next();
        }
    }
}

