/*
 * Decompiled with CFR 0.152.
 */
package org.python.constantine;

import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;

public class Platform {
    private static final Platform INSTANCE = new Platform();
    public static final Map<String, String> OS_NAMES = new HashMap<String, String>(){
        public static final long serialVersionUID = 1L;
        {
            this.put("Mac OS X", "darwin");
        }
    };
    public static final Map<String, String> ARCH_NAMES = new HashMap<String, String>(){
        public static final long serialVersionUID = 1L;
        {
            this.put("x86", "i386");
        }
    };
    public static final String ARCH = Platform.initArchitecture();
    public static final String OS = Platform.initOperatingSystem();
    public static final String NAME = String.format("%s-%s", ARCH, OS);
    public static final int BIG_ENDIAN = 4321;
    public static final int LITTLE_ENDIAN = 1234;
    public static final int BYTE_ORDER = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? 4321 : 1234;

    public static Platform getPlatform() {
        return INSTANCE;
    }

    protected Platform() {
    }

    public String getPackageName() {
        return String.format("%s.platform.%s.%s", Platform.class.getPackage().getName(), OS, ARCH);
    }

    public String getOSPackageName() {
        return String.format("%s.platform.%s", Platform.class.getPackage().getName(), OS);
    }

    private static final String initOperatingSystem() {
        String string = Platform.getProperty("os.name", "unknown").toLowerCase();
        for (String string2 : OS_NAMES.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return OS_NAMES.get(string2);
        }
        if (string.startsWith("windows")) {
            return "windows";
        }
        return string;
    }

    private static final String initArchitecture() {
        String string = Platform.getProperty("os.arch", "unknown").toLowerCase();
        for (String string2 : ARCH_NAMES.keySet()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return ARCH_NAMES.get(string2);
        }
        return string;
    }

    private static String getProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }
}

