/*
 * Decompiled with CFR 0.152.
 */
package org.python.constantine.platform.windows;

import java.util.EnumMap;
import java.util.Map;
import org.python.constantine.Constant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Errno implements Constant
{
    E2BIG(7),
    ENFILE(23),
    EPERM(1),
    EDEADLK(36),
    EBADF(9),
    EMFILE(24),
    ENXIO(6),
    ECHILD(10),
    ERANGE(34),
    EBUSY(16),
    EAGAIN(11),
    ESPIPE(29),
    EFBIG(27),
    EINVAL(22),
    EXDEV(18),
    EACCES(13),
    EIO(5),
    EDOM(33),
    ENOTEMPTY(41),
    ENOLCK(39),
    EINTR(4),
    ENOTDIR(20),
    EROFS(30),
    EISDIR(21),
    ENOMEM(12),
    ENODEV(19),
    ENOSPC(28),
    ENOEXEC(8),
    ENOSYS(40),
    EEXIST(17),
    ENOTTY(25),
    ENAMETOOLONG(38),
    EPIPE(32),
    ESRCH(3),
    EILSEQ(42),
    EFAULT(14),
    ENOENT(2),
    EMLINK(31);

    private final int value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 42L;

    private Errno(int n2) {
        this.value = n2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    @Override
    public final int value() {
        return this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> enumMap = new EnumMap<Errno, String>(Errno.class);
            enumMap.put(E2BIG, "Arg list too long");
            enumMap.put(ENFILE, "Too many open files in system");
            enumMap.put(EPERM, "Operation not permitted");
            enumMap.put(EDEADLK, "Resource deadlock avoided");
            enumMap.put(EBADF, "Bad file descriptor");
            enumMap.put(EMFILE, "Too many open files");
            enumMap.put(ENXIO, "No such device or address");
            enumMap.put(ECHILD, "No child processes");
            enumMap.put(ERANGE, "Result too large");
            enumMap.put(EBUSY, "Resource device");
            enumMap.put(EAGAIN, "Resource temporarily unavailable");
            enumMap.put(ESPIPE, "Invalid seek");
            enumMap.put(EFBIG, "File too large");
            enumMap.put(EINVAL, "Invalid argument");
            enumMap.put(EXDEV, "Improper link");
            enumMap.put(EACCES, "Permission denied");
            enumMap.put(EIO, "Input/output error");
            enumMap.put(EDOM, "Domain error");
            enumMap.put(ENOTEMPTY, "Directory not empty");
            enumMap.put(ENOLCK, "No locks available");
            enumMap.put(EINTR, "Interrupted function call");
            enumMap.put(ENOTDIR, "Not a directory");
            enumMap.put(EROFS, "Read-only file system");
            enumMap.put(EISDIR, "Is a directory");
            enumMap.put(ENOMEM, "Not enough space");
            enumMap.put(ENODEV, "No such device");
            enumMap.put(ENOSPC, "No space left on device");
            enumMap.put(ENOEXEC, "Exec format error");
            enumMap.put(ENOSYS, "Function not implemented");
            enumMap.put(EEXIST, "File exists");
            enumMap.put(ENOTTY, "Inappropriate I/O control operation");
            enumMap.put(ENAMETOOLONG, "Filename too long");
            enumMap.put(EPIPE, "Broken pipe");
            enumMap.put(ESRCH, "No such process");
            enumMap.put(EILSEQ, "Illegal byte sequence");
            enumMap.put(EFAULT, "Bad address");
            enumMap.put(ENOENT, "No such file or directory");
            enumMap.put(EMLINK, "Too many links");
            return enumMap;
        }
    }
}

