/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.antlr.base.mod;
import org.python.core.ArgParser;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.ParserFacade;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;

class CompileFunction
extends PyBuiltinFunction {
    CompileFunction() {
        super("compile", "compile(source, filename, mode[, flags[, dont_inherit]]) -> code object\n\nCompile the source string (a Python module, statement or expression)\ninto a code object that can be executed by the exec statement or eval().\nThe filename will be used for run-time error messages.\nThe mode must be 'exec' to compile a module, 'single' to compile a\nsingle (interactive) statement, or 'eval' to compile an expression.\nThe flags argument, if present, controls which future statements influence\nthe compilation of the code.\nThe dont_inherit argument, if non-zero, stops the compilation inheriting\nthe effects of any future statements in effect in the code calling\ncompile; if absent or zero these statements do influence the compilation,\nin addition to any features explicitly specified.");
    }

    public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("compile", pyObjectArray, stringArray, new String[]{"source", "filename", "mode", "flags", "dont_inherit"}, 3);
        PyObject pyObject = argParser.getPyObject(0);
        String string = argParser.getString(1);
        String string2 = argParser.getString(2);
        int n = argParser.getInt(3, 0);
        boolean bl = argParser.getPyObject(4, Py.False).__nonzero__();
        return CompileFunction.compile(pyObject, string, string2, n, bl);
    }

    public static PyObject compile(PyObject pyObject, String string, String string2) {
        return CompileFunction.compile(pyObject, string, string2, 0, false);
    }

    public static PyObject compile(PyObject pyObject, String string, String string2, int n, boolean bl) {
        CompilerFlags compilerFlags = Py.getCompilerFlags(n, bl);
        CompileMode compileMode = CompileMode.getMode(string2);
        return CompileFunction.compile(pyObject, string, compileMode, compilerFlags, bl);
    }

    public static PyObject compile(PyObject pyObject, String string, CompileMode compileMode, CompilerFlags compilerFlags, boolean bl) {
        compilerFlags = Py.getCompilerFlags(compilerFlags, bl);
        mod mod2 = CompileFunction.py2node(pyObject);
        if (mod2 == null) {
            if (!(pyObject instanceof PyString)) {
                throw Py.TypeError("expected a readable buffer object");
            }
            compilerFlags.source_is_utf8 = pyObject instanceof PyUnicode;
            String string2 = pyObject.toString();
            if (string2.contains("\u0000")) {
                throw Py.TypeError("compile() expected string without null bytes");
            }
            string2 = compilerFlags != null && compilerFlags.dont_imply_dedent ? string2 + "\n" : string2 + "\n\n";
            mod2 = ParserFacade.parse(string2, compileMode, string, compilerFlags);
        }
        if (compilerFlags.only_ast) {
            return Py.java2py(mod2);
        }
        return Py.compile_flags(mod2, string, compileMode, compilerFlags);
    }

    private static mod py2node(PyObject pyObject) {
        Object object = pyObject.__tojava__(mod.class);
        if (object == Py.NoConversion) {
            return null;
        }
        return (mod)object;
    }
}

