/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.CodeFlag;
import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class ContextGuard
implements ContextManager {
    private final PyObject __enter__method;
    private final PyObject __exit__method;

    private ContextGuard(PyObject pyObject) {
        this.__exit__method = pyObject.__getattr__("__exit__");
        this.__enter__method = pyObject.__getattr__("__enter__");
    }

    public PyObject __enter__(ThreadState threadState) {
        return this.__enter__method.__call__(threadState);
    }

    public boolean __exit__(ThreadState threadState, PyException pyException) {
        PyObject pyObject;
        PyObject pyObject2;
        PyObject pyObject3;
        if (pyException != null) {
            pyObject3 = pyException.type;
            pyObject2 = pyException.value;
            pyObject = pyException.traceback;
        } else {
            pyObject2 = pyObject = Py.None;
            pyObject3 = pyObject;
        }
        return this.__exit__method.__call__(threadState, pyObject3, pyObject2 == null ? Py.None : pyObject2, pyObject == null ? Py.None : pyObject).__nonzero__();
    }

    public static ContextManager getManager(PyObject pyObject) {
        if (pyObject instanceof ContextManager) {
            return (ContextManager)((Object)pyObject);
        }
        return new ContextGuard(pyObject);
    }

    public static PyObject makeManager(PyObject pyObject) {
        if (pyObject instanceof PyFunction) {
            PyFunction pyFunction = (PyFunction)pyObject;
            PyCode pyCode = pyFunction.func_code;
            if (pyCode instanceof PyBaseCode) {
                PyBaseCode pyBaseCode = (PyBaseCode)pyCode;
                if (pyBaseCode.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
                    return new PyFunction(pyFunction.func_globals, pyFunction.func_defaults, new ContextCode(pyBaseCode), pyFunction.__doc__, pyFunction.func_closure == null ? null : ((PyTuple)pyFunction.func_closure).getArray());
                }
            }
        }
        throw Py.TypeError("Argument must be a generator function.");
    }

    private static class ContextCode
    extends PyBaseCode {
        private final PyBaseCode code;

        ContextCode(PyBaseCode pyBaseCode) {
            this.co_name = pyBaseCode.co_name;
            this.code = pyBaseCode;
            this.co_argcount = pyBaseCode.co_argcount;
            this.nargs = pyBaseCode.nargs;
            this.co_firstlineno = pyBaseCode.co_firstlineno;
            this.co_varnames = pyBaseCode.co_varnames;
            this.co_cellvars = pyBaseCode.co_cellvars;
            this.jy_npurecell = pyBaseCode.jy_npurecell;
            this.co_freevars = pyBaseCode.co_freevars;
            this.co_filename = pyBaseCode.co_filename;
            this.co_nlocals = pyBaseCode.co_nlocals;
            this.varargs = pyBaseCode.varargs;
            this.varkwargs = pyBaseCode.varkwargs;
            for (CodeFlag codeFlag : CodeFlag.values()) {
                if (!pyBaseCode.co_flags.isFlagSet(codeFlag) || codeFlag == CodeFlag.CO_GENERATOR) continue;
                this.co_flags.setFlag(codeFlag);
            }
        }

        protected PyObject interpret(PyFrame pyFrame, ThreadState threadState) {
            pyFrame.f_back = null;
            return new GeneratorContextManager(pyFrame){

                PyObject body(ThreadState threadState) {
                    return ContextCode.this.code.interpret(this.frame, threadState);
                }
            };
        }

        public PyObject call(ThreadState threadState, PyFrame pyFrame, final PyObject pyObject) {
            pyFrame.f_back = null;
            return new GeneratorContextManager(pyFrame){

                PyObject body(ThreadState threadState) {
                    return ContextCode.this.code.call(threadState, this.frame, pyObject);
                }
            };
        }
    }

    private static abstract class GeneratorContextManager
    extends PyObject
    implements ContextManager {
        final PyFrame frame;

        public GeneratorContextManager(PyFrame pyFrame) {
            this.frame = pyFrame;
        }

        public PyObject __enter__(ThreadState threadState) {
            PyObject pyObject = this.body(threadState);
            if (this.frame.f_lasti == -1) {
                throw Py.RuntimeError("generator didn't yield");
            }
            return pyObject;
        }

        public boolean __exit__(ThreadState threadState, PyException pyException) {
            PyObject pyObject;
            if (pyException != null) {
                this.frame.setGeneratorInput(pyException);
            }
            try {
                pyObject = this.body(threadState);
            }
            catch (PyException pyException2) {
                if (pyException2.equals(pyException)) {
                    return false;
                }
                throw pyException2;
            }
            if (this.frame.f_lasti != -1) {
                throw Py.RuntimeError("generator didn't stop");
            }
            return pyObject.__nonzero__();
        }

        abstract PyObject body(ThreadState var1);
    }
}

