/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.modules._systemrestart;

public class FunctionThread
extends Thread {
    private final PyObject func;
    private final PyObject[] args;
    private final PySystemState systemState;

    public FunctionThread(PyObject pyObject, PyObject[] pyObjectArray, long l, ThreadGroup threadGroup) {
        super(threadGroup, null, "Thread", l);
        this.func = pyObject;
        this.args = pyObjectArray;
        this.systemState = Py.getSystemState();
    }

    public void run() {
        Py.setSystemState(this.systemState);
        try {
            this.func.__call__(this.args);
        }
        catch (PyException pyException) {
            if (pyException.match(Py.SystemExit) || pyException.match(_systemrestart.SystemRestart)) {
                return;
            }
            Py.stderr.println("Unhandled exception in thread started by " + this.func);
            Py.printException(pyException);
        }
    }

    public String toString() {
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            return String.format("FunctionThread[%s,%s,%s]", this.getName(), this.getPriority(), threadGroup.getName());
        }
        return String.format("FunctionThread[%s,%s]", this.getName(), this.getPriority());
    }
}

