/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Set;
import org.python.antlr.base.mod;
import org.python.constantine.Constant;
import org.python.constantine.platform.Errno;
import org.python.core.CodeBootstrap;
import org.python.core.CodeLoader;
import org.python.core.CompileMode;
import org.python.core.CompilerFacade;
import org.python.core.CompilerFlags;
import org.python.core.FixedFileWrapper;
import org.python.core.IdImpl;
import org.python.core.JavaCode;
import org.python.core.JavaFunc;
import org.python.core.Options;
import org.python.core.ParserFacade;
import org.python.core.PyBaseCode;
import org.python.core.PyBoolean;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyClass;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyFrozenSet;
import org.python.core.PyFunctionTable;
import org.python.core.PyGenerator;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaType;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyRunnable;
import org.python.core.PyRunnableBootstrap;
import org.python.core.PySequenceList;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTableCode;
import org.python.core.PyTraceback;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.StdoutWrapper;
import org.python.core.ThreadState;
import org.python.core.ThreadStateMapping;
import org.python.core.__builtin__;
import org.python.core.adapter.ClassicPyObjectAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.imp;
import org.python.modules.posix.PosixModule;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Py {
    public static PyObject None;
    public static PyObject Ellipsis;
    public static PyObject NotImplemented;
    public static String[] NoKeywords;
    public static PyObject[] EmptyObjects;
    public static PyFrozenSet EmptyFrozenSet;
    public static PyTuple EmptyTuple;
    public static PyInteger Zero;
    public static PyInteger One;
    public static PyBoolean False;
    public static PyBoolean True;
    public static PyString EmptyString;
    public static PyString Newline;
    public static PyString Space;
    public static long TPFLAGS_HEAPTYPE;
    public static long TPFLAGS_BASETYPE;
    static final Set<Class<?>> BOOTSTRAP_TYPES;
    public static Object NoConversion;
    public static PyObject OSError;
    public static PyObject NotImplementedError;
    public static PyObject EnvironmentError;
    public static PyObject OverflowError;
    public static PyObject RuntimeError;
    public static PyObject KeyboardInterrupt;
    public static PyObject FloatingPointError;
    public static PyObject SyntaxError;
    public static PyObject IndentationError;
    public static PyObject TabError;
    public static PyObject AttributeError;
    public static PyObject IOError;
    public static PyObject KeyError;
    public static PyObject AssertionError;
    public static PyObject TypeError;
    public static PyObject ReferenceError;
    public static PyObject SystemError;
    public static PyObject IndexError;
    public static PyObject ZeroDivisionError;
    public static PyObject NameError;
    public static PyObject UnboundLocalError;
    public static PyObject SystemExit;
    public static PyObject StopIteration;
    public static PyObject GeneratorExit;
    public static PyObject ImportError;
    public static PyObject ValueError;
    public static PyObject UnicodeError;
    public static PyObject UnicodeTranslateError;
    public static PyObject UnicodeDecodeError;
    public static PyObject UnicodeEncodeError;
    public static PyObject EOFError;
    public static PyObject MemoryError;
    public static PyObject ArithmeticError;
    public static PyObject LookupError;
    public static PyObject StandardError;
    public static PyObject Exception;
    public static PyObject BaseException;
    public static PyObject Warning;
    public static PyObject UserWarning;
    public static PyObject DeprecationWarning;
    public static PyObject PendingDeprecationWarning;
    public static PyObject SyntaxWarning;
    public static PyObject RuntimeWarning;
    public static PyObject FutureWarning;
    public static PyObject ImportWarning;
    public static PyObject UnicodeWarning;
    private static PyObject warnings_mod;
    public static PyObject JavaError;
    private static final PyInteger[] integerCache;
    public static volatile PySystemState defaultSystemState;
    private static boolean syspathJavaLoaderRestricted;
    private static final ThreadStateMapping threadStateMapping;
    public static StdoutWrapper stderr;
    static StdoutWrapper stdout;
    private static final PyString[] letters;
    private static ExtensiblePyObjectAdapter adapter;
    private static int nameindex;
    private static IdImpl idimpl;
    public static final int ERROR = -1;
    public static final int WARNING = 0;
    public static final int MESSAGE = 1;
    public static final int COMMENT = 2;
    public static final int DEBUG = 3;

    public static PyException OSError(String string) {
        return new PyException(OSError, string);
    }

    public static PyException OSError(IOException iOException) {
        return Py.fromIOException(iOException, OSError);
    }

    public static PyException OSError(Constant constant) {
        int n = constant.value();
        PyTuple pyTuple = new PyTuple(Py.newInteger(n), PosixModule.strerror(n));
        return new PyException(OSError, pyTuple);
    }

    public static PyException OSError(Constant constant, String string) {
        int n = constant.value();
        PyTuple pyTuple = new PyTuple(Py.newInteger(n), PosixModule.strerror(n), Py.newString(string));
        return new PyException(OSError, pyTuple);
    }

    public static PyException NotImplementedError(String string) {
        return new PyException(NotImplementedError, string);
    }

    public static PyException EnvironmentError(String string) {
        return new PyException(EnvironmentError, string);
    }

    public static PyException OverflowError(String string) {
        return new PyException(OverflowError, string);
    }

    public static PyException RuntimeError(String string) {
        return new PyException(RuntimeError, string);
    }

    public static PyException FloatingPointError(String string) {
        return new PyException(FloatingPointError, string);
    }

    public static PyException SyntaxError(String string) {
        return new PyException(SyntaxError, string);
    }

    public static PyException AttributeError(String string) {
        return new PyException(AttributeError, string);
    }

    public static PyException IOError(IOException iOException) {
        return Py.fromIOException(iOException, IOError);
    }

    public static PyException IOError(String string) {
        return new PyException(IOError, string);
    }

    public static PyException IOError(Constant constant) {
        int n = constant.value();
        PyTuple pyTuple = new PyTuple(Py.newInteger(n), PosixModule.strerror(n));
        return new PyException(IOError, pyTuple);
    }

    public static PyException IOError(Constant constant, String string) {
        int n = constant.value();
        PyTuple pyTuple = new PyTuple(Py.newInteger(n), PosixModule.strerror(n), Py.newString(string));
        return new PyException(IOError, pyTuple);
    }

    private static PyException fromIOException(IOException iOException, PyObject pyObject) {
        String string = iOException.getMessage();
        if (string == null) {
            string = iOException.getClass().getName();
        }
        if (iOException instanceof FileNotFoundException) {
            PyTuple pyTuple = new PyTuple(Py.newInteger(Errno.ENOENT.value()), Py.newString("File not found - " + string));
            return new PyException(pyObject, pyTuple);
        }
        return new PyException(pyObject, string);
    }

    public static PyException KeyError(String string) {
        return new PyException(KeyError, string);
    }

    public static PyException KeyError(PyObject pyObject) {
        return new PyException(KeyError, pyObject);
    }

    public static PyException AssertionError(String string) {
        return new PyException(AssertionError, string);
    }

    public static PyException TypeError(String string) {
        return new PyException(TypeError, string);
    }

    public static PyException ReferenceError(String string) {
        return new PyException(ReferenceError, string);
    }

    public static PyException SystemError(String string) {
        return new PyException(SystemError, string);
    }

    public static PyException IndexError(String string) {
        return new PyException(IndexError, string);
    }

    public static PyException ZeroDivisionError(String string) {
        return new PyException(ZeroDivisionError, string);
    }

    public static PyException NameError(String string) {
        return new PyException(NameError, string);
    }

    public static PyException UnboundLocalError(String string) {
        return new PyException(UnboundLocalError, string);
    }

    static void maybeSystemExit(PyException pyException) {
        if (pyException.match(SystemExit)) {
            PyObject pyObject = pyException.value;
            if (PyException.isExceptionInstance(pyException.value)) {
                pyObject = pyObject.__findattr__("code");
            }
            Py.getSystemState().callExitFunc();
            if (pyObject instanceof PyInteger) {
                System.exit(((PyInteger)pyObject).getValue());
            } else {
                if (pyObject != None) {
                    try {
                        Py.println(pyObject);
                        System.exit(1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                System.exit(0);
            }
        }
    }

    public static PyException StopIteration(String string) {
        return new PyException(StopIteration, string);
    }

    public static PyException GeneratorExit(String string) {
        return new PyException(GeneratorExit, string);
    }

    public static PyException ImportError(String string) {
        return new PyException(ImportError, string);
    }

    public static PyException ValueError(String string) {
        return new PyException(ValueError, string);
    }

    public static PyException UnicodeError(String string) {
        return new PyException(UnicodeError, string);
    }

    public static PyException UnicodeTranslateError(String string, int n, int n2, String string2) {
        return new PyException(UnicodeTranslateError, new PyTuple(new PyString(string), new PyInteger(n), new PyInteger(n2), new PyString(string2)));
    }

    public static PyException UnicodeDecodeError(String string, String string2, int n, int n2, String string3) {
        return new PyException(UnicodeDecodeError, new PyTuple(new PyString(string), new PyString(string2), new PyInteger(n), new PyInteger(n2), new PyString(string3)));
    }

    public static PyException UnicodeEncodeError(String string, String string2, int n, int n2, String string3) {
        return new PyException(UnicodeEncodeError, new PyTuple(new PyString(string), new PyUnicode(string2), new PyInteger(n), new PyInteger(n2), new PyString(string3)));
    }

    public static PyException EOFError(String string) {
        return new PyException(EOFError, string);
    }

    public static void memory_error(OutOfMemoryError outOfMemoryError) {
        if (Options.showJavaExceptions) {
            outOfMemoryError.printStackTrace();
        }
    }

    public static PyException MemoryError(String string) {
        return new PyException(MemoryError, string);
    }

    public static void Warning(String string) {
        Py.warning(Warning, string);
    }

    public static void UserWarning(String string) {
        Py.warning(UserWarning, string);
    }

    public static void DeprecationWarning(String string) {
        Py.warning(DeprecationWarning, string);
    }

    public static void PendingDeprecationWarning(String string) {
        Py.warning(PendingDeprecationWarning, string);
    }

    public static void SyntaxWarning(String string) {
        Py.warning(SyntaxWarning, string);
    }

    public static void RuntimeWarning(String string) {
        Py.warning(RuntimeWarning, string);
    }

    public static void FutureWarning(String string) {
        Py.warning(FutureWarning, string);
    }

    public static void ImportWarning(String string) {
        Py.warning(ImportWarning, string);
    }

    public static void UnicodeWarning(String string) {
        Py.warning(UnicodeWarning, string);
    }

    private static PyObject importWarnings() {
        PyObject pyObject;
        if (warnings_mod != null) {
            return warnings_mod;
        }
        try {
            pyObject = __builtin__.__import__("warnings");
        }
        catch (PyException pyException) {
            if (pyException.match(ImportError)) {
                return null;
            }
            throw pyException;
        }
        warnings_mod = pyObject;
        return pyObject;
    }

    private static String warn_hcategory(PyObject pyObject) {
        PyObject pyObject2 = pyObject.__findattr__("__name__");
        if (pyObject2 != null) {
            return "[" + pyObject2 + "]";
        }
        return "[warning]";
    }

    public static void warning(PyObject pyObject, String string) {
        PyObject pyObject2 = null;
        PyObject pyObject3 = Py.importWarnings();
        if (pyObject3 != null) {
            pyObject2 = pyObject3.__getattr__("warn");
        }
        if (pyObject2 == null) {
            System.err.println(Py.warn_hcategory(pyObject) + ": " + string);
            return;
        }
        pyObject2.__call__(Py.newString(string), pyObject);
    }

    public static void warning(PyObject pyObject, String string, String string2, int n, String string3, PyObject pyObject2) {
        PyObject pyObject3 = null;
        PyObject pyObject4 = Py.importWarnings();
        if (pyObject4 != null) {
            pyObject3 = pyObject4.__getattr__("warn_explicit");
        }
        if (pyObject3 == null) {
            System.err.println(string2 + ":" + n + ":" + Py.warn_hcategory(pyObject) + ": " + string);
            return;
        }
        pyObject3.__call__(new PyObject[]{Py.newString(string), pyObject, Py.newString(string2), Py.newInteger(n), string3 == null ? None : Py.newString(string3), pyObject2}, NoKeywords);
    }

    public static PyException JavaError(Throwable throwable) {
        if (throwable instanceof PyException) {
            return (PyException)throwable;
        }
        if (throwable instanceof InvocationTargetException) {
            return Py.JavaError(((InvocationTargetException)throwable).getTargetException());
        }
        if (throwable instanceof StackOverflowError) {
            return Py.RuntimeError("maximum recursion depth exceeded");
        }
        if (throwable instanceof OutOfMemoryError) {
            Py.memory_error((OutOfMemoryError)throwable);
        }
        PyObject pyObject = PyJavaType.wrapJavaObject(throwable);
        PyException pyException = new PyException((PyObject)pyObject.getType(), pyObject);
        pyException.initCause(throwable);
        return pyException;
    }

    private Py() {
    }

    public static <T> T tojava(PyObject pyObject, Class<T> clazz) {
        Object object = pyObject.__tojava__(clazz);
        if (object == NoConversion) {
            throw Py.TypeError("can't convert " + pyObject.__repr__() + " to " + clazz.getName());
        }
        return (T)object;
    }

    public static Object tojava(PyObject pyObject, String string) {
        Class<?> clazz = Py.findClass(string);
        if (clazz == null) {
            throw Py.TypeError("can't convert to: " + string);
        }
        return Py.tojava(pyObject, clazz);
    }

    public static final PyInteger newInteger(int n) {
        if (n >= -100 && n < 900) {
            return integerCache[n + 100];
        }
        return new PyInteger(n);
    }

    public static PyObject newInteger(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            return new PyLong(l);
        }
        return Py.newInteger((int)l);
    }

    public static PyLong newLong(String string) {
        return new PyLong(string);
    }

    public static PyLong newLong(BigInteger bigInteger) {
        return new PyLong(bigInteger);
    }

    public static PyLong newLong(int n) {
        return new PyLong(n);
    }

    public static PyLong newLong(long l) {
        return new PyLong(l);
    }

    public static PyComplex newImaginary(double d) {
        return new PyComplex(0.0, d);
    }

    public static PyFloat newFloat(float f) {
        return new PyFloat((double)f);
    }

    public static PyFloat newFloat(double d) {
        return new PyFloat(d);
    }

    public static PyString newString(char c) {
        return Py.makeCharacter(c);
    }

    public static PyString newString(String string) {
        return new PyString(string);
    }

    public static PyStringMap newStringMap() {
        if (!PyType.hasBuilder(PyStringMap.class)) {
            BOOTSTRAP_TYPES.add(PyStringMap.class);
        }
        return new PyStringMap();
    }

    public static PyUnicode newUnicode(char c) {
        return (PyUnicode)Py.makeCharacter(c, true);
    }

    static PyObject newUnicode(int n) {
        return Py.makeCharacter(n, true);
    }

    public static PyUnicode newUnicode(String string) {
        return new PyUnicode(string);
    }

    public static PyUnicode newUnicode(String string, boolean bl) {
        return new PyUnicode(string, bl);
    }

    public static PyBoolean newBoolean(boolean bl) {
        return bl ? True : False;
    }

    public static PyObject newDate(Date date) {
        if (date == null) {
            return None;
        }
        PyObject pyObject = __builtin__.__import__("datetime");
        PyObject pyObject2 = pyObject.__getattr__("date");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return pyObject2.__call__((PyObject)Py.newInteger(calendar.get(1)), (PyObject)Py.newInteger(calendar.get(2) + 1), (PyObject)Py.newInteger(calendar.get(5)));
    }

    public static PyObject newTime(Time time) {
        if (time == null) {
            return None;
        }
        PyObject pyObject = __builtin__.__import__("datetime");
        PyObject pyObject2 = pyObject.__getattr__("time");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        return pyObject2.__call__(Py.newInteger(calendar.get(11)), (PyObject)Py.newInteger(calendar.get(12)), (PyObject)Py.newInteger(calendar.get(13)), (PyObject)Py.newInteger(calendar.get(14) * 1000));
    }

    public static PyObject newDatetime(Timestamp timestamp) {
        if (timestamp == null) {
            return None;
        }
        PyObject pyObject = __builtin__.__import__("datetime");
        PyObject pyObject2 = pyObject.__getattr__("datetime");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        return pyObject2.__call__(new PyObject[]{Py.newInteger(calendar.get(1)), Py.newInteger(calendar.get(2) + 1), Py.newInteger(calendar.get(5)), Py.newInteger(calendar.get(11)), Py.newInteger(calendar.get(12)), Py.newInteger(calendar.get(13)), Py.newInteger(timestamp.getNanos() / 1000)});
    }

    public static PyObject newDecimal(String string) {
        if (string == null) {
            return None;
        }
        PyObject pyObject = __builtin__.__import__("decimal");
        PyObject pyObject2 = pyObject.__getattr__("Decimal");
        return pyObject2.__call__(Py.newString(string));
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n2, String[] stringArray2, String[] stringArray3, int n3, int n4) {
        return new PyTableCode(n, stringArray, string, string2, 0, bl, bl2, pyFunctionTable, n2, stringArray2, stringArray3, n3, n4);
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, int n2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n3, String[] stringArray2, String[] stringArray3, int n4, int n5) {
        return new PyTableCode(n, stringArray, string, string2, n2, bl, bl2, pyFunctionTable, n3, stringArray2, stringArray3, n4, n5);
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n2) {
        return new PyTableCode(n, stringArray, string, string2, 0, bl, bl2, pyFunctionTable, n2);
    }

    public static PyCode newCode(int n, String[] stringArray, String string, String string2, int n2, boolean bl, boolean bl2, PyFunctionTable pyFunctionTable, int n3) {
        return new PyTableCode(n, stringArray, string, string2, n2, bl, bl2, pyFunctionTable, n3);
    }

    public static PyCode newJavaCode(Class<?> clazz, String string) {
        return new JavaCode(Py.newJavaFunc(clazz, string));
    }

    public static PyObject newJavaFunc(Class<?> clazz, String string) {
        try {
            Method method = clazz.getMethod(string, PyObject[].class, String[].class);
            return new JavaFunc(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Py.JavaError(noSuchMethodException);
        }
    }

    private static PyObject initExc(String string, PyObject pyObject, PyObject pyObject2) {
        PyObject pyObject3 = pyObject.__getattr__(string);
        pyObject2.__setitem__(string, pyObject3);
        return pyObject3;
    }

    static void initClassExceptions(PyObject pyObject) {
        PyObject pyObject2 = imp.load("exceptions");
        BaseException = Py.initExc("BaseException", pyObject2, pyObject);
        Exception = Py.initExc("Exception", pyObject2, pyObject);
        SystemExit = Py.initExc("SystemExit", pyObject2, pyObject);
        StopIteration = Py.initExc("StopIteration", pyObject2, pyObject);
        GeneratorExit = Py.initExc("GeneratorExit", pyObject2, pyObject);
        StandardError = Py.initExc("StandardError", pyObject2, pyObject);
        KeyboardInterrupt = Py.initExc("KeyboardInterrupt", pyObject2, pyObject);
        ImportError = Py.initExc("ImportError", pyObject2, pyObject);
        EnvironmentError = Py.initExc("EnvironmentError", pyObject2, pyObject);
        IOError = Py.initExc("IOError", pyObject2, pyObject);
        OSError = Py.initExc("OSError", pyObject2, pyObject);
        EOFError = Py.initExc("EOFError", pyObject2, pyObject);
        RuntimeError = Py.initExc("RuntimeError", pyObject2, pyObject);
        NotImplementedError = Py.initExc("NotImplementedError", pyObject2, pyObject);
        NameError = Py.initExc("NameError", pyObject2, pyObject);
        UnboundLocalError = Py.initExc("UnboundLocalError", pyObject2, pyObject);
        AttributeError = Py.initExc("AttributeError", pyObject2, pyObject);
        SyntaxError = Py.initExc("SyntaxError", pyObject2, pyObject);
        IndentationError = Py.initExc("IndentationError", pyObject2, pyObject);
        TabError = Py.initExc("TabError", pyObject2, pyObject);
        TypeError = Py.initExc("TypeError", pyObject2, pyObject);
        AssertionError = Py.initExc("AssertionError", pyObject2, pyObject);
        LookupError = Py.initExc("LookupError", pyObject2, pyObject);
        IndexError = Py.initExc("IndexError", pyObject2, pyObject);
        KeyError = Py.initExc("KeyError", pyObject2, pyObject);
        ArithmeticError = Py.initExc("ArithmeticError", pyObject2, pyObject);
        OverflowError = Py.initExc("OverflowError", pyObject2, pyObject);
        ZeroDivisionError = Py.initExc("ZeroDivisionError", pyObject2, pyObject);
        FloatingPointError = Py.initExc("FloatingPointError", pyObject2, pyObject);
        ValueError = Py.initExc("ValueError", pyObject2, pyObject);
        UnicodeError = Py.initExc("UnicodeError", pyObject2, pyObject);
        UnicodeEncodeError = Py.initExc("UnicodeEncodeError", pyObject2, pyObject);
        UnicodeDecodeError = Py.initExc("UnicodeDecodeError", pyObject2, pyObject);
        UnicodeTranslateError = Py.initExc("UnicodeTranslateError", pyObject2, pyObject);
        ReferenceError = Py.initExc("ReferenceError", pyObject2, pyObject);
        SystemError = Py.initExc("SystemError", pyObject2, pyObject);
        MemoryError = Py.initExc("MemoryError", pyObject2, pyObject);
        Warning = Py.initExc("Warning", pyObject2, pyObject);
        UserWarning = Py.initExc("UserWarning", pyObject2, pyObject);
        DeprecationWarning = Py.initExc("DeprecationWarning", pyObject2, pyObject);
        PendingDeprecationWarning = Py.initExc("PendingDeprecationWarning", pyObject2, pyObject);
        SyntaxWarning = Py.initExc("SyntaxWarning", pyObject2, pyObject);
        RuntimeWarning = Py.initExc("RuntimeWarning", pyObject2, pyObject);
        FutureWarning = Py.initExc("FutureWarning", pyObject2, pyObject);
        ImportWarning = Py.initExc("ImportWarning", pyObject2, pyObject);
        UnicodeWarning = Py.initExc("UnicodeWarning", pyObject2, pyObject);
        PyType.fromClass(OutOfMemoryError.class);
    }

    public static synchronized boolean initPython() {
        PySystemState.initialize();
        return true;
    }

    private static Class<?> findClassInternal(String string, String string2) throws ClassNotFoundException {
        ClassLoader classLoader = Py.getSystemState().getClassLoader();
        if (classLoader != null) {
            if (string2 != null) {
                Py.writeDebug("import", "trying " + string + " as " + string2 + " in sys.classLoader");
            }
            return Py.loadAndInitClass(string, classLoader);
        }
        if (!syspathJavaLoaderRestricted) {
            try {
                classLoader = imp.getSyspathJavaLoader();
                if (classLoader != null && string2 != null) {
                    Py.writeDebug("import", "trying " + string + " as " + string2 + " in SysPathJavaLoader");
                }
            }
            catch (SecurityException securityException) {
                syspathJavaLoaderRestricted = true;
            }
        }
        if (syspathJavaLoaderRestricted && (classLoader = imp.getParentClassLoader()) != null && string2 != null) {
            Py.writeDebug("import", "trying " + string + " as " + string2 + " in Jython's parent class loader");
        }
        if (classLoader != null) {
            try {
                return Py.loadAndInitClass(string, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (string2 != null) {
            Py.writeDebug("import", "trying " + string + " as " + string2 + " in context class loader, for backwards compatibility");
        }
        return Py.loadAndInitClass(string, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> findClass(String string) {
        try {
            return Py.findClassInternal(string, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    public static Class<?> findClassEx(String string, String string2) {
        try {
            return Py.findClassInternal(string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Py.JavaError(illegalArgumentException);
        }
        catch (LinkageError linkageError) {
            throw Py.JavaError(linkageError);
        }
    }

    private static Class<?> loadAndInitClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(string, true, classLoader);
    }

    public static void initProxy(PyProxy pyProxy, String string, String string2, Object[] objectArray) {
        if (pyProxy._getPyInstance() != null) {
            return;
        }
        ThreadState threadState = Py.getThreadState();
        PyObject pyObject = threadState.getInitializingProxy();
        if (pyObject != null) {
            if (pyObject.javaProxy != null) {
                throw Py.TypeError("Proxy instance reused");
            }
            pyObject.javaProxy = pyProxy;
            pyProxy._setPyInstance(pyObject);
            pyProxy._setPySystemState(threadState.systemState);
            return;
        }
        PyObject pyObject2 = imp.importName(string.intern(), false);
        PyType pyType = (PyType)pyObject2.__getattr__(string2.intern());
        PyObject[] pyObjectArray = objectArray == null || objectArray.length == 0 ? EmptyObjects : Py.javas2pys(objectArray);
        pyObject = pyType.__call__(pyObjectArray);
        pyObject.javaProxy = pyProxy;
        pyProxy._setPyInstance(pyObject);
        pyProxy._setPySystemState(threadState.systemState);
    }

    public static void runMain(PyRunnable pyRunnable, String[] stringArray) throws Exception {
        Py.runMain(new PyRunnableBootstrap(pyRunnable), stringArray);
    }

    public static void runMain(CodeBootstrap codeBootstrap, String[] stringArray) throws Exception {
        PySystemState.initialize(null, null, stringArray, codeBootstrap.getClass().getClassLoader());
        try {
            imp.createFromCode("__main__", CodeLoader.loadCode(codeBootstrap));
        }
        catch (PyException pyException) {
            Py.getSystemState().callExitFunc();
            if (pyException.match(SystemExit)) {
                return;
            }
            throw pyException;
        }
        Py.getSystemState().callExitFunc();
    }

    private static String getStackTrace(Throwable throwable) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        String string = byteArrayOutputStream.toString();
        int n2 = -1;
        if (n2 == -1) {
            n2 = string.indexOf("at org.python.core.PyReflectedConstructor.__call__");
        }
        if (n2 == -1) {
            n2 = string.indexOf("at org.python.core.PyReflectedFunction.__call__");
        }
        if (n2 == -1) {
            n2 = string.indexOf("at org/python/core/PyReflectedConstructor.__call__");
        }
        if (n2 == -1) {
            n2 = string.indexOf("at org/python/core/PyReflectedFunction.__call__");
        }
        if (n2 != -1) {
            n2 = string.lastIndexOf("\n", n2);
        }
        if (n2 >= (n = string.indexOf("\n"))) {
            string = string.substring(n + 1, n2 + 1);
        }
        return string;
    }

    public static void printException(Throwable throwable) {
        Py.printException(throwable, null, null);
    }

    public static void printException(Throwable throwable, PyFrame pyFrame) {
        Py.printException(throwable, pyFrame, null);
    }

    public static synchronized void printException(Throwable throwable, PyFrame pyFrame, PyObject pyObject) {
        Object object;
        StdoutWrapper stdoutWrapper = stderr;
        if (pyObject != null) {
            stdoutWrapper = new FixedFileWrapper(pyObject);
        }
        if (Options.showJavaExceptions) {
            stdoutWrapper.println("Java Traceback:");
            object = new CharArrayWriter();
            if (throwable instanceof PyException) {
                ((PyException)throwable).super__printStackTrace(new PrintWriter((Writer)object));
            } else {
                throwable.printStackTrace(new PrintWriter((Writer)object));
            }
            stdoutWrapper.print(((CharArrayWriter)object).toString());
        }
        object = Py.JavaError(throwable);
        Py.maybeSystemExit((PyException)object);
        Py.setException((Throwable)object, pyFrame);
        ThreadState threadState = Py.getThreadState();
        threadState.systemState.last_value = ((PyException)object).value;
        threadState.systemState.last_type = ((PyException)object).type;
        threadState.systemState.last_traceback = ((PyException)object).traceback;
        PyObject pyObject2 = threadState.systemState.__findattr__("excepthook");
        if (pyObject2 != null) {
            try {
                pyObject2.__call__(((PyException)object).type, ((PyException)object).value, (PyObject)((PyException)object).traceback);
            }
            catch (PyException pyException) {
                pyException.normalize();
                Py.flushLine();
                stdoutWrapper.println("Error in sys.excepthook:");
                Py.displayException(pyException.type, pyException.value, pyException.traceback, pyObject);
                stdoutWrapper.println();
                stdoutWrapper.println("Original exception was:");
                Py.displayException(((PyException)object).type, ((PyException)object).value, ((PyException)object).traceback, pyObject);
            }
        } else {
            stdoutWrapper.println("sys.excepthook is missing");
            Py.displayException(((PyException)object).type, ((PyException)object).value, ((PyException)object).traceback, pyObject);
        }
        threadState.exception = null;
    }

    public static void displayException(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        Object object;
        StdoutWrapper stdoutWrapper = stderr;
        if (pyObject4 != null) {
            stdoutWrapper = new FixedFileWrapper(pyObject4);
        }
        Py.flushLine();
        if (pyObject3 instanceof PyTraceback) {
            stdoutWrapper.print(((PyTraceback)pyObject3).dumpStack());
        }
        if (__builtin__.isinstance(pyObject2, SyntaxError)) {
            object = pyObject2.__findattr__("filename");
            PyObject pyObject5 = pyObject2.__findattr__("text");
            PyObject pyObject6 = pyObject2.__findattr__("lineno");
            stdoutWrapper.print("  File \"");
            stdoutWrapper.print(object == None || object == null ? "<string>" : ((PyObject)object).toString());
            stdoutWrapper.print("\", line ");
            stdoutWrapper.print(pyObject6 == null ? Py.newString("0") : pyObject6);
            stdoutWrapper.print("\n");
            if (pyObject5 != None && pyObject5 != null && pyObject5.__len__() != 0) {
                Py.printSyntaxErrorText(stdoutWrapper, pyObject2.__findattr__("offset").asInt(), pyObject5.toString());
            }
            if ((pyObject2 = pyObject2.__findattr__("msg")) == null) {
                pyObject2 = None;
            }
        }
        if (pyObject2.getJavaProxy() != null && (object = pyObject2.__tojava__(Throwable.class)) != null && object != NoConversion) {
            stdoutWrapper.println(Py.getStackTrace((Throwable)object));
        }
        stdoutWrapper.println(Py.formatException(pyObject, pyObject2));
    }

    private static void printSyntaxErrorText(StdoutWrapper stdoutWrapper, int n, String string) {
        if (n >= 0) {
            char c;
            int n2;
            if (n > 0 && n == string.length()) {
                --n;
            }
            while ((n2 = string.indexOf("\n")) != -1 && n2 < n) {
                n -= n2 + 1;
                string = string.substring(n2 + 1, string.length());
            }
            for (n2 = 0; n2 < string.length() && ((c = string.charAt(n2)) == ' ' || c == '\t'); ++n2) {
                --n;
            }
            string = string.substring(n2, string.length());
        }
        stdoutWrapper.print("    ");
        stdoutWrapper.print(string);
        if (string.length() == 0 || !string.endsWith("\n")) {
            stdoutWrapper.print("\n");
        }
        if (n == -1) {
            return;
        }
        stdoutWrapper.print("    ");
        --n;
        while (n > 0) {
            stdoutWrapper.print(" ");
            --n;
        }
        stdoutWrapper.print("^\n");
    }

    public static String formatException(PyObject pyObject, PyObject pyObject2) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (PyException.isExceptionClass(pyObject)) {
            PyObject pyObject3;
            object = PyException.exceptionClassName(pyObject);
            int n = ((String)object).lastIndexOf(46);
            if (n != -1) {
                object = ((String)object).substring(n + 1);
            }
            if ((pyObject3 = pyObject.__findattr__("__module__")) == null) {
                if (!(pyObject instanceof PyClass)) {
                    stringBuilder.append("<unknown>");
                }
            } else {
                String string = pyObject3.toString();
                if (!string.equals("exceptions")) {
                    stringBuilder.append(string);
                    stringBuilder.append(".");
                }
            }
            stringBuilder.append((String)object);
        } else {
            stringBuilder.append(pyObject.__str__());
        }
        if (pyObject2 != null && pyObject2 != None) {
            object = pyObject2.__str__();
            if (!(object instanceof PyString) || ((PyObject)object).__len__() != 0) {
                stringBuilder.append(": ");
            }
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static void assert_(PyObject pyObject, PyObject pyObject2) {
        if (!pyObject.__nonzero__()) {
            throw new PyException(AssertionError, pyObject2);
        }
    }

    public static void assert_(PyObject pyObject) {
        Py.assert_(pyObject, None);
    }

    public static void addTraceback(Throwable throwable, PyFrame pyFrame) {
        Py.JavaError(throwable).tracebackHere(pyFrame, true);
    }

    public static PyException setException(Throwable throwable, PyFrame pyFrame) {
        PyException pyException = Py.JavaError(throwable);
        pyException.normalize();
        pyException.tracebackHere(pyFrame);
        Py.getThreadState().exception = pyException;
        return pyException;
    }

    @Deprecated
    public static boolean matchException(PyException pyException, PyObject pyObject) {
        return pyException.match(pyObject);
    }

    public static PyException makeException(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return PyException.doRaise(pyObject, pyObject2, pyObject3);
    }

    public static PyException makeException(PyObject pyObject, PyObject pyObject2) {
        return Py.makeException(pyObject, pyObject2, null);
    }

    public static PyException makeException(PyObject pyObject) {
        return Py.makeException(pyObject, null);
    }

    public static PyException makeException() {
        return Py.makeException(null);
    }

    public static PyObject runCode(PyCode pyCode, PyObject pyObject, PyObject pyObject2) {
        ThreadState threadState = Py.getThreadState();
        if (pyObject == null || pyObject == None) {
            pyObject = pyObject2 != null && pyObject2 != None ? pyObject2 : threadState.frame.getLocals();
        }
        if (pyObject2 == null || pyObject2 == None) {
            pyObject2 = threadState.frame.f_globals;
        }
        PyBaseCode pyBaseCode = null;
        if (pyCode instanceof PyBaseCode) {
            pyBaseCode = (PyBaseCode)pyCode;
        }
        PyFrame pyFrame = new PyFrame(pyBaseCode, pyObject, pyObject2, Py.getSystemState().getBuiltins());
        return pyCode.call(threadState, pyFrame);
    }

    public static void exec(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyCode pyCode;
        Object object;
        int n = 0;
        if (pyObject instanceof PyTuple) {
            object = (PyTuple)pyObject;
            int n2 = ((PyTuple)object).__len__();
            if ((pyObject2 == null || pyObject2.equals(None)) && (pyObject3 == null || pyObject3.equals(None)) && n2 >= 2 && n2 <= 3) {
                pyObject = ((PyObject)object).__getitem__(0);
                pyObject2 = ((PyObject)object).__getitem__(1);
                if (n2 == 3) {
                    pyObject3 = ((PyObject)object).__getitem__(2);
                }
            }
        }
        if (pyObject instanceof PyCode) {
            pyCode = (PyCode)pyObject;
            if (pyObject3 == null && pyObject instanceof PyBaseCode && ((PyBaseCode)pyObject).hasFreevars()) {
                throw Py.TypeError("code object passed to exec may not contain free variables");
            }
        } else {
            object = null;
            if (pyObject instanceof PyString) {
                if (pyObject instanceof PyUnicode) {
                    n |= 0x100;
                }
                object = pyObject.toString();
            } else if (pyObject instanceof PyFile) {
                PyFile pyFile = (PyFile)pyObject;
                if (pyFile.getClosed()) {
                    return;
                }
                object = pyFile.read().toString();
            } else {
                throw Py.TypeError("exec: argument 1 must be string, code or file object");
            }
            pyCode = Py.compile_flags((String)object, "<string>", CompileMode.exec, Py.getCompilerFlags(n, false));
        }
        Py.runCode(pyCode, pyObject3, pyObject2);
    }

    public static final ThreadState getThreadState() {
        return Py.getThreadState(null);
    }

    public static final ThreadState getThreadState(PySystemState pySystemState) {
        return threadStateMapping.getThreadState(pySystemState);
    }

    public static final PySystemState setSystemState(PySystemState pySystemState) {
        ThreadState threadState = Py.getThreadState(pySystemState);
        PySystemState pySystemState2 = threadState.systemState;
        if (pySystemState2 != pySystemState) {
            threadState.systemState = pySystemState;
        }
        return pySystemState2;
    }

    public static final PySystemState getSystemState() {
        return Py.getThreadState().systemState;
    }

    public static PyFrame getFrame() {
        ThreadState threadState = Py.getThreadState();
        if (threadState == null) {
            return null;
        }
        return threadState.frame;
    }

    public static void setFrame(PyFrame pyFrame) {
        Py.getThreadState().frame = pyFrame;
    }

    public static void print(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == None) {
            Py.print(pyObject2);
        } else {
            new FixedFileWrapper(pyObject).print(pyObject2);
        }
    }

    public static void printComma(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == None) {
            Py.printComma(pyObject2);
        } else {
            new FixedFileWrapper(pyObject).printComma(pyObject2);
        }
    }

    public static void println(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == None) {
            Py.println(pyObject2);
        } else {
            new FixedFileWrapper(pyObject).println(pyObject2);
        }
    }

    public static void printlnv(PyObject pyObject) {
        if (pyObject == None) {
            Py.println();
        } else {
            new FixedFileWrapper(pyObject).println();
        }
    }

    public static void print(PyObject pyObject) {
        stdout.print(pyObject);
    }

    public static void printComma(PyObject pyObject) {
        stdout.printComma(pyObject);
    }

    public static void println(PyObject pyObject) {
        stdout.println(pyObject);
    }

    public static void println() {
        stdout.println();
    }

    public static void flushLine() {
        stdout.flushLine();
    }

    public static boolean py2boolean(PyObject pyObject) {
        return pyObject.__nonzero__();
    }

    public static byte py2byte(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return (byte)((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Byte.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Byte)object;
    }

    public static short py2short(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return (short)((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Short.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Short)object;
    }

    public static int py2int(PyObject pyObject) {
        return Py.py2int(pyObject, "integer required");
    }

    public static int py2int(PyObject pyObject, String string) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Integer.TYPE);
        if (object == NoConversion) {
            throw Py.TypeError(string);
        }
        return (Integer)object;
    }

    public static long py2long(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Long.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("integer required");
        }
        return (Long)object;
    }

    public static float py2float(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return (float)((PyFloat)pyObject).getValue();
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Float.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("float required");
        }
        return ((Float)object).floatValue();
    }

    public static double py2double(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return ((PyFloat)pyObject).getValue();
        }
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Double.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError("float required");
        }
        return (Double)object;
    }

    public static char py2char(PyObject pyObject) {
        return Py.py2char(pyObject, "char required");
    }

    public static char py2char(PyObject pyObject, String string) {
        if (pyObject instanceof PyString) {
            PyString pyString = (PyString)pyObject;
            if (pyString.__len__() != 1) {
                throw Py.TypeError(string);
            }
            return pyString.toString().charAt(0);
        }
        if (pyObject instanceof PyInteger) {
            return (char)((PyInteger)pyObject).getValue();
        }
        Object object = pyObject.__tojava__(Character.TYPE);
        if (object == null || object == NoConversion) {
            throw Py.TypeError(string);
        }
        return ((Character)object).charValue();
    }

    public static void py2void(PyObject pyObject) {
        if (pyObject != None) {
            throw Py.TypeError("None required for void return");
        }
    }

    public static final PyString makeCharacter(Character c) {
        return Py.makeCharacter(c.charValue());
    }

    public static final PyString makeCharacter(char c) {
        return Py.makeCharacter(c, false);
    }

    static final PyString makeCharacter(int n, boolean bl) {
        if (bl) {
            return new PyUnicode(n);
        }
        if (n > 65536) {
            throw new IllegalArgumentException(String.format("Codepoint > 65536 (%d) requires toUnicode argument", n));
        }
        if (n > 256) {
            return new PyString((char)n);
        }
        return letters[n];
    }

    public static PyObject java2py(Object object) {
        return Py.getAdapter().adapt(object);
    }

    public static PyObject[] javas2pys(Object ... objectArray) {
        PyObject[] pyObjectArray = new PyObject[objectArray.length];
        for (int i = 0; i < pyObjectArray.length; ++i) {
            pyObjectArray[i] = Py.java2py(objectArray[i]);
        }
        return pyObjectArray;
    }

    public static ExtensiblePyObjectAdapter getAdapter() {
        if (adapter == null) {
            adapter = new ClassicPyObjectAdapter();
        }
        return adapter;
    }

    protected static void setAdapter(ExtensiblePyObjectAdapter extensiblePyObjectAdapter) {
        adapter = extensiblePyObjectAdapter;
    }

    public static PyObject makeClass(String string, PyObject[] pyObjectArray, PyCode pyCode) {
        return Py.makeClass(string, pyObjectArray, pyCode, null);
    }

    public static PyObject makeClass(String string, PyObject[] pyObjectArray, PyCode pyCode, PyObject[] pyObjectArray2) {
        ThreadState threadState = Py.getThreadState();
        PyObject pyObject = pyCode.call(threadState, EmptyObjects, NoKeywords, threadState.frame.f_globals, EmptyObjects, (PyObject)new PyTuple(pyObjectArray2));
        return Py.makeClass(string, pyObjectArray, pyObject);
    }

    public static PyObject makeClass(String string, PyObject pyObject, PyObject pyObject2) {
        PyObject[] pyObjectArray;
        if (pyObject == null) {
            pyObjectArray = EmptyObjects;
        } else {
            PyObject[] pyObjectArray2 = new PyObject[1];
            pyObjectArray = pyObjectArray2;
            pyObjectArray2[0] = pyObject;
        }
        PyObject[] pyObjectArray3 = pyObjectArray;
        return Py.makeClass(string, pyObjectArray3, pyObject2);
    }

    public static PyObject makeClass(String string, PyObject[] pyObjectArray, PyObject pyObject) {
        PyObject pyObject2 = pyObject.__finditem__("__metaclass__");
        if (pyObject2 == null) {
            PyObject pyObject3;
            if (pyObjectArray.length != 0) {
                pyObject3 = pyObjectArray[0];
                pyObject2 = pyObject3.__findattr__("__class__");
                if (pyObject2 == null) {
                    pyObject2 = pyObject3.getType();
                }
            } else {
                pyObject3 = Py.getFrame().f_globals;
                if (pyObject3 != null) {
                    pyObject2 = pyObject3.__finditem__("__metaclass__");
                }
                if (pyObject2 == null) {
                    pyObject2 = PyClass.TYPE;
                }
            }
        }
        try {
            return pyObject2.__call__((PyObject)new PyString(string), (PyObject)new PyTuple(pyObjectArray), pyObject);
        }
        catch (PyException pyException) {
            if (!pyException.match(TypeError)) {
                throw pyException;
            }
            pyException.value = Py.newString(String.format("Error when calling the metaclass bases\n    %s", pyException.value.__str__().toString()));
            throw pyException;
        }
    }

    public static synchronized String getName() {
        String string = "org.python.pycode._pyx" + nameindex;
        ++nameindex;
        return string;
    }

    public static CompilerFlags getCompilerFlags() {
        return CompilerFlags.getCompilerFlags();
    }

    public static CompilerFlags getCompilerFlags(int n, boolean bl) {
        PyFrame pyFrame = bl ? null : Py.getFrame();
        return CompilerFlags.getCompilerFlags(n, pyFrame);
    }

    public static CompilerFlags getCompilerFlags(CompilerFlags compilerFlags, boolean bl) {
        PyFrame pyFrame = bl ? null : Py.getFrame();
        return CompilerFlags.getCompilerFlags(compilerFlags, pyFrame);
    }

    public static PyCode compile(InputStream inputStream, String string, CompileMode compileMode) {
        return Py.compile_flags(inputStream, string, compileMode, new CompilerFlags());
    }

    public static PyCode compile_flags(mod mod2, String string, String string2, boolean bl, boolean bl2, CompilerFlags compilerFlags) {
        return CompilerFacade.compile(mod2, string, string2, bl, bl2, compilerFlags);
    }

    public static PyCode compile_flags(mod mod2, String string, CompileMode compileMode, CompilerFlags compilerFlags) {
        return Py.compile_flags(mod2, Py.getName(), string, true, compileMode == CompileMode.single, compilerFlags);
    }

    public static PyCode compile_flags(InputStream inputStream, String string, CompileMode compileMode, CompilerFlags compilerFlags) {
        mod mod2 = ParserFacade.parse(inputStream, compileMode, string, compilerFlags);
        return Py.compile_flags(mod2, string, compileMode, compilerFlags);
    }

    public static PyCode compile_flags(String string, String string2, CompileMode compileMode, CompilerFlags compilerFlags) {
        if (string.contains("\u0000")) {
            throw Py.TypeError("compile() expected string without null bytes");
        }
        string = compilerFlags != null && compilerFlags.dont_imply_dedent ? string + "\n" : string + "\n\n";
        mod mod2 = ParserFacade.parse(string, compileMode, string2, compilerFlags);
        return Py.compile_flags(mod2, string2, compileMode, compilerFlags);
    }

    public static PyObject compile_command_flags(String string, String string2, CompileMode compileMode, CompilerFlags compilerFlags, boolean bl) {
        mod mod2 = ParserFacade.partialParse(string + "\n", compileMode, string2, compilerFlags, bl);
        if (mod2 == null) {
            return None;
        }
        return Py.compile_flags(mod2, Py.getName(), string2, true, true, compilerFlags);
    }

    public static PyObject[] unpackSequence(PyObject pyObject, int n) {
        if (pyObject instanceof PyTuple && pyObject.__len__() == n) {
            return ((PyTuple)pyObject).getArray();
        }
        PyObject[] pyObjectArray = new PyObject[n];
        PyObject pyObject2 = pyObject.__iter__();
        for (int i = 0; i < n; ++i) {
            PyObject pyObject3 = pyObject2.__iternext__();
            if (pyObject3 == null) {
                throw Py.ValueError(String.format("need more than %d value%s to unpack", i, i == 1 ? "" : "s"));
            }
            pyObjectArray[i] = pyObject3;
        }
        if (pyObject2.__iternext__() != null) {
            throw Py.ValueError("too many values to unpack");
        }
        return pyObjectArray;
    }

    public static PyObject iter(PyObject pyObject, String string) {
        try {
            return pyObject.__iter__();
        }
        catch (PyException pyException) {
            if (pyException.match(TypeError)) {
                throw Py.TypeError(string);
            }
            throw pyException;
        }
    }

    public static long id(PyObject pyObject) {
        return idimpl.id(pyObject);
    }

    public static String idstr(PyObject pyObject) {
        return idimpl.idstr(pyObject);
    }

    public static long java_obj_id(Object object) {
        return idimpl.java_obj_id(object);
    }

    public static void printResult(PyObject pyObject) {
        Py.getThreadState().systemState.invoke("displayhook", pyObject);
    }

    public static void maybeWrite(String string, String string2, int n) {
        if (n <= Options.verbose) {
            System.err.println(string + ": " + string2);
        }
    }

    public static void writeError(String string, String string2) {
        Py.maybeWrite(string, string2, -1);
    }

    public static void writeWarning(String string, String string2) {
        Py.maybeWrite(string, string2, 0);
    }

    public static void writeMessage(String string, String string2) {
        Py.maybeWrite(string, string2, 1);
    }

    public static void writeComment(String string, String string2) {
        Py.maybeWrite(string, string2, 2);
    }

    public static void writeDebug(String string, String string2) {
        Py.maybeWrite(string, string2, 3);
    }

    public static void saveClassFile(String string, ByteArrayOutputStream byteArrayOutputStream) {
        String string2 = Options.proxyDebugDirectory;
        if (string2 == null) {
            return;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        File file = new File(string2);
        File file2 = Py.makeFilename(string, file);
        new File(file2.getParent()).mkdirs();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static File makeFilename(String string, File file) {
        int n = string.indexOf(".");
        if (n == -1) {
            return new File(file, string + ".class");
        }
        return Py.makeFilename(string.substring(n + 1, string.length()), new File(file, string.substring(0, n)));
    }

    private static boolean abstract_issubclass(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == pyObject2) {
            return true;
        }
        PyObject pyObject3 = pyObject.__findattr__("__bases__");
        if (pyObject3 == null) {
            return false;
        }
        for (int i = 0; i < pyObject3.__len__(); ++i) {
            if (!Py.abstract_issubclass(pyObject3.__getitem__(i), pyObject2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstance(PyObject pyObject, PyObject pyObject2) {
        return Py.recursiveIsInstance(pyObject, pyObject2, 0);
    }

    private static boolean recursiveIsInstance(PyObject pyObject, PyObject pyObject2, int n) {
        if (pyObject2 instanceof PyClass && pyObject instanceof PyInstance) {
            PyClass pyClass = (PyClass)pyObject.fastGetClass();
            return pyClass.isSubClass((PyClass)pyObject2);
        }
        if (pyObject2 instanceof PyType) {
            PyType pyType;
            PyType pyType2 = pyObject.getType();
            if (pyType2 == (pyType = (PyType)pyObject2) || pyType2.isSubType(pyType)) {
                return true;
            }
            PyObject pyObject3 = pyObject.__findattr__("__class__");
            if (pyObject3 != null && pyObject3 != pyType2 && pyObject3 instanceof PyType) {
                return ((PyType)pyObject3).isSubType(pyType);
            }
            return false;
        }
        if (pyObject2 instanceof PyTuple) {
            if (n > Py.getSystemState().getrecursionlimit()) {
                throw Py.RuntimeError("nest level of tuple too deep");
            }
            for (PyObject pyObject4 : ((PyTuple)pyObject2).getArray()) {
                if (!Py.recursiveIsInstance(pyObject, pyObject4, n + 1)) continue;
                return true;
            }
            return false;
        }
        if (pyObject2.__findattr__("__bases__") == null) {
            throw Py.TypeError("isinstance() arg 2 must be a class, type, or tuple of classes and types");
        }
        PyObject pyObject5 = pyObject.__findattr__("__class__");
        if (pyObject5 == null) {
            return false;
        }
        return Py.abstract_issubclass(pyObject5, pyObject2);
    }

    public static boolean isSubClass(PyObject pyObject, PyObject pyObject2) {
        return Py.isSubClass(pyObject, pyObject2, 0);
    }

    private static boolean isSubClass(PyObject pyObject, PyObject pyObject2, int n) {
        if (pyObject instanceof PyType && pyObject2 instanceof PyType) {
            if (pyObject == pyObject2) {
                return true;
            }
            return ((PyType)pyObject).isSubType((PyType)pyObject2);
        }
        if (pyObject2 instanceof PyClass && pyObject instanceof PyClass) {
            return ((PyClass)pyObject).isSubClass((PyClass)pyObject2);
        }
        if (pyObject2.getClass() == PyTuple.class) {
            if (n > Py.getSystemState().getrecursionlimit()) {
                throw Py.RuntimeError("nest level of tuple too deep");
            }
            for (int i = 0; i < pyObject2.__len__(); ++i) {
                if (!Py.isSubClass(pyObject, pyObject2.__getitem__(i), n + 1)) continue;
                return true;
            }
            return false;
        }
        if (pyObject.__findattr__("__bases__") == null) {
            throw Py.TypeError("issubclass() arg 1 must be a class");
        }
        if (pyObject2.__findattr__("__bases__") == null) {
            throw Py.TypeError("issubclass() arg 2 must be a class, type, or tuple of classes and types");
        }
        return Py.abstract_issubclass(pyObject, pyObject2);
    }

    static PyObject[] make_array(PyObject pyObject) {
        if (pyObject instanceof PySequenceList) {
            return ((PySequenceList)pyObject).getArray();
        }
        int n = 10;
        if (!(pyObject instanceof PyGenerator)) {
            try {
                n = pyObject.__len__();
            }
            catch (PyException pyException) {
                // empty catch block
            }
        }
        ArrayList<PyObject> arrayList = new ArrayList<PyObject>(n);
        for (PyObject pyObject2 : pyObject.asIterable()) {
            arrayList.add(pyObject2);
        }
        return arrayList.toArray(EmptyObjects);
    }

    /*
     * WARNING - void declaration
     */
    static {
        char c;
        void var0_1;
        TPFLAGS_HEAPTYPE = 512L;
        TPFLAGS_BASETYPE = 1024L;
        BOOTSTRAP_TYPES = Generic.set();
        BOOTSTRAP_TYPES.add(PyObject.class);
        BOOTSTRAP_TYPES.add(PyType.class);
        BOOTSTRAP_TYPES.add(PyBuiltinCallable.class);
        BOOTSTRAP_TYPES.add(PyDataDescr.class);
        integerCache = new PyInteger[1000];
        int c2 = -100;
        while (var0_1 < 900) {
            Py.integerCache[var0_1 + 100] = new PyInteger((int)var0_1);
            ++var0_1;
        }
        syspathJavaLoaderRestricted = false;
        threadStateMapping = new ThreadStateMapping();
        letters = new PyString[256];
        boolean bl = false;
        while (c < '\u0100') {
            Py.letters[c] = new PyString(new Character(c).toString());
            c = (char)(c + true);
        }
        nameindex = 0;
        idimpl = new IdImpl();
    }

    static class SingletonResolver
    implements Serializable {
        private String which;

        SingletonResolver(String string) {
            this.which = string;
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.which.equals("None")) {
                return None;
            }
            if (this.which.equals("Ellipsis")) {
                return Ellipsis;
            }
            if (this.which.equals("NotImplemented")) {
                return NotImplemented;
            }
            throw new StreamCorruptedException("unknown singleton: " + this.which);
        }
    }
}

