/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.CodeFlag;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyGenerator;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.modules._systemrestart;

public abstract class PyBaseCode
extends PyCode {
    public int co_argcount;
    int nargs;
    public int co_firstlineno = -1;
    public String[] co_varnames;
    public String[] co_cellvars;
    public int jy_npurecell;
    public String[] co_freevars;
    public String co_filename;
    public CompilerFlags co_flags = new CompilerFlags();
    public int co_nlocals;
    public boolean varargs;
    public boolean varkwargs;

    public boolean hasFreevars() {
        return this.co_freevars != null && this.co_freevars.length > 0;
    }

    public PyObject call(ThreadState threadState, PyFrame pyFrame, PyObject pyObject) {
        PyObject pyObject2;
        if (threadState.systemState == null) {
            threadState.systemState = Py.defaultSystemState;
        }
        PyException pyException = threadState.exception;
        pyFrame.f_back = threadState.frame;
        if (pyFrame.f_builtins == null) {
            pyFrame.f_builtins = pyFrame.f_back != null ? pyFrame.f_back.f_builtins : PySystemState.builtins;
        }
        pyFrame.setupEnv((PyTuple)pyObject);
        threadState.frame = pyFrame;
        if (threadState.tracefunc != null) {
            pyFrame.f_lineno = this.co_firstlineno;
            pyFrame.tracefunc = threadState.tracefunc.traceCall(pyFrame);
        }
        if (threadState.profilefunc != null) {
            threadState.profilefunc.traceCall(pyFrame);
        }
        try {
            pyObject2 = this.interpret(pyFrame, threadState);
        }
        catch (Throwable throwable) {
            PyException pyException2 = Py.JavaError(throwable);
            pyException2.tracebackHere(pyFrame);
            pyFrame.f_lasti = -1;
            if (pyFrame.tracefunc != null) {
                pyFrame.tracefunc.traceException(pyFrame, pyException2);
            }
            if (threadState.profilefunc != null) {
                threadState.profilefunc.traceException(pyFrame, pyException2);
            }
            threadState.exception = pyException;
            threadState.frame = threadState.frame.f_back;
            throw pyException2;
        }
        if (pyFrame.tracefunc != null) {
            pyFrame.tracefunc.traceReturn(pyFrame, pyObject2);
        }
        if (threadState.profilefunc != null) {
            threadState.profilefunc.traceReturn(pyFrame, pyObject2);
        }
        threadState.exception = pyException;
        threadState.frame = threadState.frame.f_back;
        if (threadState.systemState._systemRestart && Thread.currentThread().isInterrupted()) {
            throw new PyException(_systemrestart.SystemRestart);
        }
        return pyObject2;
    }

    public PyObject call(ThreadState threadState, PyObject pyObject, PyObject[] pyObjectArray, PyObject pyObject2) {
        if (this.co_argcount != 0 || this.varargs || this.varkwargs) {
            return this.call(threadState, Py.EmptyObjects, Py.NoKeywords, pyObject, pyObjectArray, pyObject2);
        }
        PyFrame pyFrame = new PyFrame(this, pyObject);
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(pyFrame, pyObject2);
        }
        return this.call(threadState, pyFrame, pyObject2);
    }

    public PyObject call(ThreadState threadState, PyObject pyObject, PyObject pyObject2, PyObject[] pyObjectArray, PyObject pyObject3) {
        if (this.co_argcount != 1 || this.varargs || this.varkwargs) {
            return this.call(threadState, new PyObject[]{pyObject}, Py.NoKeywords, pyObject2, pyObjectArray, pyObject3);
        }
        PyFrame pyFrame = new PyFrame(this, pyObject2);
        pyFrame.f_fastlocals[0] = pyObject;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(pyFrame, pyObject3);
        }
        return this.call(threadState, pyFrame, pyObject3);
    }

    public PyObject call(ThreadState threadState, PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject[] pyObjectArray, PyObject pyObject4) {
        if (this.co_argcount != 2 || this.varargs || this.varkwargs) {
            return this.call(threadState, new PyObject[]{pyObject, pyObject2}, Py.NoKeywords, pyObject3, pyObjectArray, pyObject4);
        }
        PyFrame pyFrame = new PyFrame(this, pyObject3);
        pyFrame.f_fastlocals[0] = pyObject;
        pyFrame.f_fastlocals[1] = pyObject2;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(pyFrame, pyObject4);
        }
        return this.call(threadState, pyFrame, pyObject4);
    }

    public PyObject call(ThreadState threadState, PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4, PyObject[] pyObjectArray, PyObject pyObject5) {
        if (this.co_argcount != 3 || this.varargs || this.varkwargs) {
            return this.call(threadState, new PyObject[]{pyObject, pyObject2, pyObject3}, Py.NoKeywords, pyObject4, pyObjectArray, pyObject5);
        }
        PyFrame pyFrame = new PyFrame(this, pyObject4);
        pyFrame.f_fastlocals[0] = pyObject;
        pyFrame.f_fastlocals[1] = pyObject2;
        pyFrame.f_fastlocals[2] = pyObject3;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(pyFrame, pyObject5);
        }
        return this.call(threadState, pyFrame, pyObject5);
    }

    public PyObject call(ThreadState threadState, PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4, PyObject pyObject5, PyObject[] pyObjectArray, PyObject pyObject6) {
        if (this.co_argcount != 4 || this.varargs || this.varkwargs) {
            return this.call(threadState, new PyObject[]{pyObject, pyObject2, pyObject3, pyObject4}, Py.NoKeywords, pyObject5, pyObjectArray, pyObject6);
        }
        PyFrame pyFrame = new PyFrame(this, pyObject5);
        pyFrame.f_fastlocals[0] = pyObject;
        pyFrame.f_fastlocals[1] = pyObject2;
        pyFrame.f_fastlocals[2] = pyObject3;
        pyFrame.f_fastlocals[3] = pyObject4;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(pyFrame, pyObject6);
        }
        return this.call(threadState, pyFrame, pyObject6);
    }

    public PyObject call(ThreadState threadState, PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray, PyObject pyObject2, PyObject[] pyObjectArray2, PyObject pyObject3) {
        PyObject[] pyObjectArray3 = new PyObject[pyObjectArray.length + 1];
        pyObjectArray3[0] = pyObject;
        System.arraycopy(pyObjectArray, 0, pyObjectArray3, 1, pyObjectArray.length);
        return this.call(threadState, pyObjectArray3, stringArray, pyObject2, pyObjectArray2, pyObject3);
    }

    public PyObject call(ThreadState threadState, PyObject[] pyObjectArray, String[] stringArray, PyObject pyObject, PyObject[] pyObjectArray2, PyObject pyObject2) {
        PyFrame pyFrame = new PyFrame(this, pyObject);
        int n = pyObjectArray.length - stringArray.length;
        if (this.co_argcount > 0 || this.varargs || this.varkwargs) {
            PyObject pyObject3;
            PyObject[] pyObjectArray3;
            int n2;
            int n3 = n;
            PyDictionary pyDictionary = null;
            PyObject[] pyObjectArray4 = pyFrame.f_fastlocals;
            if (this.varkwargs) {
                pyDictionary = new PyDictionary();
                n2 = this.co_argcount;
                if (this.varargs) {
                    ++n2;
                }
                pyObjectArray4[n2] = pyDictionary;
            }
            if (n > this.co_argcount) {
                if (!this.varargs) {
                    int n4 = pyObjectArray2 != null ? pyObjectArray2.length : 0;
                    String string = String.format("%.200s() takes %s %d %sargument%s (%d given)", this.co_name, n4 > 0 ? "at most" : "exactly", this.co_argcount, stringArray.length > 0 ? "non-keyword " : "", this.co_argcount == 1 ? "" : "s", n);
                    throw Py.TypeError(string);
                }
                n3 = this.co_argcount;
            }
            System.arraycopy(pyObjectArray, 0, pyObjectArray4, 0, n3);
            if (this.varargs) {
                pyObjectArray3 = new PyObject[n - n3];
                System.arraycopy(pyObjectArray, n3, pyObjectArray3, 0, n - n3);
                pyObjectArray4[this.co_argcount] = pyObject3 = new PyTuple(pyObjectArray3);
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                int n5;
                pyObjectArray3 = stringArray[n2];
                pyObject3 = pyObjectArray[n2 + n];
                for (n5 = 0; n5 < this.co_argcount && !this.co_varnames[n5].equals(pyObjectArray3); ++n5) {
                }
                if (n5 >= this.co_argcount) {
                    if (pyDictionary == null) {
                        throw Py.TypeError(String.format("%.200s() got an unexpected keyword argument '%.400s'", this.co_name, pyObjectArray3));
                    }
                    pyDictionary.__setitem__((String)pyObjectArray3, pyObject3);
                    continue;
                }
                if (pyObjectArray4[n5] != null) {
                    throw Py.TypeError(String.format("%.200s() got multiple values for keyword argument '%.400s'", this.co_name, pyObjectArray3));
                }
                pyObjectArray4[n5] = pyObject3;
            }
            if (n < this.co_argcount) {
                int n6 = pyObjectArray2 != null ? pyObjectArray2.length : 0;
                int n7 = this.co_argcount - n6;
                for (n2 = n; n2 < n7; ++n2) {
                    if (pyObjectArray4[n2] != null) continue;
                    String string = String.format("%.200s() takes %s %d %sargument%s (%d given)", this.co_name, this.varargs || n6 > 0 ? "at least" : "exactly", n7, stringArray.length > 0 ? "non-keyword " : "", n7 == 1 ? "" : "s", n2);
                    throw Py.TypeError(string);
                }
                for (n2 = n3 > n7 ? n3 - n7 : 0; n2 < n6; ++n2) {
                    if (pyObjectArray4[n7 + n2] != null) continue;
                    pyObjectArray4[n7 + n2] = pyObjectArray2[n2];
                }
            }
        } else if (n > 0) {
            throw Py.TypeError(String.format("%.200s() takes no arguments (%d given)", this.co_name, n));
        }
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(pyFrame, pyObject2);
        }
        return this.call(threadState, pyFrame, pyObject2);
    }

    public String toString() {
        return String.format("<code object %.100s at %s, file \"%.300s\", line %d>", this.co_name, Py.idstr(this), this.co_filename, this.co_firstlineno);
    }

    protected abstract PyObject interpret(PyFrame var1, ThreadState var2);

    protected int getline(PyFrame pyFrame) {
        return pyFrame.f_lineno;
    }

    public CompilerFlags getCompilerFlags() {
        return this.co_flags;
    }
}

