/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PyFileReader
extends PyObject {
    static final int DEFAULT_BUF_SIZE = 1024;
    private final BufferedReader reader;
    private boolean closed;
    private char[] reuseableBuffer = null;

    public PyFileReader(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.closed = false;
    }

    public boolean closed() {
        return this.closed;
    }

    public void checkClosed() {
        if (this.closed()) {
            throw Py.ValueError("I/O operation on closed file");
        }
    }

    public synchronized void flush() {
        this.checkClosed();
    }

    public void close() {
        try {
            if (!this.closed()) {
                this.reader.close();
                this.closed = true;
            }
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    protected char[] needBuffer(int n) {
        if (this.reuseableBuffer == null) {
            if (n > 1024) {
                return new char[n];
            }
            this.reuseableBuffer = new char[1024];
        }
        if (n <= this.reuseableBuffer.length) {
            return this.reuseableBuffer;
        }
        return new char[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyString read(int n) {
        if (n < 0) {
            BufferedReader bufferedReader = this.reader;
            synchronized (bufferedReader) {
                this.checkClosed();
                StringBuilder stringBuilder = new StringBuilder();
                char[] cArray = this.needBuffer(1024);
                int n2 = cArray.length;
                try {
                    int n3;
                    while ((n3 = this.reader.read(cArray, 0, n2)) >= 0) {
                        stringBuilder.append(cArray, 0, n3);
                        if (n3 >= n2) continue;
                        break;
                    }
                }
                catch (IOException iOException) {
                    throw Py.IOError(iOException);
                }
                return new PyString(stringBuilder.toString());
            }
        }
        BufferedReader bufferedReader = this.reader;
        synchronized (bufferedReader) {
            this.checkClosed();
            char[] cArray = this.needBuffer(n);
            int n4 = cArray.length;
            try {
                int n5 = this.reader.read(cArray, 0, n);
                if (n5 < 1) {
                    return new PyString("");
                }
                return new PyString(new String(cArray, 0, n5));
            }
            catch (IOException iOException) {
                throw Py.IOError(iOException);
            }
        }
    }

    public PyString read() {
        return this.read(-1);
    }

    public PyString readline(int n) {
        if (n >= 0) {
            throw Py.NotImplementedError("size argument to readline not implemented for PyFileReader");
        }
        BufferedReader bufferedReader = this.reader;
        synchronized (bufferedReader) {
            try {
                String string = this.reader.readLine();
                if (string == null) {
                    return new PyString("");
                }
                return new PyString(string + "\n");
            }
            catch (IOException iOException) {
                throw Py.IOError(iOException);
            }
        }
    }

    public PyString readline() {
        return this.readline(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyObject readlines(int n) {
        BufferedReader bufferedReader = this.reader;
        synchronized (bufferedReader) {
            PyString pyString;
            int n2;
            this.checkClosed();
            PyList pyList = new PyList();
            int n3 = 0;
            while ((n2 = (pyString = this.readline(-1)).getString().length()) != 0) {
                pyList.append(pyString);
                if (n <= 0 || (n3 += n2) < n) continue;
            }
            return pyList;
        }
    }

    public PyObject readlines() {
        return this.readlines(0);
    }
}

