/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyFastSequenceIter;
import org.python.core.PyList$exposed___new__;
import org.python.core.PyList$list___add___exposer;
import org.python.core.PyList$list___eq___exposer;
import org.python.core.PyList$list___ge___exposer;
import org.python.core.PyList$list___gt___exposer;
import org.python.core.PyList$list___iadd___exposer;
import org.python.core.PyList$list___imul___exposer;
import org.python.core.PyList$list___le___exposer;
import org.python.core.PyList$list___lt___exposer;
import org.python.core.PyList$list___mul___exposer;
import org.python.core.PyList$list___ne___exposer;
import org.python.core.PyList$list___radd___exposer;
import org.python.core.PyList$list___rmul___exposer;
import org.python.core.PyList$list_toString_exposer;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySequenceList;
import org.python.core.PySlice;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="list", base=PyObject.class, doc="list() -> new list\nlist(sequence) -> new list initialized from sequence's items")
public class PyList
extends PySequenceList
implements List {
    public static final PyType TYPE;
    private final List<PyObject> list;
    public volatile int gListAllocatedStatus = -1;

    public PyList() {
        this(TYPE);
    }

    public PyList(PyType type) {
        super(type);
        this.list = Generic.list();
    }

    private PyList(List list, boolean convert) {
        super(TYPE);
        if (!convert) {
            this.list = list;
        } else {
            this.list = Generic.list();
            for (Object o : list) {
                this.add(o);
            }
        }
    }

    public PyList(PyType type, PyObject[] elements) {
        super(type);
        this.list = new ArrayList<PyObject>(Arrays.asList(elements));
    }

    public PyList(PyType type, Collection c) {
        super(type);
        this.list = new ArrayList<PyObject>(c.size());
        for (Object o : c) {
            this.add(o);
        }
    }

    public PyList(PyObject[] elements) {
        this(TYPE, elements);
    }

    public PyList(Collection c) {
        this(TYPE, c);
    }

    public PyList(PyObject o) {
        this(TYPE);
        for (PyObject item : o.asIterable()) {
            this.list.add(item);
        }
    }

    public static PyList fromList(List<PyObject> list) {
        return new PyList(list, false);
    }

    List<PyObject> getList() {
        return Collections.unmodifiableList(this.list);
    }

    private static List<PyObject> listify(Iterator<PyObject> iter) {
        List<PyObject> list = Generic.list();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public PyList(Iterator<PyObject> iter) {
        this(TYPE, PyList.listify(iter));
    }

    @ExposedNew
    final void list___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("list", args, kwds, new String[]{"sequence"}, 0);
        PyObject seq = ap.getPyObject(0, null);
        this.clear();
        if (seq == null) {
            return;
        }
        if (seq instanceof PyList) {
            this.list.addAll(((PyList)seq).list);
        } else if (seq instanceof PyTuple) {
            this.list.addAll(((PyTuple)seq).getList());
        } else {
            for (PyObject item : seq.asIterable()) {
                this.append(item);
            }
        }
    }

    @Override
    public int __len__() {
        return this.list___len__();
    }

    final synchronized int list___len__() {
        return this.size();
    }

    @Override
    protected void del(int i) {
        this.remove(i);
    }

    @Override
    protected void delRange(int start, int stop) {
        this.remove(start, stop);
    }

    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (stop < start) {
            stop = start;
        }
        if (value instanceof PyList) {
            if (value == this) {
                value = new PyList((PySequence)value);
            }
            this.setslicePyList(start, stop, step, (PyList)value);
        } else if (value instanceof PySequence) {
            this.setsliceIterator(start, stop, step, value.asIterable().iterator());
        } else if (value instanceof List) {
            this.setsliceList(start, stop, step, (List)((Object)value));
        } else {
            Object valueList = value.__tojava__(List.class);
            if (valueList != null && valueList != Py.NoConversion) {
                this.setsliceList(start, stop, step, (List)valueList);
            } else {
                value = new PyList(value);
                this.setsliceIterator(start, stop, step, value.asIterable().iterator());
            }
        }
    }

    private final void setsliceList(int start, int stop, int step, List value) {
        if (step == 1) {
            this.list.subList(start, stop).clear();
            int n = value.size();
            int i = 0;
            int j = start;
            while (i < n) {
                this.list.add(j, Py.java2py(value.get(i)));
                ++i;
                ++j;
            }
        } else {
            int size = this.list.size();
            ListIterator iter = value.listIterator();
            int j = start;
            while (iter.hasNext()) {
                PyObject item = Py.java2py(iter.next());
                if (j >= size) {
                    this.list.add(item);
                } else {
                    this.list.set(j, item);
                }
                j += step;
            }
        }
    }

    private final void setsliceIterator(int start, int stop, int step, Iterator<PyObject> iter) {
        if (step == 1) {
            ArrayList<PyObject> insertion = new ArrayList<PyObject>();
            if (iter != null) {
                while (iter.hasNext()) {
                    insertion.add(iter.next());
                }
            }
            this.list.subList(start, stop).clear();
            this.list.addAll(start, insertion);
        } else {
            int size = this.list.size();
            int j = start;
            while (iter.hasNext()) {
                PyObject item = iter.next();
                if (j >= size) {
                    this.list.add(item);
                } else {
                    this.list.set(j, item);
                }
                j += step;
            }
        }
    }

    private final void setslicePyList(int start, int stop, int step, PyList other) {
        if (step == 1) {
            this.list.subList(start, stop).clear();
            this.list.addAll(start, other.list);
        } else {
            int size = this.list.size();
            ListIterator<PyObject> iter = other.list.listIterator();
            int j = start;
            while (iter.hasNext()) {
                PyObject item = (PyObject)iter.next();
                if (j >= size) {
                    this.list.add(item);
                } else {
                    this.list.set(j, item);
                }
                j += step;
            }
        }
    }

    @Override
    protected synchronized PyObject repeat(int count) {
        if (count < 0) {
            count = 0;
        }
        int size = this.size();
        int newSize = size * count;
        if (count != 0 && newSize / count != size) {
            throw Py.MemoryError("");
        }
        PyObject[] elements = this.list.toArray(new PyObject[size]);
        PyObject[] newList = new PyObject[newSize];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(elements, 0, newList, i * size, size);
        }
        return new PyList(newList);
    }

    final synchronized PyObject list___ne__(PyObject o) {
        return this.seq___ne__(o);
    }

    final synchronized PyObject list___eq__(PyObject o) {
        return this.seq___eq__(o);
    }

    final synchronized PyObject list___lt__(PyObject o) {
        return this.seq___lt__(o);
    }

    final synchronized PyObject list___le__(PyObject o) {
        return this.seq___le__(o);
    }

    final synchronized PyObject list___gt__(PyObject o) {
        return this.seq___gt__(o);
    }

    final synchronized PyObject list___ge__(PyObject o) {
        return this.seq___ge__(o);
    }

    @Override
    public PyObject __imul__(PyObject o) {
        return this.list___imul__(o);
    }

    final synchronized PyObject list___imul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        int count = o.asIndex(Py.OverflowError);
        int size = this.size();
        if (size == 0 || count == 1) {
            return this;
        }
        if (count < 1) {
            this.clear();
            return this;
        }
        if (size > Integer.MAX_VALUE / count) {
            throw Py.MemoryError("");
        }
        int newSize = size * count;
        if (this.list instanceof ArrayList) {
            ((ArrayList)this.list).ensureCapacity(newSize);
        }
        ArrayList<PyObject> oldList = new ArrayList<PyObject>(this.list);
        for (int i = 1; i < count; ++i) {
            this.list.addAll(oldList);
        }
        this.gListAllocatedStatus = this.list.size();
        return this;
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.list___mul__(o);
    }

    final synchronized PyObject list___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.list___rmul__(o);
    }

    final synchronized PyObject list___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __add__(PyObject o) {
        return this.list___add__(o);
    }

    final synchronized PyObject list___add__(PyObject o) {
        Object oList;
        PyList sum = null;
        if (o instanceof PySequenceList && !(o instanceof PyTuple)) {
            if (o instanceof PyList) {
                List<PyObject> oList2 = ((PyList)o).list;
                ArrayList<PyObject> newList = new ArrayList<PyObject>(this.list.size() + oList2.size());
                newList.addAll(this.list);
                newList.addAll(oList2);
                sum = PyList.fromList(newList);
            }
        } else if (!(o instanceof PySequenceList) && (oList = o.__tojava__(List.class)) != Py.NoConversion && oList != null) {
            List otherList = (List)oList;
            sum = new PyList();
            sum.list_extend(this);
            Iterator i = otherList.iterator();
            while (i.hasNext()) {
                sum.add(i.next());
            }
        }
        return sum;
    }

    @Override
    public PyObject __radd__(PyObject o) {
        return this.list___radd__(o);
    }

    final synchronized PyObject list___radd__(PyObject o) {
        PyList sum = null;
        if (o instanceof PySequence) {
            return null;
        }
        Object oList = o.__tojava__(List.class);
        if (oList != Py.NoConversion && oList != null) {
            sum = new PyList();
            sum.addAll((Collection)((List)oList));
            sum.extend(this);
        }
        return sum;
    }

    final synchronized boolean list___contains__(PyObject o) {
        return this.object___contains__(o);
    }

    final synchronized void list___delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final synchronized void list___setitem__(PyObject o, PyObject def) {
        this.seq___setitem__(o, def);
    }

    final synchronized PyObject list___getitem__(PyObject o) {
        PyObject ret = this.seq___finditem__(o);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + o);
        }
        return ret;
    }

    @Override
    public PyObject __iter__() {
        return this.list___iter__();
    }

    public synchronized PyObject list___iter__() {
        return new PyFastSequenceIter(this);
    }

    final synchronized PyObject list___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final synchronized void list___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        this.seq___setslice__(start, stop, step, value);
    }

    final synchronized void list___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "can only concatenate list (not \"{2}\") to list";
        }
        return super.unsupportedopMessage(op, o2);
    }

    @Override
    public String toString() {
        return this.list_toString();
    }

    final synchronized String list_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "[...]";
        }
        StringBuilder buf = new StringBuilder("[");
        int length = this.size();
        int i = 0;
        for (PyObject item : this.list) {
            buf.append(item.__repr__().toString());
            if (i < length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("]");
        ts.exitRepr(this);
        return buf.toString();
    }

    public void append(PyObject o) {
        this.list_append(o);
    }

    final synchronized void list_append(PyObject o) {
        this.pyadd(o);
        this.gListAllocatedStatus = this.list.size();
    }

    public int count(PyObject o) {
        return this.list_count(o);
    }

    final synchronized int list_count(PyObject o) {
        int count = 0;
        for (PyObject item : this.list) {
            if (!item.equals(o)) continue;
            ++count;
        }
        return count;
    }

    public int index(PyObject o) {
        return this.index(o, 0);
    }

    public int index(PyObject o, int start) {
        return this.list_index(o, start, this.size());
    }

    public int index(PyObject o, int start, int stop) {
        return this.list_index(o, start, stop);
    }

    final synchronized int list_index(PyObject o, PyObject start, PyObject stop) {
        int startInt = start == null ? 0 : PySlice.calculateSliceIndex(start);
        int stopInt = stop == null ? this.size() : PySlice.calculateSliceIndex(stop);
        return this.list_index(o, startInt, stopInt);
    }

    final synchronized int list_index(PyObject o, int start, int stop) {
        return this._index(o, "list.index(x): x not in list", start, stop);
    }

    final synchronized int list_index(PyObject o, int start) {
        return this._index(o, "list.index(x): x not in list", start, this.size());
    }

    final synchronized int list_index(PyObject o) {
        return this._index(o, "list.index(x): x not in list", 0, this.size());
    }

    private int _index(PyObject o, String message, int start, int stop) {
        int validStart;
        int validStop = this.boundToSequence(stop);
        int i = validStart = this.boundToSequence(start);
        if (validStart <= validStop) {
            try {
                for (PyObject item : this.list.subList(validStart, validStop)) {
                    if (item.equals(o)) {
                        return i;
                    }
                    ++i;
                }
            }
            catch (ConcurrentModificationException ex) {
                throw Py.ValueError(message);
            }
        }
        throw Py.ValueError(message);
    }

    public void insert(int index, PyObject o) {
        this.list_insert(index, o);
    }

    final synchronized void list_insert(int index, PyObject o) {
        if (index < 0) {
            index = Math.max(0, this.size() + index);
        }
        if (index > this.size()) {
            index = this.size();
        }
        this.pyadd(index, o);
        this.gListAllocatedStatus = this.list.size();
    }

    public void remove(PyObject o) {
        this.list_remove(o);
    }

    final synchronized void list_remove(PyObject o) {
        this.del(this._index(o, "list.remove(x): x not in list", 0, this.size()));
        this.gListAllocatedStatus = this.list.size();
    }

    public void reverse() {
        this.list_reverse();
    }

    final synchronized void list_reverse() {
        Collections.reverse(this.list);
        this.gListAllocatedStatus = this.list.size();
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        return this.list_pop(n);
    }

    final synchronized PyObject list_pop(int n) {
        int length = this.size();
        if (length == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (n < 0) {
            n += length;
        }
        if (n < 0 || n >= length) {
            throw Py.IndexError("pop index out of range");
        }
        PyObject v = this.list.remove(n);
        return v;
    }

    public void extend(PyObject o) {
        this.list_extend(o);
    }

    final synchronized void list_extend(PyObject o) {
        if (o instanceof PyList) {
            this.list.addAll(((PyList)o).list);
        } else {
            for (PyObject item : o.asIterable()) {
                this.list.add(item);
            }
        }
        this.gListAllocatedStatus = this.list.size();
    }

    @Override
    public PyObject __iadd__(PyObject o) {
        return this.list___iadd__(o);
    }

    final synchronized PyObject list___iadd__(PyObject o) {
        PyObject it;
        PyType oType = o.getType();
        if (oType == TYPE || oType == PyTuple.TYPE || this == o) {
            this.extend(PyList.fastSequence(o, "argument must be iterable"));
            return this;
        }
        try {
            it = o.__iter__();
        }
        catch (PyException pye) {
            if (!pye.match(Py.TypeError)) {
                throw pye;
            }
            return null;
        }
        this.extend(it);
        return this;
    }

    final synchronized void list_sort(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("list", args, kwds, new String[]{"cmp", "key", "reverse"}, 0);
        PyObject cmp = ap.getPyObject(0, Py.None);
        PyObject key = ap.getPyObject(1, Py.None);
        PyObject reverse = ap.getPyObject(2, Py.False);
        this.sort(cmp, key, reverse);
    }

    public void sort(PyObject cmp, PyObject key, PyObject reverse) {
        boolean bReverse = reverse.__nonzero__();
        if (key == Py.None || key == null) {
            if (cmp == Py.None || cmp == null) {
                this.sort(bReverse);
            } else {
                this.sort(cmp, bReverse);
            }
        } else {
            this.sort(cmp, key, bReverse);
        }
    }

    public void sort() {
        this.sort(false);
    }

    private synchronized void sort(boolean reverse) {
        this.gListAllocatedStatus = -1;
        if (reverse) {
            Collections.reverse(this.list);
        }
        Collections.sort(this.list, new PyObjectDefaultComparator(this));
        if (reverse) {
            Collections.reverse(this.list);
        }
        this.gListAllocatedStatus = this.list.size();
    }

    public void sort(PyObject compare) {
        this.sort(compare, false);
    }

    private synchronized void sort(PyObject compare, boolean reverse) {
        this.gListAllocatedStatus = -1;
        if (reverse) {
            Collections.reverse(this.list);
        }
        PyObjectComparator c = new PyObjectComparator(this, compare);
        Collections.sort(this.list, c);
        if (reverse) {
            Collections.reverse(this.list);
        }
        this.gListAllocatedStatus = this.list.size();
    }

    private synchronized void sort(PyObject cmp, PyObject key, boolean reverse) {
        this.gListAllocatedStatus = -1;
        int size = this.list.size();
        ArrayList<KV> decorated = new ArrayList<KV>(size);
        for (PyObject value : this.list) {
            decorated.add(new KV(key.__call__(value), value));
        }
        this.list.clear();
        KVComparator c = new KVComparator(this, cmp);
        if (reverse) {
            Collections.reverse(decorated);
        }
        Collections.sort(decorated, c);
        if (reverse) {
            Collections.reverse(decorated);
        }
        if (this.list instanceof ArrayList) {
            ((ArrayList)this.list).ensureCapacity(size);
        }
        for (KV kv : decorated) {
            this.list.add(kv.value);
        }
        this.gListAllocatedStatus = this.list.size();
    }

    @Override
    public int hashCode() {
        return this.list___hash__();
    }

    final synchronized int list___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return new PyTuple(new PyTuple(this.getArray()));
    }

    @Override
    public void add(int index, Object element) {
        this.pyadd(index, Py.java2py(element));
    }

    @Override
    public boolean add(Object o) {
        this.pyadd(Py.java2py(o));
        return true;
    }

    @Override
    public synchronized boolean addAll(int index, Collection c) {
        PyList elements = new PyList(c);
        return this.list.addAll(index, elements.list);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(0, c);
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.list.contains(Py.java2py(o));
    }

    @Override
    public synchronized boolean containsAll(Collection c) {
        if (c instanceof PyList) {
            return this.list.containsAll(((PyList)c).list);
        }
        if (c instanceof PyTuple) {
            return this.list.containsAll(((PyTuple)c).getList());
        }
        return this.list.containsAll(new PyList(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PyObject) {
            PyList pyList = this;
            synchronized (pyList) {
                return this._eq((PyObject)other).__nonzero__();
            }
        }
        if (other instanceof List) {
            PyList pyList = this;
            synchronized (pyList) {
                return ((Object)this.list).equals(other);
            }
        }
        return false;
    }

    @Override
    public synchronized Object get(int index) {
        return this.list.get(index).__tojava__(Object.class);
    }

    @Override
    public synchronized PyObject[] getArray() {
        return this.list.toArray(Py.EmptyObjects);
    }

    @Override
    public synchronized int indexOf(Object o) {
        return this.list.indexOf(Py.java2py(o));
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private final Iterator<PyObject> iter;
            {
                this.iter = PyList.this.list.iterator();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }

            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        return this.list.lastIndexOf(Py.java2py(o));
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            private final ListIterator<PyObject> iter;
            {
                this.iter = PyList.this.list.listIterator(index);
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }

            public boolean hasPrevious() {
                return this.iter.hasPrevious();
            }

            public Object previous() {
                return this.iter.previous().__tojava__(Object.class);
            }

            public int nextIndex() {
                return this.iter.nextIndex();
            }

            public int previousIndex() {
                return this.iter.previousIndex();
            }

            public void remove() {
                this.iter.remove();
            }

            public void set(Object object) {
                this.iter.set(Py.java2py(object));
            }

            public void add(Object object) {
                this.iter.add(Py.java2py(object));
            }
        };
    }

    @Override
    public synchronized void pyadd(int index, PyObject element) {
        this.list.add(index, element);
    }

    @Override
    public synchronized boolean pyadd(PyObject o) {
        this.list.add(o);
        return true;
    }

    @Override
    public synchronized PyObject pyget(int index) {
        return this.list.get(index);
    }

    @Override
    public synchronized void pyset(int index, PyObject element) {
        this.list.set(index, element);
    }

    @Override
    public synchronized Object remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public synchronized void remove(int start, int stop) {
        this.list.subList(start, stop).clear();
    }

    @Override
    public synchronized boolean removeAll(Collection c) {
        if (c instanceof PySequenceList) {
            return this.list.removeAll(c);
        }
        return this.list.removeAll(new PyList(c));
    }

    @Override
    public synchronized boolean retainAll(Collection c) {
        if (c instanceof PySequenceList) {
            return this.list.retainAll(c);
        }
        return this.list.retainAll(new PyList(c));
    }

    @Override
    public synchronized Object set(int index, Object element) {
        return this.list.set(index, Py.java2py(element)).__tojava__(Object.class);
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public synchronized List subList(int fromIndex, int toIndex) {
        return PyList.fromList(this.list.subList(fromIndex, toIndex));
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] copy = this.list.toArray();
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = ((PyObject)copy[i]).__tojava__(Object.class);
        }
        return copy;
    }

    @Override
    public synchronized Object[] toArray(Object[] a) {
        int i;
        int size = this.size();
        Class<?> type = a.getClass().getComponentType();
        if (a.length < size) {
            a = (Object[])Array.newInstance(type, size);
        }
        for (i = 0; i < size; ++i) {
            a[i] = this.list.get(i).__tojava__(type);
        }
        if (a.length > size) {
            for (i = size; i < a.length; ++i) {
                a[i] = null;
            }
        }
        return a;
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        ArrayList<PyObject> newList;
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyList.sliceLength(start, stop, step);
        if (step == 1) {
            newList = new ArrayList<PyObject>(this.list.subList(start, stop));
        } else {
            newList = new ArrayList(n);
            int i = start;
            for (int j = 0; j < n; ++j) {
                newList.add(this.list.get(i));
                i += step;
            }
        }
        return PyList.fromList(newList);
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.list.remove(Py.java2py(o));
    }

    static {
        PyType.addBuilder(PyList.class, new PyList$PyExposer());
        TYPE = PyType.fromClass(PyList.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KVComparator
    implements Comparator<KV> {
        private final PyList list;
        private final PyObject cmp;

        KVComparator(PyList pyList, PyObject pyObject) {
            this.list = pyList;
            this.cmp = pyObject;
        }

        @Override
        public int compare(KV kV, KV kV2) {
            int n = this.cmp != null && this.cmp != Py.None ? this.cmp.__call__(kV.key, kV2.key).asInt() : kV.key._cmp(kV2.key);
            if (this.list.gListAllocatedStatus >= 0) {
                throw Py.ValueError("list modified during sort");
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof KVComparator) {
                return this.cmp.equals(((KVComparator)object).cmp);
            }
            return false;
        }
    }

    private static class KV {
        private final PyObject key;
        private final PyObject value;

        KV(PyObject pyObject, PyObject pyObject2) {
            this.key = pyObject;
            this.value = pyObject2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PyObjectComparator
    implements Comparator<PyObject> {
        private final PyList list;
        private final PyObject cmp;

        PyObjectComparator(PyList pyList, PyObject pyObject) {
            this.list = pyList;
            this.cmp = pyObject;
        }

        @Override
        public int compare(PyObject pyObject, PyObject pyObject2) {
            int n = this.cmp.__call__(pyObject, pyObject2).asInt();
            if (this.list.gListAllocatedStatus >= 0) {
                throw Py.ValueError("list modified during sort");
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof PyObjectComparator) {
                return this.cmp.equals(((PyObjectComparator)object).cmp);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PyObjectDefaultComparator
    implements Comparator<PyObject> {
        private final PyList list;

        PyObjectDefaultComparator(PyList pyList) {
            this.list = pyList;
        }

        @Override
        public int compare(PyObject pyObject, PyObject pyObject2) {
            int n = pyObject._cmp(pyObject2);
            if (this.list.gListAllocatedStatus >= 0) {
                throw Py.ValueError("list modified during sort");
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            return object instanceof PyObjectDefaultComparator;
        }
    }

    public class PyList$list___init___exposer
    extends PyBuiltinMethod {
        public PyList$list___init___exposer(String string) {
            super(string);
            this.doc = "x.__init__(...) initializes x; see x.__class__.__doc__ for signature";
        }

        public PyList$list___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__init__(...) initializes x; see x.__class__.__doc__ for signature";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyList)this.self).list___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyList$list___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___len___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyList$list___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyList)this.self).list___len__());
        }
    }

    public class PyList$list___contains___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___contains___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__contains__(y) <==> y in x";
        }

        public PyList$list___contains___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__contains__(y) <==> y in x";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___contains___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyList)this.self).list___contains__(pyObject));
        }
    }

    public class PyList$list___delitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___delitem___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__delitem__(y) <==> del x[y]";
        }

        public PyList$list___delitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__delitem__(y) <==> del x[y]";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___delitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyList)this.self).list___delitem__(pyObject);
            return Py.None;
        }
    }

    public class PyList$list___setitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___setitem___exposer(String string) {
            super(string, 3, 3);
            this.doc = "x.__setitem__(i, y) <==> x[i]=y";
        }

        public PyList$list___setitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__setitem__(i, y) <==> x[i]=y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___setitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyList)this.self).list___setitem__(pyObject, pyObject2);
            return Py.None;
        }
    }

    public class PyList$list___getitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___getitem___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__getitem__(y) <==> x[y]";
        }

        public PyList$list___getitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getitem__(y) <==> x[y]";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___getitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyList)this.self).list___getitem__(pyObject);
        }
    }

    public class PyList$list___iter___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___iter___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__iter__() <==> iter(x)";
        }

        public PyList$list___iter___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__iter__() <==> iter(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___iter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyList)this.self).list___iter__();
        }
    }

    public class PyList$list___getslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___getslice___exposer(String string) {
            super(string, 3, 4);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyList$list___getslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___getslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyList)this.self).list___getslice__(pyObject, pyObject2, pyObject3);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyList)this.self).list___getslice__(pyObject, pyObject2, null);
        }
    }

    public class PyList$list___setslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___setslice___exposer(String string) {
            super(string, 4, 5);
            this.doc = "x.__setslice__(i, j, y) <==> x[i:j]=y\n               \n               Use  of negative indices is not supported.";
        }

        public PyList$list___setslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__setslice__(i, j, y) <==> x[i:j]=y\n               \n               Use  of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___setslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
            ((PyList)this.self).list___setslice__(pyObject, pyObject2, pyObject3, pyObject4);
            return Py.None;
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            ((PyList)this.self).list___setslice__(pyObject, pyObject2, pyObject3, null);
            return Py.None;
        }
    }

    public class PyList$list___delslice___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___delslice___exposer(String string) {
            super(string, 3, 4);
            this.doc = "x.__delslice__(i, j) <==> del x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyList$list___delslice___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__delslice__(i, j) <==> del x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___delslice___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            ((PyList)this.self).list___delslice__(pyObject, pyObject2, pyObject3);
            return Py.None;
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyList)this.self).list___delslice__(pyObject, pyObject2, null);
            return Py.None;
        }
    }

    public class PyList$list_append_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_append_exposer(String string) {
            super(string, 2, 2);
            this.doc = "L.append(object) -- append object to end";
        }

        public PyList$list_append_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "L.append(object) -- append object to end";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list_append_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyList)this.self).list_append(pyObject);
            return Py.None;
        }
    }

    public class PyList$list_count_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_count_exposer(String string) {
            super(string, 2, 2);
            this.doc = "L.count(value) -> integer -- return number of occurrences of value";
        }

        public PyList$list_count_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "L.count(value) -> integer -- return number of occurrences of value";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list_count_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyList)this.self).list_count(pyObject));
        }
    }

    public class PyList$list_index_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_index_exposer(String string) {
            super(string, 2, 4);
            this.doc = "L.index(value, [start, [stop]]) -> integer -- return first index of value";
        }

        public PyList$list_index_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "L.index(value, [start, [stop]]) -> integer -- return first index of value";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list_index_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyList)this.self).list_index(pyObject, pyObject2, pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyList)this.self).list_index(pyObject, pyObject2, null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyList)this.self).list_index(pyObject, null, null));
        }
    }

    public class PyList$list_insert_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_insert_exposer(String string) {
            super(string, 3, 3);
            this.doc = "L.insert(index, object) -- insert object before index";
        }

        public PyList$list_insert_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "L.insert(index, object) -- insert object before index";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list_insert_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyList)this.self).list_insert(Py.py2int(pyObject), pyObject2);
            return Py.None;
        }
    }

    public class PyList$list_remove_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_remove_exposer(String string) {
            super(string, 2, 2);
            this.doc = "L.remove(value) -- remove first occurrence of value";
        }

        public PyList$list_remove_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "L.remove(value) -- remove first occurrence of value";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list_remove_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyList)this.self).list_remove(pyObject);
            return Py.None;
        }
    }

    public class PyList$list_reverse_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_reverse_exposer(String string) {
            super(string, 1, 1);
            this.doc = "L.reverse() -- reverse *IN PLACE*";
        }

        public PyList$list_reverse_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "L.reverse() -- reverse *IN PLACE*";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list_reverse_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((PyList)this.self).list_reverse();
            return Py.None;
        }
    }

    public class PyList$list_pop_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_pop_exposer(String string) {
            super(string, 1, 2);
            this.doc = "L.pop([index]) -> item -- remove and return item at index (default last)";
        }

        public PyList$list_pop_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "L.pop([index]) -> item -- remove and return item at index (default last)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list_pop_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyList)this.self).list_pop(Py.py2int(pyObject));
        }

        public PyObject __call__() {
            return ((PyList)this.self).list_pop(-1);
        }
    }

    public class PyList$list_extend_exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list_extend_exposer(String string) {
            super(string, 2, 2);
            this.doc = "L.extend(iterable) -- extend list by appending elements from the iterable";
        }

        public PyList$list_extend_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "L.extend(iterable) -- extend list by appending elements from the iterable";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list_extend_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyList)this.self).list_extend(pyObject);
            return Py.None;
        }
    }

    public class PyList$list_sort_exposer
    extends PyBuiltinMethod {
        public PyList$list_sort_exposer(String string) {
            super(string);
            this.doc = "L.sort(cmp=None, key=None, reverse=False) -- stable sort *IN PLACE*;\ncmp(x, y) -> -1, 0, 1";
        }

        public PyList$list_sort_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "L.sort(cmp=None, key=None, reverse=False) -- stable sort *IN PLACE*;\ncmp(x, y) -> -1, 0, 1";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list_sort_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyList)this.self).list_sort(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyList$list___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyList$list___hash___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyList$list___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyList$list___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyList)this.self).list___hash__());
        }
    }

    public class PyList$PyExposer
    extends BaseTypeBuilder {
        public PyList$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyList$list___init___exposer("__init__"), new PyList$list___len___exposer("__len__"), new PyList$list___ne___exposer("__ne__"), new PyList$list___eq___exposer("__eq__"), new PyList$list___lt___exposer("__lt__"), new PyList$list___le___exposer("__le__"), new PyList$list___gt___exposer("__gt__"), new PyList$list___ge___exposer("__ge__"), new PyList$list___imul___exposer("__imul__"), new PyList$list___mul___exposer("__mul__"), new PyList$list___rmul___exposer("__rmul__"), new PyList$list___add___exposer("__add__"), new PyList$list___radd___exposer("__radd__"), new PyList$list___contains___exposer("__contains__"), new PyList$list___delitem___exposer("__delitem__"), new PyList$list___setitem___exposer("__setitem__"), new PyList$list___getitem___exposer("__getitem__"), new PyList$list___iter___exposer("__iter__"), new PyList$list___getslice___exposer("__getslice__"), new PyList$list___setslice___exposer("__setslice__"), new PyList$list___delslice___exposer("__delslice__"), new PyList$list_toString_exposer("__repr__"), new PyList$list_append_exposer("append"), new PyList$list_count_exposer("count"), new PyList$list_index_exposer("index"), new PyList$list_insert_exposer("insert"), new PyList$list_remove_exposer("remove"), new PyList$list_reverse_exposer("reverse"), new PyList$list_pop_exposer("pop"), new PyList$list_extend_exposer("extend"), new PyList$list___iadd___exposer("__iadd__"), new PyList$list_sort_exposer("sort"), new PyList$list___hash___exposer("__hash__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("list", PyList.class, PyObject.class, true, "list() -> new list\nlist(sequence) -> new list initialized from sequence's items", pyBuiltinMethodArray, pyDataDescrArray, new PyList$exposed___new__());
        }
    }
}

