/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyString;
import org.python.core.ReflectedArgs;
import org.python.core.ReflectedCallData;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyReflectedFunction
extends PyObject {
    public String __name__;
    public PyObject __doc__ = Py.None;
    public ReflectedArgs[] argslist = new ReflectedArgs[1];
    public int nargs;
    private boolean calledStatically;

    protected PyReflectedFunction(String string) {
        this.__name__ = string;
    }

    public PyReflectedFunction(Method ... methodArray) {
        this(methodArray[0].getName());
        for (Method method : methodArray) {
            this.addMethod(method);
        }
        if (this.nargs == 0) {
            String string = String.format("Attempted to make Java method visible, but it isn't callable[method=%s, class=%s]", methodArray[0].getName(), methodArray[0].getDeclaringClass());
            throw Py.SystemError(string);
        }
    }

    @Override
    public PyObject _doget(PyObject pyObject) {
        return this._doget(pyObject, null);
    }

    @Override
    public PyObject _doget(PyObject pyObject, PyObject pyObject2) {
        if (pyObject == null) {
            return this.calledStatically ? this : this.copyWithCalledStatically(true);
        }
        return new PyMethod(this.calledStatically ? this.copyWithCalledStatically(false) : this, pyObject, pyObject2);
    }

    private ReflectedArgs makeArgs(Method method) {
        return new ReflectedArgs(method, method.getParameterTypes(), method.getDeclaringClass(), Modifier.isStatic(method.getModifiers()), method.isVarArgs());
    }

    public PyReflectedFunction copy() {
        PyReflectedFunction pyReflectedFunction = new PyReflectedFunction(this.__name__);
        pyReflectedFunction.__doc__ = this.__doc__;
        pyReflectedFunction.nargs = this.nargs;
        pyReflectedFunction.argslist = new ReflectedArgs[this.nargs];
        System.arraycopy(this.argslist, 0, pyReflectedFunction.argslist, 0, this.nargs);
        return pyReflectedFunction;
    }

    private PyReflectedFunction copyWithCalledStatically(boolean bl) {
        PyReflectedFunction pyReflectedFunction = this.copy();
        pyReflectedFunction.calledStatically = bl;
        return pyReflectedFunction;
    }

    public boolean handles(Method method) {
        return this.handles(this.makeArgs(method));
    }

    protected boolean handles(ReflectedArgs reflectedArgs) {
        for (int i = 0; i < this.nargs; ++i) {
            int n = reflectedArgs.compareTo(this.argslist[i]);
            if (n == 0) {
                return true;
            }
            if (n != 1) continue;
            return false;
        }
        return false;
    }

    public void addMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) && Options.respectJavaAccessibility) {
            return;
        }
        if (PyReflectedFunction.isPackagedProtected(method.getDeclaringClass())) {
            try {
                method.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        this.addArgs(this.makeArgs(method));
    }

    public static boolean isPackagedProtected(Class<?> clazz) {
        int n = clazz.getModifiers();
        return !Modifier.isPublic(n) && !Modifier.isPrivate(n) && !Modifier.isProtected(n);
    }

    protected void addArgs(ReflectedArgs reflectedArgs) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.nargs; ++n2) {
            n = reflectedArgs.compareTo(this.argslist[n2]);
            if (n == 0) {
                return;
            }
            if (n == 1998) {
                this.argslist[n2] = reflectedArgs;
                return;
            }
            if (n == -1) break;
        }
        if ((n = this.nargs + 1) > this.argslist.length) {
            ReflectedArgs[] reflectedArgsArray = new ReflectedArgs[n + 2];
            System.arraycopy(this.argslist, 0, reflectedArgsArray, 0, this.nargs);
            this.argslist = reflectedArgsArray;
        }
        for (int i = this.nargs; i > n2; --i) {
            this.argslist[i] = this.argslist[i - 1];
        }
        this.argslist[n2] = reflectedArgs;
        this.nargs = n;
    }

    @Override
    public PyObject __call__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        Object object;
        ReflectedCallData reflectedCallData = new ReflectedCallData();
        ReflectedArgs reflectedArgs = null;
        for (int i = 0; i < this.nargs && reflectedArgs == null; ++i) {
            if (!this.argslist[i].matches(pyObject, pyObjectArray, stringArray, reflectedCallData)) continue;
            reflectedArgs = this.argslist[i];
        }
        if (reflectedArgs == null) {
            this.throwError(reflectedCallData.errArg, pyObjectArray.length, pyObject != null, stringArray.length != 0);
        }
        Object object2 = reflectedCallData.self;
        Method method = (Method)reflectedArgs.data;
        if (pyObject == null && object2 != null && object2 instanceof PyProxy && !this.__name__.startsWith("super__") && reflectedArgs.declaringClass != object2.getClass()) {
            object = "super__" + this.__name__;
            try {
                method = object2.getClass().getMethod((String)object, method.getParameterTypes());
            }
            catch (Exception exception) {
                throw Py.JavaError(exception);
            }
        }
        try {
            object = method.invoke(object2, reflectedCallData.getArgsArray());
        }
        catch (Throwable throwable) {
            throw Py.JavaError(throwable);
        }
        return Py.java2py(object);
    }

    @Override
    public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject;
        if (this.calledStatically) {
            pyObject = null;
        } else {
            PyObject[] pyObjectArray2 = new PyObject[pyObjectArray.length - 1];
            System.arraycopy(pyObjectArray, 1, pyObjectArray2, 0, pyObjectArray2.length);
            pyObject = pyObjectArray[0];
            pyObjectArray = pyObjectArray2;
        }
        return this.__call__(pyObject, pyObjectArray, stringArray);
    }

    protected void throwError(String string) {
        throw Py.TypeError(this.__name__ + "(): " + string);
    }

    private static void addRange(StringBuilder stringBuilder, int n, int n2, String string) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(string);
        }
        if (n < n2) {
            stringBuilder.append(Integer.toString(n)).append('-').append(n2);
        } else {
            stringBuilder.append(n);
        }
    }

    protected void throwArgCountError(int n, boolean bl) {
        int n2;
        boolean[] blArray = new boolean[40];
        int n3 = -1;
        int n4 = 40;
        for (int i = 0; i < this.nargs; ++i) {
            ReflectedArgs reflectedArgs = this.argslist[i];
            n2 = reflectedArgs.args.length;
            if (!bl && !reflectedArgs.isStatic) {
                ++n2;
            }
            blArray[n2] = true;
            if (n2 > n3) {
                n3 = n2;
            }
            if (n2 >= n4) continue;
            n4 = n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = n4;
        n2 = n4 + 1;
        block1: while (n2 < n3) {
            if (blArray[n2]) {
                ++n2;
                continue;
            }
            PyReflectedFunction.addRange(stringBuilder, n5, n2 - 1, ", ");
            ++n2;
            while (n2 <= n3) {
                if (blArray[n2]) {
                    n5 = n2;
                    continue block1;
                }
                ++n2;
            }
        }
        PyReflectedFunction.addRange(stringBuilder, n5, n3, " or ");
        this.throwError("expected " + stringBuilder + " args; got " + n);
    }

    private static String ordinal(int n) {
        switch (n + 1) {
            case 0: {
                return "self";
            }
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return Integer.toString(n + 1) + "th";
    }

    private static String niceName(Class<?> clazz) {
        if (clazz == String.class || clazz == PyString.class) {
            return "String";
        }
        if (clazz.isArray()) {
            return PyReflectedFunction.niceName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    protected void throwBadArgError(int n, int n2, boolean bl) {
        Set<Class<?>> set = Generic.set();
        for (int i = 0; i < this.nargs; ++i) {
            if (this.argslist[i].args.length != n2 && (this.argslist[i].isStatic || bl || this.argslist[i].args.length != n2 - 1)) continue;
            if (n == -1) {
                set.add(this.argslist[i].declaringClass);
                continue;
            }
            set.add(this.argslist[i].args[n]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Class clazz : set) {
            stringBuilder.append(PyReflectedFunction.niceName(clazz));
            stringBuilder.append(", ");
        }
        if (stringBuilder.length() > 2) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        this.throwError(PyReflectedFunction.ordinal(n) + " arg can't be coerced to " + stringBuilder);
    }

    protected void throwError(int n, int n2, boolean bl, boolean bl2) {
        if (bl2) {
            this.throwError("takes no keyword arguments");
        } else if (n == -2) {
            this.throwArgCountError(n2, bl);
        } else {
            this.throwBadArgError(n, n2, bl);
        }
    }

    public void printArgs() {
        System.err.println("nargs: " + this.nargs);
        for (int i = 0; i < this.nargs; ++i) {
            ReflectedArgs reflectedArgs = this.argslist[i];
            System.err.println(reflectedArgs.toString());
        }
    }

    @Override
    public String toString() {
        return "<java function " + this.__name__ + " " + Py.idstr(this) + ">";
    }
}

