/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceIter;
import org.python.core.PySlice;
import org.python.core.PyType;
import org.python.core.SequenceIndexDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PySequence
extends PyObject {
    protected final SequenceIndexDelegate delegator = new SequenceIndexDelegate(){

        public String getTypeName() {
            return PySequence.this.getType().fastGetName();
        }

        public void setItem(int n, PyObject pyObject) {
            PySequence.this.pyset(n, pyObject);
        }

        public void setSlice(int n, int n2, int n3, PyObject pyObject) {
            PySequence.this.setslice(n, n2, n3, pyObject);
        }

        public int len() {
            return PySequence.this.__len__();
        }

        public void delItem(int n) {
            PySequence.this.del(n);
        }

        public void delItems(int n, int n2) {
            PySequence.this.delRange(n, n2);
        }

        public PyObject getItem(int n) {
            return PySequence.this.pyget(n);
        }

        public PyObject getSlice(int n, int n2, int n3) {
            return PySequence.this.getslice(n, n2, n3);
        }
    };

    protected PySequence(PyType pyType) {
        super(pyType);
    }

    protected abstract PyObject pyget(int var1);

    protected abstract PyObject getslice(int var1, int var2, int var3);

    protected abstract PyObject repeat(int var1);

    protected void pyset(int n, PyObject pyObject) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void setslice(int n, int n2, int n3, PyObject pyObject) {
        throw Py.TypeError(String.format("'%s' object does not support item assignment", this.getType().fastGetName()));
    }

    protected void del(int n) {
        throw Py.TypeError(String.format("'%s' object does not support item deletion", this.getType().fastGetName()));
    }

    protected void delRange(int n, int n2) {
        throw Py.TypeError(String.format("'%s' object does not support item deletion", this.getType().fastGetName()));
    }

    @Override
    public boolean __nonzero__() {
        return this.seq___nonzero__();
    }

    final boolean seq___nonzero__() {
        return this.__len__() != 0;
    }

    @Override
    public PyObject __iter__() {
        return this.seq___iter__();
    }

    final PyObject seq___iter__() {
        return new PySequenceIter(this);
    }

    @Override
    public PyObject __eq__(PyObject pyObject) {
        return this.seq___eq__(pyObject);
    }

    final PyObject seq___eq__(PyObject pyObject) {
        int n;
        if (!this.isSubType(pyObject)) {
            return null;
        }
        int n2 = this.__len__();
        if (n2 != (n = pyObject.__len__())) {
            return Py.False;
        }
        int n3 = PySequence.cmp(this, n2, pyObject, n);
        return n3 < 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __ne__(PyObject pyObject) {
        return this.seq___ne__(pyObject);
    }

    final PyObject seq___ne__(PyObject pyObject) {
        int n;
        if (!this.isSubType(pyObject)) {
            return null;
        }
        int n2 = this.__len__();
        if (n2 != (n = pyObject.__len__())) {
            return Py.True;
        }
        int n3 = PySequence.cmp(this, n2, pyObject, n);
        return n3 < 0 ? Py.False : Py.True;
    }

    @Override
    public PyObject __lt__(PyObject pyObject) {
        return this.seq___lt__(pyObject);
    }

    final PyObject seq___lt__(PyObject pyObject) {
        if (!this.isSubType(pyObject)) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -1 ? Py.True : Py.False;
        }
        return this.__finditem__(n)._lt(pyObject.__finditem__(n));
    }

    @Override
    public PyObject __le__(PyObject pyObject) {
        return this.seq___le__(pyObject);
    }

    final PyObject seq___le__(PyObject pyObject) {
        if (!this.isSubType(pyObject)) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -1 || n == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(n)._le(pyObject.__finditem__(n));
    }

    @Override
    public PyObject __gt__(PyObject pyObject) {
        return this.seq___gt__(pyObject);
    }

    final PyObject seq___gt__(PyObject pyObject) {
        if (!this.isSubType(pyObject)) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -3 ? Py.True : Py.False;
        }
        return this.__finditem__(n)._gt(pyObject.__finditem__(n));
    }

    @Override
    public PyObject __ge__(PyObject pyObject) {
        return this.seq___ge__(pyObject);
    }

    final PyObject seq___ge__(PyObject pyObject) {
        if (!this.isSubType(pyObject)) {
            return null;
        }
        int n = PySequence.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -3 || n == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(n)._ge(pyObject.__finditem__(n));
    }

    protected boolean isSubType(PyObject pyObject) {
        PyType pyType;
        PyType pyType2 = this.getType();
        return pyType2 == (pyType = pyObject.getType()) || pyType2.isSubType(pyType);
    }

    protected static int cmp(PyObject pyObject, int n, PyObject pyObject2, int n2) {
        if (n < 0) {
            n = pyObject.__len__();
        }
        if (n2 < 0) {
            n2 = pyObject2.__len__();
        }
        for (int i = 0; i < n && i < n2; ++i) {
            if (pyObject.__getitem__(i).equals(pyObject2.__getitem__(i))) continue;
            return i;
        }
        if (n == n2) {
            return -2;
        }
        return n < n2 ? -1 : -3;
    }

    protected static PySequence fastSequence(PyObject pyObject, String string) {
        if (pyObject instanceof PySequence) {
            return (PySequence)pyObject;
        }
        PyList pyList = new PyList();
        PyObject pyObject2 = Py.iter(pyObject, string);
        PyObject pyObject3 = null;
        while ((pyObject3 = pyObject2.__iternext__()) != null) {
            pyList.append(pyObject3);
        }
        return pyList;
    }

    protected static final int sliceLength(int n, int n2, long l) {
        int n3 = l > 0L ? (int)(((long)(n2 - n) + l - 1L) / l) : (int)(((long)(n2 - n) + l + 1L) / l);
        if (n3 < 0) {
            return 0;
        }
        return n3;
    }

    protected int boundToSequence(int n) {
        int n2 = this.__len__();
        if (n < 0) {
            if ((n += n2) < 0) {
                n = 0;
            }
        } else if (n > n2) {
            n = n2;
        }
        return n;
    }

    @Override
    public PyObject __finditem__(int n) {
        return this.seq___finditem__(n);
    }

    final PyObject seq___finditem__(int n) {
        return this.delegator.checkIdxAndFindItem(n);
    }

    @Override
    public PyObject __finditem__(PyObject pyObject) {
        return this.seq___finditem__(pyObject);
    }

    final PyObject seq___finditem__(PyObject pyObject) {
        return this.delegator.checkIdxAndFindItem(pyObject);
    }

    @Override
    public PyObject __getitem__(PyObject pyObject) {
        return this.seq___getitem__(pyObject);
    }

    final PyObject seq___getitem__(PyObject pyObject) {
        return this.delegator.checkIdxAndGetItem(pyObject);
    }

    @Override
    public boolean isMappingType() throws PyIgnoreMethodTag {
        return false;
    }

    @Override
    public boolean isNumberType() throws PyIgnoreMethodTag {
        return false;
    }

    @Override
    public PyObject __getslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return this.seq___getslice__(pyObject, pyObject2, pyObject3);
    }

    final PyObject seq___getslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return this.delegator.getSlice(new PySlice(pyObject, pyObject2, pyObject3));
    }

    @Override
    public void __setslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        this.seq___setslice__(pyObject, pyObject2, pyObject3, pyObject4);
    }

    final void seq___setslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3, PyObject pyObject4) {
        if (pyObject4 == null) {
            pyObject4 = pyObject3;
            pyObject3 = null;
        }
        this.delegator.checkIdxAndSetSlice(new PySlice(pyObject, pyObject2, pyObject3), pyObject4);
    }

    @Override
    public void __delslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        this.seq___delslice__(pyObject, pyObject2, pyObject3);
    }

    final void seq___delslice__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        this.delegator.checkIdxAndDelItem(new PySlice(pyObject, pyObject2, pyObject3));
    }

    @Override
    public void __setitem__(int n, PyObject pyObject) {
        this.delegator.checkIdxAndSetItem(n, pyObject);
    }

    @Override
    public void __setitem__(PyObject pyObject, PyObject pyObject2) {
        this.seq___setitem__(pyObject, pyObject2);
    }

    final void seq___setitem__(PyObject pyObject, PyObject pyObject2) {
        this.delegator.checkIdxAndSetItem(pyObject, pyObject2);
    }

    @Override
    public void __delitem__(PyObject pyObject) {
        this.seq___delitem__(pyObject);
    }

    final void seq___delitem__(PyObject pyObject) {
        this.delegator.checkIdxAndDelItem(pyObject);
    }

    @Override
    public synchronized Object __tojava__(Class<?> clazz) throws PyIgnoreMethodTag {
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            try {
                int n = this.__len__();
                PyArray pyArray = new PyArray(clazz2, n);
                for (int i = 0; i < n; ++i) {
                    PyObject pyObject = this.pyget(i);
                    pyArray.set(i, pyObject);
                }
                return pyArray.getArray();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__tojava__(clazz);
    }

    @Override
    protected String unsupportedopMessage(String string, PyObject pyObject) {
        if (string.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{2}''";
        }
        return null;
    }

    @Override
    protected String runsupportedopMessage(String string, PyObject pyObject) {
        if (string.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{1}''";
        }
        return null;
    }

    @Override
    public boolean isSequenceType() {
        return true;
    }
}

