/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import junit.framework.TestCase;
import org.python.core.PySystemState;
import org.python.posix.util.Platform;

public class PySystemStateTest
extends TestCase {
    public void testGetJarFileNameFromURL() throws Exception {
        PySystemStateTest.assertNull((Object)PySystemState.getJarFileNameFromURL(null));
        String string = "jar:file:/some_dir/some.jar!/a/package/with/A.class";
        URL uRL = new URL(string);
        PySystemStateTest.assertEquals((String)"/some_dir/some.jar", (String)PySystemState.getJarFileNameFromURL(uRL));
        string = "jar:file:/some%20dir/some.jar!/a/package/with/A.class";
        uRL = new URL(string);
        PySystemStateTest.assertEquals((String)"/some dir/some.jar", (String)PySystemState.getJarFileNameFromURL(uRL));
        string = "jar:file:/some+dir/some.jar!/a/package/with/A.class";
        uRL = new URL(string);
        PySystemStateTest.assertEquals((String)"/some+dir/some.jar", (String)PySystemState.getJarFileNameFromURL(uRL));
    }

    public void testGetJarFileNameFromURL_jboss() throws Exception {
        String string = "vfszip";
        String string2 = "";
        int n = -1;
        TestJBossURLStreamHandler testJBossURLStreamHandler = new TestJBossURLStreamHandler();
        if (Platform.IS_WINDOWS) {
            String string3 = "/C:/some_dir/some.jar/org/python/core/PySystemState.class";
            URL uRL = new URL("vfszip", "", -1, string3, testJBossURLStreamHandler);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/some_dir/some.jar/org/python/core/PySystemState.class", (String)uRL.toString());
            PySystemStateTest.assertEquals((String)"C:/some_dir/some.jar", (String)PySystemState.getJarFileNameFromURL(uRL));
            string3 = "/C:/some%20dir/some.jar/org/python/core/PySystemState.class";
            uRL = new URL("vfszip", "", -1, string3, testJBossURLStreamHandler);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/some%20dir/some.jar/org/python/core/PySystemState.class", (String)uRL.toString());
            PySystemStateTest.assertEquals((String)"C:/some dir/some.jar", (String)PySystemState.getJarFileNameFromURL(uRL));
            string3 = "/C:/some+dir/some.jar/org/python/core/PySystemState.class";
            uRL = new URL("vfszip", "", -1, string3, testJBossURLStreamHandler);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/some+dir/some.jar/org/python/core/PySystemState.class", (String)uRL.toString());
            PySystemStateTest.assertEquals((String)"C:/some+dir/some.jar", (String)PySystemState.getJarFileNameFromURL(uRL));
        } else {
            String string4 = "/some_dir/some.jar/org/python/core/PySystemState.class";
            URL uRL = new URL("vfszip", "", -1, string4, testJBossURLStreamHandler);
            PySystemStateTest.assertEquals((String)"vfszip:/some_dir/some.jar/org/python/core/PySystemState.class", (String)uRL.toString());
            PySystemStateTest.assertEquals((String)"/some_dir/some.jar", (String)PySystemState.getJarFileNameFromURL(uRL));
            string4 = "/some%20dir/some.jar/org/python/core/PySystemState.class";
            uRL = new URL("vfszip", "", -1, string4, testJBossURLStreamHandler);
            PySystemStateTest.assertEquals((String)"vfszip:/some%20dir/some.jar/org/python/core/PySystemState.class", (String)uRL.toString());
            PySystemStateTest.assertEquals((String)"/some dir/some.jar", (String)PySystemState.getJarFileNameFromURL(uRL));
            string4 = "/some+dir/some.jar/org/python/core/PySystemState.class";
            uRL = new URL("vfszip", "", -1, string4, testJBossURLStreamHandler);
            PySystemStateTest.assertEquals((String)"vfszip:/some+dir/some.jar/org/python/core/PySystemState.class", (String)uRL.toString());
            PySystemStateTest.assertEquals((String)"/some+dir/some.jar", (String)PySystemState.getJarFileNameFromURL(uRL));
        }
    }

    protected static class TestJBossURLStreamHandler
    extends URLStreamHandler {
        protected TestJBossURLStreamHandler() {
        }

        protected URLConnection openConnection(URL uRL) throws IOException {
            throw new RuntimeException("unexpected call to openConnection " + uRL.toString());
        }
    }
}

