/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.ReflectedCallData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectedArgs {
    public Class<?>[] args;
    public Object data;
    public Class<?> declaringClass;
    public boolean isStatic;
    public boolean isVarArgs;
    public int flags;
    public static final int StandardCall = 0;
    public static final int PyArgsCall = 1;
    public static final int PyArgsKeywordsCall = 2;
    public static final int REPLACE = 1998;

    public ReflectedArgs(Object object, Class<?>[] classArray, Class<?> clazz, boolean bl) {
        this(object, classArray, clazz, bl, false);
    }

    public ReflectedArgs(Object object, Class<?>[] classArray, Class<?> clazz, boolean bl, boolean bl2) {
        this.data = object;
        this.args = classArray;
        this.declaringClass = clazz;
        this.isStatic = bl;
        this.isVarArgs = bl2;
        this.flags = classArray.length == 1 && classArray[0] == PyObject[].class ? 1 : (classArray.length == 2 && classArray[0] == PyObject[].class && classArray[1] == String[].class ? 2 : 0);
    }

    public boolean matches(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray, ReflectedCallData reflectedCallData) {
        PyObject[] pyObjectArray2;
        int n;
        Object object;
        if (this.flags != 2 && stringArray != null && stringArray.length != 0) {
            return false;
        }
        if (this.isStatic) {
            if (pyObject != null) {
                pyObject = null;
            }
        } else if (pyObject == null) {
            if (pyObjectArray.length == 0) {
                return false;
            }
            pyObject = pyObjectArray[0];
            object = new PyObject[pyObjectArray.length - 1];
            System.arraycopy(pyObjectArray, 1, object, 0, ((PyObject[])object).length);
            pyObjectArray = object;
        }
        if (this.flags == 2) {
            reflectedCallData.setLength(2);
            reflectedCallData.args[0] = pyObjectArray;
            reflectedCallData.args[1] = stringArray;
            reflectedCallData.self = pyObject;
            if (pyObject != null && (object = pyObject.__tojava__(this.declaringClass)) != Py.NoConversion) {
                reflectedCallData.self = object;
            }
            return true;
        }
        if (this.flags == 1) {
            reflectedCallData.setLength(1);
            reflectedCallData.args[0] = pyObjectArray;
            reflectedCallData.self = pyObject;
            if (pyObject != null && (object = pyObject.__tojava__(this.declaringClass)) != Py.NoConversion) {
                reflectedCallData.self = object;
            }
            return true;
        }
        int n2 = this.args.length;
        if (this.isVarArgs && (pyObjectArray.length == 0 || !(pyObjectArray[pyObjectArray.length - 1] instanceof PySequenceList)) && pyObjectArray.length >= (n = n2 - 1)) {
            int n3;
            PyObject[] pyObjectArray3 = new PyObject[n2];
            for (n3 = 0; n3 < n; ++n3) {
                pyObjectArray3[n3] = pyObjectArray[n3];
            }
            n3 = pyObjectArray.length - n;
            pyObjectArray2 = new PyObject[n3];
            for (int i = 0; i < n3; ++i) {
                pyObjectArray2[i] = pyObjectArray[n + i];
            }
            pyObjectArray3[n] = new PyList(pyObjectArray2);
            pyObjectArray = pyObjectArray3;
        }
        if (pyObjectArray.length != n2) {
            return false;
        }
        reflectedCallData.errArg = -1;
        if (pyObject != null) {
            Object object2 = pyObject.__tojava__(this.declaringClass);
            if (object2 == Py.NoConversion) {
                return false;
            }
            reflectedCallData.self = object2;
        } else {
            reflectedCallData.self = null;
        }
        reflectedCallData.setLength(n2);
        Object[] objectArray = reflectedCallData.args;
        for (int i = 0; i < n2; ++i) {
            Object object3;
            PyObject pyObject2 = pyObjectArray[i];
            pyObjectArray2 = this.args[i];
            objectArray[i] = object3 = pyObject2.__tojava__((Class<?>)pyObjectArray2);
            if (object3 != Py.NoConversion) continue;
            if (i > reflectedCallData.errArg) {
                reflectedCallData.errArg = i;
            }
            return false;
        }
        return true;
    }

    public static int precedence(Class<?> clazz) {
        if (clazz == Object.class) {
            return 3000;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Long.TYPE) {
                return 10;
            }
            if (clazz == Integer.TYPE) {
                return 11;
            }
            if (clazz == Short.TYPE) {
                return 12;
            }
            if (clazz == Character.TYPE) {
                return 13;
            }
            if (clazz == Byte.TYPE) {
                return 14;
            }
            if (clazz == Double.TYPE) {
                return 20;
            }
            if (clazz == Float.TYPE) {
                return 21;
            }
            if (clazz == Boolean.TYPE) {
                return 30;
            }
        }
        if (clazz == String.class) {
            return 40;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2 == Object.class) {
                return 2500;
            }
            return 100 + ReflectedArgs.precedence(clazz2);
        }
        return 2000;
    }

    public static int compare(Class<?> clazz, Class<?> clazz2) {
        int n = ReflectedArgs.precedence(clazz);
        int n2 = ReflectedArgs.precedence(clazz2);
        if (n >= 2000 && n2 >= 2000) {
            if (clazz.isAssignableFrom(clazz2)) {
                if (clazz2.isAssignableFrom(clazz)) {
                    return 0;
                }
                return 2;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return -2;
            }
            int n3 = clazz.getName().compareTo(clazz2.getName());
            return n3 > 0 ? 1 : -1;
        }
        return n > n2 ? 2 : (n == n2 ? 0 : -2);
    }

    public int compareTo(ReflectedArgs reflectedArgs) {
        int n;
        Class<?>[] classArray = reflectedArgs.args;
        if (reflectedArgs.flags != this.flags) {
            return reflectedArgs.flags < this.flags ? -1 : 1;
        }
        int n2 = this.args.length;
        if (n2 < classArray.length) {
            return -1;
        }
        if (n2 > classArray.length) {
            return 1;
        }
        if (this.isStatic && !reflectedArgs.isStatic) {
            return 1;
        }
        if (!this.isStatic && reflectedArgs.isStatic) {
            return -1;
        }
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4 = ReflectedArgs.compare(this.args[n], classArray[n]);
            if (n4 == 2 || n4 == -2) {
                n3 = n4;
            }
            if (n3 != 0) continue;
            n3 = n4;
        }
        if (n3 != 0) {
            return n3 > 0 ? 1 : -1;
        }
        n = reflectedArgs.declaringClass.isAssignableFrom(this.declaringClass) ? 1 : 0;
        if (!this.isStatic) {
            n = n == 0 ? 1 : 0;
        }
        return n != 0 ? 1998 : 0;
    }

    public String toString() {
        String string = this.declaringClass + ", static=" + this.isStatic + ", varargs=" + this.isVarArgs + ",flags=" + this.flags + ", " + this.data + "\n";
        string = string + "\t(";
        for (Class<?> clazz : this.args) {
            string = string + clazz.getName() + ", ";
        }
        string = string + ")";
        return string;
    }
}

