/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySlice;

public abstract class SequenceIndexDelegate
implements Serializable {
    public abstract int len();

    public abstract PyObject getItem(int var1);

    public abstract void setItem(int var1, PyObject var2);

    public abstract void delItem(int var1);

    public abstract PyObject getSlice(int var1, int var2, int var3);

    public abstract void setSlice(int var1, int var2, int var3, PyObject var4);

    public abstract void delItems(int var1, int var2);

    public abstract String getTypeName();

    public void checkIdxAndSetItem(PyObject pyObject, PyObject pyObject2) {
        if (pyObject.isIndex()) {
            this.checkIdxAndSetItem(pyObject.asIndex(Py.IndexError), pyObject2);
        } else if (pyObject instanceof PySlice) {
            this.checkIdxAndSetSlice((PySlice)pyObject, pyObject2);
        } else {
            throw Py.TypeError(this.getTypeName() + " indices must be integers");
        }
    }

    public void checkIdxAndSetSlice(PySlice pySlice, PyObject pyObject) {
        int[] nArray = pySlice.indicesEx(this.len());
        if (pySlice.step != Py.None && pyObject.__len__() != nArray[3]) {
            throw Py.ValueError(String.format("attempt to assign sequence of size %d to extended slice of size %d", pyObject.__len__(), nArray[3]));
        }
        this.setSlice(nArray[0], nArray[1], nArray[2], pyObject);
    }

    public void checkIdxAndSetItem(int n, PyObject pyObject) {
        this.setItem(this.checkIdx(n), pyObject);
    }

    public void checkIdxAndDelItem(PyObject pyObject) {
        if (pyObject.isIndex()) {
            this.delItem(this.checkIdx(pyObject.asIndex(Py.IndexError)));
        } else if (pyObject instanceof PySlice) {
            int[] nArray = ((PySlice)pyObject).indicesEx(this.len());
            this.delSlice(nArray[0], nArray[1], nArray[2]);
        } else {
            throw Py.TypeError(this.getTypeName() + " indices must be integers");
        }
    }

    public PyObject checkIdxAndGetItem(PyObject pyObject) {
        PyObject pyObject2 = this.checkIdxAndFindItem(pyObject);
        if (pyObject2 == null) {
            throw Py.IndexError("index out of range: " + pyObject);
        }
        return pyObject2;
    }

    public PyObject checkIdxAndFindItem(PyObject pyObject) {
        if (pyObject.isIndex()) {
            return this.checkIdxAndFindItem(pyObject.asIndex(Py.IndexError));
        }
        if (pyObject instanceof PySlice) {
            return this.getSlice((PySlice)pyObject);
        }
        throw Py.TypeError(this.getTypeName() + " indices must be integers");
    }

    public PyObject getSlice(PySlice pySlice) {
        int[] nArray = pySlice.indicesEx(this.len());
        return this.getSlice(nArray[0], nArray[1], nArray[2]);
    }

    public PyObject checkIdxAndFindItem(int n) {
        if ((n = this.fixindex(n)) == -1) {
            return null;
        }
        return this.getItem(n);
    }

    private int checkIdx(int n) {
        int n2 = this.fixindex(n);
        if (n2 == -1) {
            throw Py.IndexError(this.getTypeName() + " assignment index out of range");
        }
        return n2;
    }

    int fixindex(int n) {
        int n2 = this.len();
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            return -1;
        }
        return n;
    }

    private void delSlice(int n, int n2, int n3) {
        block6: {
            block5: {
                if (n3 != 1) break block5;
                if (n2 <= n) break block6;
                this.delItems(n, n2);
                break block6;
            }
            if (n3 > 1) {
                for (int i = n; i < n2; --n2, i += n3) {
                    this.delItem(i);
                    --i;
                }
            } else if (n3 < 0) {
                for (int i = n; i >= 0 && i >= n2; i += n3) {
                    this.delItem(i);
                }
            }
        }
    }
}

