/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.adapter;

import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaType;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.adapter.ClassAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.adapter.PyObjectAdapter;

public class ClassicPyObjectAdapter
extends ExtensiblePyObjectAdapter {
    public ClassicPyObjectAdapter() {
        this.addPreClass(new PyObjectAdapter(){

            public PyObject adapt(Object object) {
                return (PyObject)object;
            }

            public boolean canAdapt(Object object) {
                return object instanceof PyObject;
            }
        });
        this.addPreClass(new PyObjectAdapter(){

            public PyObject adapt(Object object) {
                return ((PyProxy)object)._getPyInstance();
            }

            public boolean canAdapt(Object object) {
                return object instanceof PyProxy;
            }
        });
        this.addPreClass(new PyObjectAdapter(){

            public boolean canAdapt(Object object) {
                return object == null;
            }

            public PyObject adapt(Object object) {
                return Py.None;
            }
        });
        this.add(new ClassAdapter(String.class){

            public PyObject adapt(Object object) {
                return new PyUnicode((String)object);
            }
        });
        this.add(new ClassAdapter(Character.class){

            public PyObject adapt(Object object) {
                return Py.makeCharacter((Character)object);
            }
        });
        this.add(new ClassAdapter(Class.class){

            public PyObject adapt(Object object) {
                return PyType.fromClass((Class)object, false);
            }
        });
        this.add(new NumberToPyFloat(Double.class));
        this.add(new NumberToPyFloat(Float.class));
        this.add(new NumberToPyInteger(Integer.class));
        this.add(new NumberToPyInteger(Byte.class));
        this.add(new NumberToPyInteger(Short.class));
        this.add(new ClassAdapter(Long.class){

            public PyObject adapt(Object object) {
                return new PyLong(((Number)object).longValue());
            }
        });
        this.add(new ClassAdapter(Boolean.class){

            public PyObject adapt(Object object) {
                return (Boolean)object != false ? Py.True : Py.False;
            }
        });
        this.addPostClass(new PyObjectAdapter(){

            public PyObject adapt(Object object) {
                return new PyArray(object.getClass().getComponentType(), object);
            }

            public boolean canAdapt(Object object) {
                return object.getClass().isArray();
            }
        });
    }

    public boolean canAdapt(Object object) {
        return true;
    }

    public PyObject adapt(Object object) {
        PyObject pyObject = super.adapt(object);
        if (pyObject != null) {
            return pyObject;
        }
        return PyJavaType.wrapJavaObject(object);
    }

    private static class NumberToPyFloat
    extends ClassAdapter {
        public NumberToPyFloat(Class clazz) {
            super(clazz);
        }

        public PyObject adapt(Object object) {
            return new PyFloat(((Number)object).doubleValue());
        }
    }

    private static class NumberToPyInteger
    extends ClassAdapter {
        public NumberToPyInteger(Class clazz) {
            super(clazz);
        }

        public PyObject adapt(Object object) {
            return new PyInteger(((Number)object).intValue());
        }
    }
}

