/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.lang.reflect.Method;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBaseException;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyFrame;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.ThreadState;
import org.python.modules.zipimport.zipimport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class exceptions
extends PyObject
implements ClassDictInit {
    public static String __doc__ = "Python's standard exception class hierarchy.\n\nExceptions found here are defined both in the exceptions module and the\nbuilt-in namespace.  It is recommended that user-defined exceptions\ninherit from Exception.  See the documentation for the exception\ninheritance hierarchy.\n";

    public static void classDictInit(PyObject pyObject) {
        pyObject.invoke("clear");
        pyObject.__setitem__("__name__", (PyObject)new PyString("exceptions"));
        pyObject.__setitem__("__doc__", (PyObject)new PyString(__doc__));
        ThreadState threadState = Py.getThreadState();
        if (threadState.systemState == null) {
            threadState.systemState = Py.defaultSystemState;
        }
        PyFrame pyFrame = new PyFrame(null, new PyStringMap());
        pyFrame.f_back = threadState.frame;
        if (pyFrame.f_builtins == null) {
            pyFrame.f_builtins = pyFrame.f_back != null ? pyFrame.f_back.f_builtins : PySystemState.getDefaultBuiltins();
        }
        threadState.frame = pyFrame;
        pyObject.__setitem__("BaseException", (PyObject)PyBaseException.TYPE);
        exceptions.buildClass(pyObject, "KeyboardInterrupt", "BaseException", "Program interrupted by user.");
        exceptions.buildClass(pyObject, "SystemExit", "BaseException", exceptions.SystemExit(), "Request to exit from the interpreter.");
        exceptions.buildClass(pyObject, "Exception", "BaseException", "Common base class for all non-exit exceptions.");
        exceptions.buildClass(pyObject, "StandardError", "Exception", "Base class for all standard Python exceptions that do not represent\ninterpreter exiting.");
        exceptions.buildClass(pyObject, "SyntaxError", "StandardError", exceptions.SyntaxError(), "Invalid syntax.");
        exceptions.buildClass(pyObject, "IndentationError", "SyntaxError", "Improper indentation.");
        exceptions.buildClass(pyObject, "TabError", "IndentationError", "Improper mixture of spaces and tabs.");
        exceptions.buildClass(pyObject, "EnvironmentError", "StandardError", exceptions.EnvironmentError(), "Base class for I/O related errors.");
        exceptions.buildClass(pyObject, "IOError", "EnvironmentError", "I/O operation failed.");
        exceptions.buildClass(pyObject, "OSError", "EnvironmentError", "OS system call failed.");
        exceptions.buildClass(pyObject, "RuntimeError", "StandardError", "Unspecified run-time error.");
        exceptions.buildClass(pyObject, "NotImplementedError", "RuntimeError", "Method or function hasn't been implemented yet.");
        exceptions.buildClass(pyObject, "SystemError", "StandardError", "Internal error in the Python interpreter.\n\nPlease report this to the Python maintainer, along with the traceback,\nthe Python version, and the hardware/OS platform and version.");
        exceptions.buildClass(pyObject, "ReferenceError", "StandardError", "Weak ref proxy used after referent went away.");
        exceptions.buildClass(pyObject, "EOFError", "StandardError", "Read beyond end of file.");
        exceptions.buildClass(pyObject, "ImportError", "StandardError", "Import can't find module, or can't find name in module.");
        exceptions.buildClass(pyObject, "TypeError", "StandardError", "Inappropriate argument type.");
        exceptions.buildClass(pyObject, "ValueError", "StandardError", "Inappropriate argument value (of correct type).");
        exceptions.buildClass(pyObject, "UnicodeError", "ValueError", "Unicode related error.");
        exceptions.buildClass(pyObject, "UnicodeEncodeError", "UnicodeError", exceptions.UnicodeEncodeError(), "Unicode encoding error.");
        exceptions.buildClass(pyObject, "UnicodeDecodeError", "UnicodeError", exceptions.UnicodeDecodeError(), "Unicode decoding error.");
        exceptions.buildClass(pyObject, "UnicodeTranslateError", "UnicodeError", exceptions.UnicodeTranslateError(), "Unicode translation error.");
        exceptions.buildClass(pyObject, "AssertionError", "StandardError", "Assertion failed.");
        exceptions.buildClass(pyObject, "ArithmeticError", "StandardError", "Base class for arithmetic errors.");
        exceptions.buildClass(pyObject, "OverflowError", "ArithmeticError", "Result too large to be represented.");
        exceptions.buildClass(pyObject, "FloatingPointError", "ArithmeticError", "Floating point operation failed.");
        exceptions.buildClass(pyObject, "ZeroDivisionError", "ArithmeticError", "Second argument to a division or modulo operation was zero.");
        exceptions.buildClass(pyObject, "LookupError", "StandardError", "Base class for lookup errors.");
        exceptions.buildClass(pyObject, "IndexError", "LookupError", "Sequence index out of range.");
        exceptions.buildClass(pyObject, "KeyError", "LookupError", exceptions.KeyError(), "Mapping key not found.");
        exceptions.buildClass(pyObject, "AttributeError", "StandardError", "Attribute not found.");
        exceptions.buildClass(pyObject, "NameError", "StandardError", "Name not found globally.");
        exceptions.buildClass(pyObject, "UnboundLocalError", "NameError", "Local name referenced but not bound to a value.");
        exceptions.buildClass(pyObject, "MemoryError", "StandardError", "Out of memory.");
        exceptions.buildClass(pyObject, "StopIteration", "Exception", "Signal the end from iterator.next().");
        exceptions.buildClass(pyObject, "GeneratorExit", "Exception", "Request that a generator exit.");
        exceptions.buildClass(pyObject, "Warning", "Exception", "Base class for warning categories.");
        exceptions.buildClass(pyObject, "UserWarning", "Warning", "Base class for warnings generated by user code.");
        exceptions.buildClass(pyObject, "DeprecationWarning", "Warning", "Base class for warnings about deprecated features.");
        exceptions.buildClass(pyObject, "PendingDeprecationWarning", "Warning", "Base class for warnings about features which will be deprecated\nin the future.");
        exceptions.buildClass(pyObject, "SyntaxWarning", "Warning", "Base class for warnings about dubious syntax.");
        exceptions.buildClass(pyObject, "RuntimeWarning", "Warning", "Base class for warnings about dubious runtime behavior.");
        exceptions.buildClass(pyObject, "FutureWarning", "Warning", "Base class for warnings about constructs that will change semantically\nin the future.");
        exceptions.buildClass(pyObject, "ImportWarning", "Warning", "Base class for warnings about probable mistakes in module imports");
        exceptions.buildClass(pyObject, "UnicodeWarning", "Warning", "Base class for warnings about Unicode related problems, mostly\nrelated to conversion problems.");
        zipimport.initClassExceptions(pyObject);
        threadState.frame = threadState.frame.f_back;
    }

    public static PyObject SyntaxError() {
        PyStringMap pyStringMap = new PyStringMap();
        exceptions.defineSlots(pyStringMap, "msg", "filename", "lineno", "offset", "text", "print_file_and_line");
        ((PyObject)pyStringMap).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "SyntaxError__init__"));
        ((PyObject)pyStringMap).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "SyntaxError__str__"));
        return pyStringMap;
    }

    public static void SyntaxError__init__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyBaseException.TYPE.invoke("__init__", pyObject, pyObjectArray, stringArray);
        exceptions.initSlots(pyObject);
        if (pyObjectArray.length >= 1) {
            pyObject.__setattr__("msg", pyObjectArray[0]);
        }
        if (pyObjectArray.length == 2) {
            PyObject[] pyObjectArray2 = Py.make_array(pyObjectArray[1]);
            if (pyObjectArray2.length != 4) {
                throw Py.IndexError("tuple index out of range");
            }
            pyObject.__setattr__("filename", pyObjectArray2[0]);
            pyObject.__setattr__("lineno", pyObjectArray2[1]);
            pyObject.__setattr__("offset", pyObjectArray2[2]);
            pyObject.__setattr__("text", pyObjectArray2[3]);
        }
    }

    public static PyString SyntaxError__str__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyObject pyObject2 = pyObject.__getattr__("msg");
        PyString pyString = pyObject2.__str__();
        if (!(pyObject2 instanceof PyString)) {
            return Py.newString(((PyObject)pyString).toString());
        }
        PyObject pyObject3 = pyObject.__findattr__("filename");
        PyObject pyObject4 = pyObject.__findattr__("lineno");
        boolean bl = pyObject3 instanceof PyString;
        boolean bl2 = pyObject4 instanceof PyInteger;
        if (!bl && !bl2) {
            return pyString;
        }
        String string = bl && bl2 ? String.format("%s (%s, line %d)", pyString, exceptions.basename(pyObject3.toString()), pyObject4.asInt()) : (bl ? String.format("%s (%s)", pyString, exceptions.basename(pyObject3.toString())) : String.format("%s (line %d)", pyString, pyObject4.asInt()));
        return Py.newString(string);
    }

    public static PyObject EnvironmentError() {
        PyStringMap pyStringMap = new PyStringMap();
        exceptions.defineSlots(pyStringMap, "errno", "strerror", "filename");
        ((PyObject)pyStringMap).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "EnvironmentError__init__"));
        ((PyObject)pyStringMap).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "EnvironmentError__str__"));
        ((PyObject)pyStringMap).__setitem__("__reduce__", exceptions.bindStaticJavaMethod("__reduce__", "EnvironmentError__reduce__"));
        return pyStringMap;
    }

    public static void EnvironmentError__init__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyBaseException.TYPE.invoke("__init__", pyObject, pyObjectArray, stringArray);
        exceptions.initSlots(pyObject);
        if (pyObjectArray.length <= 1 || pyObjectArray.length > 3) {
            return;
        }
        PyObject pyObject2 = pyObjectArray[0];
        PyObject pyObject3 = pyObjectArray[1];
        pyObject.__setattr__("errno", pyObject2);
        pyObject.__setattr__("strerror", pyObject3);
        if (pyObjectArray.length == 3) {
            pyObject.__setattr__("filename", pyObjectArray[2]);
            pyObject.__setattr__("args", (PyObject)new PyTuple(pyObject2, pyObject3));
        }
    }

    public static PyObject EnvironmentError__str__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        String string;
        PyObject pyObject2 = pyObject.__findattr__("errno");
        PyObject pyObject3 = pyObject.__findattr__("strerror");
        PyObject pyObject4 = pyObject.__findattr__("filename");
        if (pyObject4.__nonzero__()) {
            string = String.format("[Errno %s] %s: %s", pyObject2, pyObject3, pyObject4.__repr__());
        } else if (pyObject2.__nonzero__() && pyObject3.__nonzero__()) {
            string = String.format("[Errno %s] %s", pyObject2, pyObject3);
        } else {
            return PyBaseException.TYPE.invoke("__str__", pyObject, pyObjectArray, stringArray);
        }
        return Py.newString(string);
    }

    public static PyObject EnvironmentError__reduce__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyBaseException pyBaseException = (PyBaseException)pyObject;
        PyObject pyObject2 = pyBaseException.args;
        PyObject pyObject3 = pyObject.__findattr__("filename");
        if (pyBaseException.args.__len__() == 2 && pyObject3 != null) {
            pyObject2 = new PyTuple(pyBaseException.args.__finditem__(0), pyBaseException.args.__finditem__(1), pyObject3);
        }
        if (pyBaseException.__dict__ != null) {
            return new PyTuple(pyBaseException.getType(), pyObject2, pyBaseException.__dict__);
        }
        return new PyTuple(pyBaseException.getType(), pyObject2);
    }

    public static PyObject SystemExit() {
        PyStringMap pyStringMap = new PyStringMap();
        exceptions.defineSlots(pyStringMap, "code");
        ((PyObject)pyStringMap).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "SystemExit__init__"));
        return pyStringMap;
    }

    public static void SystemExit__init__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyBaseException.TYPE.invoke("__init__", pyObject, pyObjectArray, stringArray);
        exceptions.initSlots(pyObject);
        if (pyObjectArray.length == 1) {
            pyObject.__setattr__("code", pyObjectArray[0]);
        } else if (pyObjectArray.length > 1) {
            pyObject.__setattr__("code", (PyObject)new PyTuple(pyObjectArray));
        }
    }

    public static PyObject KeyError() {
        PyStringMap pyStringMap = new PyStringMap();
        ((PyObject)pyStringMap).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "KeyError__str__"));
        return pyStringMap;
    }

    public static PyObject KeyError__str__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyBaseException pyBaseException = (PyBaseException)pyObject;
        if (pyBaseException.args.__len__() == 1) {
            return pyBaseException.args.__getitem__(0).__repr__();
        }
        return PyBaseException.TYPE.invoke("__str__", pyObject, pyObjectArray, stringArray);
    }

    public static PyObject UnicodeError() {
        PyStringMap pyStringMap = new PyStringMap();
        exceptions.defineSlots(pyStringMap, "encoding", "object", "start", "end", "reason");
        return pyStringMap;
    }

    public static void UnicodeError__init__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray, PyType pyType) {
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, new String[]{"encoding", "object", "start", "end", "reason"}, 5);
        pyObject.__setattr__("encoding", argParser.getPyObjectByType(0, PyString.TYPE));
        pyObject.__setattr__("object", argParser.getPyObjectByType(1, pyType));
        pyObject.__setattr__("start", argParser.getPyObjectByType(2, PyInteger.TYPE));
        pyObject.__setattr__("end", argParser.getPyObjectByType(3, PyInteger.TYPE));
        pyObject.__setattr__("reason", argParser.getPyObjectByType(4, PyString.TYPE));
    }

    public static PyObject UnicodeDecodeError() {
        PyStringMap pyStringMap = new PyStringMap();
        ((PyObject)pyStringMap).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "UnicodeDecodeError__init__"));
        ((PyObject)pyStringMap).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "UnicodeDecodeError__str__"));
        return pyStringMap;
    }

    public static void UnicodeDecodeError__init__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyBaseException.TYPE.invoke("__init__", pyObject, pyObjectArray, stringArray);
        exceptions.UnicodeError__init__(pyObject, pyObjectArray, stringArray, PyString.TYPE);
    }

    public static PyString UnicodeDecodeError__str__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        String string;
        int n = exceptions.getStart(pyObject, false);
        int n2 = exceptions.getEnd(pyObject, false);
        PyObject pyObject2 = pyObject.__getattr__("encoding");
        PyObject pyObject3 = pyObject.__getattr__("reason");
        if (n2 == n + 1) {
            PyObject pyObject4 = pyObject.__getattr__("object");
            int n3 = pyObject4.toString().charAt(n) & 0xFF;
            string = String.format("'%.400s' codec can't decode byte 0x%x in position %d: %.400s", pyObject2, n3, n, pyObject3);
        } else {
            string = String.format("'%.400s' codec can't decode bytes in position %d-%d: %.400s", pyObject2, n, n2 - 1, pyObject3);
        }
        return Py.newString(string);
    }

    public static PyObject UnicodeEncodeError() {
        PyStringMap pyStringMap = new PyStringMap();
        ((PyObject)pyStringMap).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "UnicodeEncodeError__init__"));
        ((PyObject)pyStringMap).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "UnicodeEncodeError__str__"));
        return pyStringMap;
    }

    public static void UnicodeEncodeError__init__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyBaseException.TYPE.invoke("__init__", pyObject, pyObjectArray, stringArray);
        exceptions.UnicodeError__init__(pyObject, pyObjectArray, stringArray, PyUnicode.TYPE);
    }

    public static PyString UnicodeEncodeError__str__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        String string;
        int n = exceptions.getStart(pyObject, true);
        int n2 = exceptions.getEnd(pyObject, true);
        PyObject pyObject2 = pyObject.__getattr__("encoding");
        PyObject pyObject3 = pyObject.__getattr__("reason");
        if (n2 == n + 1) {
            PyObject pyObject4 = pyObject.__getattr__("object");
            int n3 = pyObject4.toString().codePointAt(n);
            String string2 = n3 <= 255 ? String.format("x%02x", n3) : (n3 <= 65535 ? String.format("u%04x", n3) : String.format("U%08x", n3));
            string = String.format("'%.400s' codec can't encode character u'\\%s' in position %d: %.400s", pyObject2, string2, n, pyObject3);
        } else {
            string = String.format("'%.400s' codec can't encode characters in position %d-%d: %.400s", pyObject2, n, n2 - 1, pyObject3);
        }
        return Py.newString(string);
    }

    public static PyObject UnicodeTranslateError() {
        PyStringMap pyStringMap = new PyStringMap();
        ((PyObject)pyStringMap).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "UnicodeTranslateError__init__"));
        ((PyObject)pyStringMap).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "UnicodeTranslateError__str__"));
        return pyStringMap;
    }

    public static void UnicodeTranslateError__init__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        PyBaseException.TYPE.invoke("__init__", pyObject, pyObjectArray, stringArray);
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, new String[]{"object", "start", "end", "reason"}, 4);
        pyObject.__setattr__("object", argParser.getPyObjectByType(0, PyUnicode.TYPE));
        pyObject.__setattr__("start", argParser.getPyObjectByType(1, PyInteger.TYPE));
        pyObject.__setattr__("end", argParser.getPyObjectByType(2, PyInteger.TYPE));
        pyObject.__setattr__("reason", argParser.getPyObjectByType(3, PyString.TYPE));
    }

    public static PyString UnicodeTranslateError__str__(PyObject pyObject, PyObject[] pyObjectArray, String[] stringArray) {
        String string;
        int n = exceptions.getStart(pyObject, true);
        int n2 = exceptions.getEnd(pyObject, true);
        PyObject pyObject2 = pyObject.__getattr__("reason");
        if (n2 == n + 1) {
            int n3 = pyObject.__getattr__("object").toString().codePointAt(n);
            String string2 = n3 <= 255 ? String.format("x%02x", n3) : (n3 <= 65535 ? String.format("u%04x", n3) : String.format("U%08x", n3));
            string = String.format("can't translate character u'\\%s' in position %d: %.400s", string2, n, pyObject2);
        } else {
            string = String.format("can't translate characters in position %d-%d: %.400s", n, n2 - 1, pyObject2);
        }
        return Py.newString(string);
    }

    public static int getStart(PyObject pyObject, boolean bl) {
        int n = exceptions.getInt(pyObject.__getattr__("start"), "start");
        PyString pyString = bl ? exceptions.getUnicode(pyObject.__getattr__("object"), "object") : exceptions.getString(pyObject.__getattr__("object"), "object");
        if (n < 0) {
            n = 0;
        }
        if (n >= ((PyObject)pyString).__len__()) {
            n = ((PyObject)pyString).__len__() - 1;
        }
        return n;
    }

    public static int getEnd(PyObject pyObject, boolean bl) {
        int n = exceptions.getInt(pyObject.__getattr__("end"), "end");
        PyString pyString = bl ? exceptions.getUnicode(pyObject.__getattr__("object"), "object") : exceptions.getString(pyObject.__getattr__("object"), "object");
        if (n < 1) {
            n = 1;
        }
        if (n > ((PyObject)pyString).__len__()) {
            n = ((PyObject)pyString).__len__();
        }
        return n;
    }

    public static int getInt(PyObject pyObject, String string) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).asInt();
        }
        if (pyObject instanceof PyLong) {
            return ((PyLong)pyObject).asInt();
        }
        throw Py.TypeError(String.format("%.200s attribute must be int", string));
    }

    public static PyString getString(PyObject pyObject, String string) {
        if (!(pyObject instanceof PyString)) {
            throw Py.TypeError(String.format("%.200s attribute must be str", string));
        }
        return (PyString)pyObject;
    }

    public static PyUnicode getUnicode(PyObject pyObject, String string) {
        if (!(pyObject instanceof PyUnicode)) {
            throw Py.TypeError(String.format("%.200s attribute must be unicode", string));
        }
        return (PyUnicode)pyObject;
    }

    private static String basename(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n > -1) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    private static void defineSlots(PyObject pyObject, String ... stringArray) {
        PyObject[] pyObjectArray = new PyObject[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            pyObjectArray[i] = Py.newString(stringArray[i]);
        }
        pyObject.__setitem__("__slots__", (PyObject)new PyTuple(pyObjectArray));
    }

    private static void initSlots(PyObject pyObject) {
        for (PyObject pyObject2 : pyObject.__findattr__("__slots__").asIterable()) {
            if (!(pyObject2 instanceof PyString)) continue;
            pyObject.__setattr__((PyString)pyObject2, Py.None);
        }
    }

    private static PyObject buildClass(PyObject pyObject, String string, String string2, String string3) {
        return exceptions.buildClass(pyObject, string, string2, new PyStringMap(), string3);
    }

    private static PyObject buildClass(PyObject pyObject, String string, String string2, PyObject pyObject2, String string3) {
        pyObject2.__setitem__("__doc__", (PyObject)Py.newString(string3));
        PyType pyType = (PyType)Py.makeClass("exceptions." + string, pyObject.__finditem__(string2), pyObject2);
        pyType.builtin = true;
        pyObject.__setitem__(string, (PyObject)pyType);
        return pyType;
    }

    public static PyObject bindStaticJavaMethod(String string, String string2) {
        return exceptions.bindStaticJavaMethod(string, exceptions.class, string2);
    }

    public static PyObject bindStaticJavaMethod(String string, Class<?> clazz, String string2) {
        Method method;
        try {
            method = clazz.getMethod(string2, PyObject.class, PyObject[].class, String[].class);
        }
        catch (Exception exception) {
            throw Py.JavaError(exception);
        }
        return new BoundStaticJavaMethod(string, method);
    }

    static class BoundStaticJavaMethod
    extends PyBuiltinMethod {
        private Method javaMethod;

        public BoundStaticJavaMethod(String string, Method method) {
            super(string);
            this.javaMethod = method;
        }

        protected BoundStaticJavaMethod(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info, Method method) {
            super(pyType, pyObject, info);
            this.javaMethod = method;
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new BoundStaticJavaMethod(this.getType(), pyObject, this.info, this.javaMethod);
        }

        public PyObject __get__(PyObject pyObject, PyObject pyObject2) {
            if (pyObject != null) {
                return this.bind(pyObject);
            }
            return this.makeDescriptor((PyType)pyObject2);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            try {
                return Py.java2py(this.javaMethod.invoke(null, this.self, pyObjectArray, stringArray));
            }
            catch (Throwable throwable) {
                throw Py.JavaError(throwable);
            }
        }
    }
}

