/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.TextIOBase;
import org.python.core.util.StringUtil;

public class BinaryIOWrapper
extends TextIOBase {
    public BinaryIOWrapper(BufferedIOBase bufferedIOBase) {
        super(bufferedIOBase);
    }

    public String read(int n) {
        if (n < 0) {
            return this.readall();
        }
        if (!this.readahead.hasRemaining()) {
            return StringUtil.fromBytes(this.bufferedIO.read(n));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        if (this.readahead.remaining() >= n) {
            int n2 = this.readahead.limit();
            this.readahead.limit(this.readahead.position() + n);
            byteBuffer.put(this.readahead);
            this.readahead.limit(n2);
            byteBuffer.flip();
            return StringUtil.fromBytes(byteBuffer);
        }
        byteBuffer.put(this.readahead);
        this.clearReadahead();
        this.bufferedIO.readinto(byteBuffer);
        byteBuffer.flip();
        return StringUtil.fromBytes(byteBuffer);
    }

    public String readall() {
        if (!this.readahead.hasRemaining()) {
            return StringUtil.fromBytes(this.bufferedIO.readall());
        }
        ByteBuffer byteBuffer = this.bufferedIO.readall();
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.readahead.remaining() + byteBuffer.remaining());
        byteBuffer2.put(this.readahead);
        this.clearReadahead();
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        return StringUtil.fromBytes(byteBuffer2);
    }

    public String readline(int n) {
        int n2;
        do {
            byte[] byArray = this.readahead.array();
            n2 = this.readahead.position();
            int n3 = 0;
            while (n2 < this.readahead.limit() && (n < 0 || this.builder.length() + n3 < n)) {
                char c = (char)(byArray[n2++] & 0xFF);
                this.interimBuilder[n3++] = c;
                if (c != '\n') continue;
                this.builder.append(this.interimBuilder, 0, n3);
                this.readahead.position(n2);
                return this.drainBuilder();
            }
            this.builder.append(this.interimBuilder, 0, n3);
        } while ((n < 0 || this.builder.length() < n) && this.readChunk() > 0);
        if (this.readahead.hasRemaining()) {
            this.readahead.position(n2);
        }
        return this.drainBuilder();
    }

    public int write(String string) {
        if (this.readahead.hasRemaining()) {
            this.clearReadahead();
        }
        return this.bufferedIO.write(ByteBuffer.wrap(StringUtil.toBytes(string)));
    }
}

