/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.BufferedIOMixin;
import org.python.core.io.BufferedReader;
import org.python.core.io.BufferedWriter;
import org.python.core.io.RawIOBase;

public class BufferedRandom
extends BufferedIOMixin {
    protected BufferedIOBase reader;
    protected BufferedIOBase writer;

    public BufferedRandom(RawIOBase rawIOBase, int n) {
        super(rawIOBase, n);
        this.initChildBuffers();
    }

    protected void initChildBuffers() {
        this.reader = new BufferedReader(this.rawIO, this.bufferSize);
        this.writer = new BufferedWriter(this.rawIO, this.bufferSize);
    }

    public long seek(long l, int n) {
        this.flush();
        l = this.writer.seek(l, n);
        this.reader.clear();
        return l;
    }

    public long tell() {
        if (this.writer.buffered()) {
            return this.writer.tell();
        }
        return this.reader.tell();
    }

    public ByteBuffer read(int n) {
        this.flush();
        return this.reader.read(n);
    }

    public ByteBuffer readall() {
        this.flush();
        return this.reader.readall();
    }

    public int readinto(ByteBuffer byteBuffer) {
        this.flush();
        return this.reader.readinto(byteBuffer);
    }

    public int write(ByteBuffer byteBuffer) {
        if (this.reader.buffered()) {
            this.reader.clear();
        }
        return this.writer.write(byteBuffer);
    }

    public ByteBuffer peek(int n) {
        this.flush();
        return this.reader.peek(n);
    }

    public int read1(ByteBuffer byteBuffer) {
        this.flush();
        return this.reader.read1(byteBuffer);
    }

    public void flush() {
        this.writer.flush();
    }
}

