/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import org.python.core.io.BufferedIOMixin;
import org.python.core.io.RawIOBase;

public class BufferedWriter
extends BufferedIOMixin {
    protected ByteBuffer buffer;

    public BufferedWriter(RawIOBase rawIOBase, int n) {
        super(rawIOBase, n);
        rawIOBase.checkWritable();
        this.buffer = ByteBuffer.allocate(this.bufferSize);
    }

    public int write(ByteBuffer byteBuffer) {
        int n;
        if (this.bufferSize == 0) {
            return this.rawIO.write(byteBuffer);
        }
        int n2 = byteBuffer.remaining();
        int n3 = this.buffer.position() + n2;
        if (n3 < this.bufferSize) {
            this.buffer.put(byteBuffer);
            return n2;
        }
        int n4 = n3 % this.bufferSize;
        int n5 = n2 - n4;
        int n6 = byteBuffer.limit();
        byteBuffer.limit(byteBuffer.position() + n5);
        int n7 = n = n3 - n4;
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{this.buffer, byteBuffer};
        this.buffer.flip();
        while (n7 > 0) {
            n7 = (int)((long)n7 - this.rawIO.write(byteBufferArray));
        }
        this.buffer.clear();
        if (n4 > 0) {
            byteBuffer.limit(n6);
            this.buffer.put(byteBuffer);
        }
        return n;
    }

    public void flush() {
        if (this.buffer.position() > 0) {
            this.buffer.flip();
            while (this.buffer.hasRemaining()) {
                this.rawIO.write(this.buffer);
            }
            this.buffer.clear();
        }
        super.flush();
    }

    public long tell() {
        return this.rawIO.tell() + (long)this.buffer.position();
    }

    public long seek(long l, int n) {
        this.flush();
        return this.rawIO.seek(l, n);
    }

    public boolean buffered() {
        return this.buffer.position() > 0;
    }

    public ByteBuffer readall() {
        this.checkClosed();
        this.checkReadable();
        return null;
    }

    public int readinto(ByteBuffer byteBuffer) {
        this.checkClosed();
        this.checkReadable();
        return -1;
    }

    public int read1(ByteBuffer byteBuffer) {
        this.checkClosed();
        this.checkReadable();
        return -1;
    }

    public boolean readable() {
        return false;
    }
}

