/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import org.python.constantine.platform.Errno;
import org.python.core.Py;
import org.python.core.io.RawIOBase;
import org.python.core.util.RelativeFile;
import org.python.modules.posix.PosixModule;
import org.python.posix.util.Platform;

public class FileIO
extends RawIOBase {
    private FileChannel fileChannel;
    private RandomAccessFile file;
    private FileOutputStream fileOutputStream;
    private boolean reading;
    private boolean writing;
    private boolean appending;
    private boolean plus;
    private boolean emulateAppend;

    public FileIO(String string, String string2) {
        this.parseMode(string2);
        RelativeFile relativeFile = new RelativeFile(string);
        try {
            if (this.appending && !this.reading && !this.plus) {
                this.fromFileOutputStream(relativeFile);
            } else {
                this.fromRandomAccessFile(relativeFile);
                this.emulateAppend = this.appending;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (relativeFile.isDirectory()) {
                throw Py.IOError(Errno.EISDIR, string);
            }
            if (this.writing && !relativeFile.canWrite() || fileNotFoundException.getMessage().endsWith("(Permission denied)")) {
                throw Py.IOError(Errno.EACCES, string);
            }
            throw Py.IOError(Errno.ENOENT, string);
        }
        this.initPosition();
    }

    public FileIO(FileChannel fileChannel, String string) {
        this.parseMode(string);
        this.fileChannel = fileChannel;
        this.initPosition();
    }

    private void parseMode(String string) {
        boolean bl = false;
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'r': {
                    if (this.plus || bl) {
                        this.badMode();
                    }
                    bl = true;
                    this.reading = true;
                    continue block6;
                }
                case 'w': {
                    if (this.plus || bl) {
                        this.badMode();
                    }
                    bl = true;
                    this.writing = true;
                    continue block6;
                }
                case 'a': {
                    if (this.plus || bl) {
                        this.badMode();
                    }
                    bl = true;
                    this.writing = true;
                    this.appending = true;
                    continue block6;
                }
                case '+': {
                    if (this.plus || !bl) {
                        this.badMode();
                    }
                    this.plus = true;
                    this.writing = true;
                    continue block6;
                }
                default: {
                    throw Py.ValueError("invalid mode: '" + string + "'");
                }
            }
        }
        if (!bl) {
            this.badMode();
        }
    }

    private void fromRandomAccessFile(File file) throws FileNotFoundException {
        String string = "r" + (this.writing ? "w" : "");
        if (this.plus && this.reading && !file.isFile()) {
            this.writing = false;
            throw new FileNotFoundException("");
        }
        this.file = new RandomAccessFile(file, string);
        this.fileChannel = this.file.getChannel();
    }

    private void fromFileOutputStream(File file) throws FileNotFoundException {
        this.fileOutputStream = new FileOutputStream(file, true);
        this.fileChannel = this.fileOutputStream.getChannel();
    }

    private void badMode() {
        throw Py.ValueError("Must have exactly one of read/write/append mode");
    }

    private void initPosition() {
        if (this.appending) {
            this.seek(0L, 2);
        } else if (this.writing && !this.reading) {
            try {
                this.fileChannel.truncate(0L);
            }
            catch (IOException iOException) {
                if (Platform.IS_WINDOWS || (Platform.IS_SOLARIS || Platform.IS_LINUX) && Errno.EINVAL.description().equals(iOException.getMessage())) {
                    return;
                }
                throw Py.IOError(iOException);
            }
        }
    }

    public boolean isatty() {
        this.checkClosed();
        if (this.file == null || this.fileOutputStream == null) {
            return false;
        }
        try {
            return PosixModule.getPOSIX().isatty(this.file != null ? this.file.getFD() : this.fileOutputStream.getFD());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public int readinto(ByteBuffer byteBuffer) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.fileChannel.read(byteBuffer);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public long readinto(ByteBuffer[] byteBufferArray) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.fileChannel.read(byteBufferArray);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public ByteBuffer readall() {
        long l;
        this.checkClosed();
        this.checkReadable();
        try {
            l = Math.max(0L, this.fileChannel.size() - this.fileChannel.position());
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        if (l > Integer.MAX_VALUE) {
            throw Py.OverflowError("requested number of bytes is more than a Python string can hold");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)l);
        this.readinto(byteBuffer);
        byteBuffer.flip();
        return byteBuffer;
    }

    public int write(ByteBuffer byteBuffer) {
        this.checkClosed();
        this.checkWritable();
        try {
            return !this.emulateAppend ? this.fileChannel.write(byteBuffer) : this.fileChannel.write(byteBuffer, this.fileChannel.position());
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public long write(ByteBuffer[] byteBufferArray) {
        this.checkClosed();
        this.checkWritable();
        try {
            return !this.emulateAppend ? this.fileChannel.write(byteBufferArray) : this.writeAppend(byteBufferArray);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    private long writeAppend(ByteBuffer[] byteBufferArray) throws IOException {
        long l = 0L;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (!byteBuffer.hasRemaining()) continue;
            int n = this.fileChannel.write(byteBuffer, this.fileChannel.position());
            if (n == 0) break;
            l += (long)n;
        }
        return l;
    }

    public long seek(long l, int n) {
        this.checkClosed();
        try {
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    l += this.fileChannel.position();
                    break;
                }
                case 2: {
                    l += this.fileChannel.size();
                    break;
                }
                default: {
                    throw Py.IOError(Errno.EINVAL);
                }
            }
            this.fileChannel.position(l);
            return l;
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public long tell() {
        this.checkClosed();
        try {
            return this.fileChannel.position();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    public long truncate(long l) {
        this.checkClosed();
        this.checkWritable();
        try {
            long l2 = this.fileChannel.position();
            this.fileChannel.truncate(l);
            this.fileChannel.position(l2);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        return l;
    }

    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        super.close();
    }

    public OutputStream asOutputStream() {
        return this.writing ? Channels.newOutputStream(this.fileChannel) : super.asOutputStream();
    }

    public InputStream asInputStream() {
        return this.readable() ? Channels.newInputStream(this.fileChannel) : super.asInputStream();
    }

    public boolean readable() {
        return this.reading || this.plus;
    }

    public boolean writable() {
        return this.writing;
    }

    public FileChannel getChannel() {
        return this.fileChannel;
    }
}

