/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.python.core.Py;
import org.python.core.io.IOBase;

public abstract class RawIOBase
extends IOBase {
    public ByteBuffer read(int n) {
        if (n < 0) {
            return this.readall();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        this.readinto(byteBuffer);
        byteBuffer.flip();
        return byteBuffer;
    }

    public ByteBuffer readall() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8192);
        int n = 0;
        while ((n = this.readinto(byteBuffer2)) > 0) {
            if (byteBuffer.remaining() < n) {
                long l = (long)byteBuffer.position() + (long)n;
                if (l > Integer.MAX_VALUE) {
                    throw Py.OverflowError("requested number of bytes is more than a Python string can hold");
                }
                ByteBuffer byteBuffer3 = byteBuffer;
                byteBuffer = ByteBuffer.allocate(Math.max(byteBuffer3.capacity() * 2, (int)l));
                byteBuffer3.flip();
                byteBuffer.put(byteBuffer3);
            }
            byteBuffer2.flip();
            byteBuffer.put(byteBuffer2);
            byteBuffer2.clear();
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public int readinto(ByteBuffer byteBuffer) {
        this.unsupported("readinto");
        return -1;
    }

    public long readinto(ByteBuffer[] byteBufferArray) {
        long l = 0L;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (!byteBuffer.hasRemaining()) continue;
            int n = this.readinto(byteBuffer);
            if (n == 0) break;
            l += (long)n;
        }
        return l;
    }

    public int write(ByteBuffer byteBuffer) {
        this.unsupported("write");
        return -1;
    }

    public long write(ByteBuffer[] byteBufferArray) {
        long l = 0L;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            if (!byteBuffer.hasRemaining()) continue;
            int n = this.write(byteBuffer);
            if (n == 0) break;
            l += (long)n;
        }
        return l;
    }

    public RawIOBase fileno() {
        this.checkClosed();
        return this;
    }

    public abstract Channel getChannel();
}

