/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.IOException;
import java.nio.channels.Channel;
import org.python.core.Py;
import org.python.core.io.RawIOBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SocketIOBase<T extends Channel>
extends RawIOBase {
    protected T socketChannel;
    private boolean readable = false;
    private boolean writable = false;

    public SocketIOBase(T t, String string) {
        this.socketChannel = t;
        this.parseMode(string);
    }

    protected void parseMode(String string) {
        if (string.equals("r")) {
            this.readable = true;
        } else if (string.equals("w")) {
            this.writable = true;
        } else if (string.equals("rw")) {
            this.writable = true;
            this.readable = true;
        } else {
            throw Py.ValueError("invalid mode: '" + string + "'");
        }
    }

    @Override
    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        super.close();
    }

    public T getChannel() {
        return this.socketChannel;
    }

    @Override
    public boolean readable() {
        return this.readable;
    }

    @Override
    public boolean writable() {
        return this.writable;
    }
}

