/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.io.BufferedIOBase;
import org.python.core.io.IOBase;
import org.python.core.io.RawIOBase;

public abstract class TextIOBase
extends IOBase {
    public static final int CHUNK_SIZE = 300;
    protected static final byte CR_BYTE = 13;
    protected BufferedIOBase bufferedIO;
    protected ByteBuffer readahead;
    protected StringBuilder builder;
    protected char[] interimBuilder;

    public TextIOBase(BufferedIOBase bufferedIOBase) {
        this.bufferedIO = bufferedIOBase;
        this.readahead = ByteBuffer.allocate(300);
        this.readahead.flip();
        this.builder = new StringBuilder(300);
        this.interimBuilder = new char[300];
    }

    public String read(int n) {
        this.unsupported("read");
        return null;
    }

    public String readall() {
        this.unsupported("readall");
        return null;
    }

    public String readline(int n) {
        this.unsupported("read");
        return null;
    }

    public int readinto(PyObject pyObject) {
        if (!(pyObject instanceof PyArray)) {
            if (pyObject instanceof PyString) {
                throw Py.TypeError("Cannot use string as modifiable buffer");
            }
            throw Py.TypeError("argument 1 must be read-write buffer, not " + pyObject.getType().fastGetName());
        }
        PyArray pyArray = (PyArray)pyObject;
        String string = this.read(pyArray.__len__());
        for (int i = 0; i < string.length(); ++i) {
            pyArray.set(i, new PyString(string.charAt(i)));
        }
        return string.length();
    }

    public int write(String string) {
        this.unsupported("write");
        return -1;
    }

    public long truncate(long l) {
        long l2 = this.tell();
        this.flush();
        l = this.bufferedIO.truncate(l);
        if (l2 > l) {
            this.seek(l2);
        }
        return l;
    }

    public void flush() {
        this.bufferedIO.flush();
    }

    public void close() {
        this.bufferedIO.close();
    }

    public long seek(long l, int n) {
        l = this.bufferedIO.seek(l, n);
        this.clearReadahead();
        return l;
    }

    public long tell() {
        return this.bufferedIO.tell() - (long)this.readahead.remaining();
    }

    public RawIOBase fileno() {
        return this.bufferedIO.fileno();
    }

    public boolean isatty() {
        return this.bufferedIO.isatty();
    }

    public boolean readable() {
        return this.bufferedIO.readable();
    }

    public boolean writable() {
        return this.bufferedIO.writable();
    }

    public boolean closed() {
        return this.bufferedIO.closed();
    }

    public InputStream asInputStream() {
        return this.bufferedIO.asInputStream();
    }

    public OutputStream asOutputStream() {
        return this.bufferedIO.asOutputStream();
    }

    public PyObject getNewlines() {
        return Py.None;
    }

    protected boolean atEOF() {
        return this.readahead.hasRemaining() ? false : this.readChunk() == 0;
    }

    protected int readChunk() {
        this.readahead.clear();
        if (this.readahead.remaining() > 300) {
            this.readahead.limit(this.readahead.position() + 300);
        }
        this.bufferedIO.read1(this.readahead);
        this.readahead.flip();
        return this.readahead.remaining();
    }

    protected int readChunk(int n) {
        if (n > 300) {
            this.readahead = ByteBuffer.allocate(n);
        } else {
            n = 300;
            this.readahead.clear().limit(n);
        }
        this.bufferedIO.readinto(this.readahead);
        this.readahead.flip();
        return this.readahead.remaining();
    }

    protected void packReadahead() {
        if (this.readahead.capacity() > 300) {
            ByteBuffer byteBuffer = this.readahead;
            this.readahead = ByteBuffer.allocate(300);
            this.readahead.put(byteBuffer);
            this.readahead.flip();
        }
    }

    protected void clearReadahead() {
        this.readahead.clear().flip();
    }

    protected String drainBuilder() {
        String string = this.builder.toString();
        if (this.builder.capacity() > 300) {
            this.builder = new StringBuilder(300);
        } else {
            this.builder.setLength(0);
        }
        return string;
    }
}

