/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.python.core.io.BinaryIOWrapper;
import org.python.core.io.BufferedIOBase;

public class TextIOWrapper
extends BinaryIOWrapper {
    private static final Pattern LF_PATTERN = Pattern.compile("\n");
    private String newline = System.getProperty("line.separator");
    private boolean newlineIsLF = this.newline.equals("\n");

    public TextIOWrapper(BufferedIOBase bufferedIOBase) {
        super(bufferedIOBase);
    }

    public String read(int n) {
        int n2;
        if (this.newlineIsLF) {
            return super.read(n);
        }
        if (n < 0) {
            return this.readall();
        }
        char[] cArray = new char[n];
        int n3 = 0;
        do {
            byte[] byArray = this.readahead.array();
            n2 = this.readahead.position();
            while (n2 < this.readahead.limit() && n3 < n) {
                int n4;
                if ((n4 = (int)(byArray[n2++] & 0xFF)) == 13) {
                    if (n2 == this.readahead.limit()) {
                        if (this.readChunk() == 0) {
                            cArray[n3++] = n4;
                            return new String(cArray, 0, n3);
                        }
                        byArray = this.readahead.array();
                        n2 = this.readahead.position();
                    }
                    if (byArray[n2] == 10) {
                        n4 = 10;
                        ++n2;
                    }
                }
                cArray[n3++] = n4;
            }
        } while (n3 < n && this.readChunk(n - n3) > 0);
        if (this.readahead.hasRemaining()) {
            this.readahead.position(n2);
        }
        this.packReadahead();
        return new String(cArray, 0, n3);
    }

    public String readall() {
        if (this.newlineIsLF) {
            return super.readall();
        }
        ByteBuffer byteBuffer = this.bufferedIO.readall();
        int n = 0;
        if (this.readahead.hasRemaining() && this.readahead.get(this.readahead.limit() - 1) == 13 && byteBuffer.hasRemaining() && byteBuffer.get(byteBuffer.position()) == 10) {
            --n;
        }
        char[] cArray = new char[this.readahead.remaining() + byteBuffer.remaining()];
        n += this.readLoop(this.readahead.array(), this.readahead.position(), cArray, 0, this.readahead.remaining());
        this.readahead.position(this.readahead.limit());
        n += this.readLoop(byteBuffer.array(), byteBuffer.position(), cArray, n, byteBuffer.remaining());
        return new String(cArray, 0, n);
    }

    private int readLoop(byte[] byArray, int n, char[] cArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n + n3;
        while (n < n5) {
            int n6;
            if ((n6 = (int)(byArray[n++] & 0xFF)) == 13) {
                if (n == n5) {
                    cArray[n2++] = n6;
                    continue;
                }
                if (byArray[n] == 10) {
                    n6 = 10;
                    ++n;
                }
            }
            cArray[n2++] = n6;
        }
        return n2 - n4;
    }

    public String readline(int n) {
        int n2;
        if (this.newlineIsLF) {
            return super.readline(n);
        }
        do {
            byte[] byArray = this.readahead.array();
            n2 = this.readahead.position();
            int n3 = 0;
            while (n2 < this.readahead.limit() && (n < 0 || this.builder.length() + n3 < n)) {
                int n4 = byArray[n2++] & 0xFF;
                this.interimBuilder[n3++] = n4;
                if (n4 == 13) {
                    boolean bl = false;
                    if (n2 == this.readahead.limit()) {
                        if (this.readChunk() == 0) {
                            this.builder.append(this.interimBuilder, 0, n3);
                            return this.drainBuilder();
                        }
                        byArray = this.readahead.array();
                        n2 = this.readahead.position();
                        bl = true;
                    }
                    if (byArray[n2] == 10) {
                        ++n2;
                        n4 = 10;
                        this.interimBuilder[n3 - 1] = 10;
                    }
                    if (bl) {
                        this.builder.append(this.interimBuilder, 0, n3);
                        n3 = 0;
                    }
                }
                if (n4 != 10) continue;
                this.builder.append(this.interimBuilder, 0, n3);
                this.readahead.position(n2);
                return this.drainBuilder();
            }
            this.builder.append(this.interimBuilder, 0, n3);
        } while ((n < 0 || this.builder.length() < n) && this.readChunk() > 0);
        if (this.readahead.hasRemaining()) {
            this.readahead.position(n2);
        }
        return this.drainBuilder();
    }

    public int write(String string) {
        if (!this.newlineIsLF) {
            string = LF_PATTERN.matcher(string).replaceAll(this.newline);
        }
        return super.write(string);
    }
}

