/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.python.core.Py;

public class StringUtil {
    public static byte[] toBytes(String string) {
        try {
            return string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Py.SystemError("Java couldn't find the ISO-8859-1 encoding");
        }
    }

    public static String fromBytes(byte[] byArray, int n, int n2) {
        return new String(byArray, 0, n, n2);
    }

    public static String fromBytes(byte[] byArray) {
        return StringUtil.fromBytes(byArray, 0, byArray.length);
    }

    public static String fromBytes(ByteBuffer byteBuffer) {
        return StringUtil.fromBytes(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.arrayOffset() + byteBuffer.limit());
    }

    public static String decapitalize(String string) {
        char c = string.charAt(0);
        if (!Character.isUpperCase(c)) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(c);
        return new String(cArray);
    }
}

