/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.python.google.common.base.Function;
import org.python.google.common.base.Joiner;
import org.python.google.common.base.Objects;
import org.python.google.common.base.Platform;
import org.python.google.common.base.Preconditions;
import org.python.google.common.base.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class Predicates {
    private static final Joiner COMMA_JOINER = Joiner.on(",");

    private Predicates() {
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> alwaysTrue() {
        return ObjectPredicate.ALWAYS_TRUE.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> alwaysFalse() {
        return ObjectPredicate.ALWAYS_FALSE.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> isNull() {
        return ObjectPredicate.IS_NULL.withNarrowedType();
    }

    @GwtCompatible(serializable=true)
    public static <T> Predicate<T> notNull() {
        return ObjectPredicate.NOT_NULL.withNarrowedType();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return new NotPredicate<T>(predicate);
    }

    public static <T> Predicate<T> and(Iterable<? extends Predicate<? super T>> iterable) {
        return new AndPredicate(Predicates.defensiveCopy(iterable));
    }

    public static <T> Predicate<T> and(Predicate<? super T> ... predicateArray) {
        return new AndPredicate(Predicates.defensiveCopy(predicateArray));
    }

    public static <T> Predicate<T> and(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new AndPredicate(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> or(Iterable<? extends Predicate<? super T>> iterable) {
        return new OrPredicate(Predicates.defensiveCopy(iterable));
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... predicateArray) {
        return new OrPredicate(Predicates.defensiveCopy(predicateArray));
    }

    public static <T> Predicate<T> or(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return new OrPredicate(Predicates.asList(Preconditions.checkNotNull(predicate), Preconditions.checkNotNull(predicate2)));
    }

    public static <T> Predicate<T> equalTo(@Nullable T t) {
        return t == null ? Predicates.isNull() : new IsEqualToPredicate(t);
    }

    @GwtIncompatible(value="Class.isInstance")
    public static Predicate<Object> instanceOf(Class<?> clazz) {
        return new InstanceOfPredicate(clazz);
    }

    public static <T> Predicate<T> in(Collection<? extends T> collection) {
        return new InPredicate(collection);
    }

    public static <A, B> Predicate<A> compose(Predicate<B> predicate, Function<A, ? extends B> function) {
        return new CompositionPredicate(predicate, function);
    }

    @Beta
    @GwtIncompatible(value="java.util.regex.Pattern")
    public static Predicate<CharSequence> containsPattern(String string) {
        return new ContainsPatternPredicate(string);
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public static Predicate<CharSequence> contains(Pattern pattern) {
        return new ContainsPatternPredicate(pattern);
    }

    private static boolean iterableElementsEqual(Iterable<?> iterable, Iterable<?> iterable2) {
        Iterator<?> iterator = iterable.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    private static <T> List<Predicate<? super T>> asList(Predicate<? super T> predicate, Predicate<? super T> predicate2) {
        return Arrays.asList(predicate, predicate2);
    }

    private static <T> List<T> defensiveCopy(T ... TArray) {
        return Predicates.defensiveCopy(Arrays.asList(TArray));
    }

    static <T> List<T> defensiveCopy(Iterable<T> iterable) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : iterable) {
            arrayList.add(Preconditions.checkNotNull(t));
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AndPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Iterable<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private AndPredicate(Iterable<? extends Predicate<? super T>> iterable) {
            this.components = iterable;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (predicate.apply(t)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = -1;
            for (Predicate<T> predicate : this.components) {
                n &= predicate.hashCode();
            }
            return n;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof AndPredicate) {
                AndPredicate andPredicate = (AndPredicate)object;
                return Predicates.iterableElementsEqual(this.components, andPredicate.components);
            }
            return false;
        }

        public String toString() {
            return "And(" + COMMA_JOINER.join(this.components) + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositionPredicate<A, B>
    implements Predicate<A>,
    Serializable {
        final Predicate<B> p;
        final Function<A, ? extends B> f;
        private static final long serialVersionUID = 0L;

        private CompositionPredicate(Predicate<B> predicate, Function<A, ? extends B> function) {
            this.p = Preconditions.checkNotNull(predicate);
            this.f = Preconditions.checkNotNull(function);
        }

        @Override
        public boolean apply(A a) {
            return this.p.apply(this.f.apply(a));
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof CompositionPredicate) {
                CompositionPredicate compositionPredicate = (CompositionPredicate)object;
                return ((Object)this.f).equals(compositionPredicate.f) && ((Object)this.p).equals(compositionPredicate.p);
            }
            return false;
        }

        public int hashCode() {
            return this.f.hashCode() ^ this.p.hashCode();
        }

        public String toString() {
            return this.p.toString() + "(" + this.f.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="Only used by other GWT-incompatible code.")
    private static class ContainsPatternPredicate
    implements Predicate<CharSequence>,
    Serializable {
        final Pattern pattern;
        private static final long serialVersionUID = 0L;

        ContainsPatternPredicate(Pattern pattern) {
            this.pattern = Preconditions.checkNotNull(pattern);
        }

        ContainsPatternPredicate(String string) {
            this(Pattern.compile(string));
        }

        @Override
        public boolean apply(CharSequence charSequence) {
            return this.pattern.matcher(charSequence).find();
        }

        public int hashCode() {
            return Objects.hashCode(this.pattern.pattern(), this.pattern.flags());
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof ContainsPatternPredicate) {
                ContainsPatternPredicate containsPatternPredicate = (ContainsPatternPredicate)object;
                return Objects.equal(this.pattern.pattern(), containsPatternPredicate.pattern.pattern()) && Objects.equal(this.pattern.flags(), containsPatternPredicate.pattern.flags());
            }
            return false;
        }

        public String toString() {
            return Objects.toStringHelper(this).add("pattern", this.pattern).add("pattern.flags", Integer.toHexString(this.pattern.flags())).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> target;
        private static final long serialVersionUID = 0L;

        private InPredicate(Collection<?> collection) {
            this.target = Preconditions.checkNotNull(collection);
        }

        @Override
        public boolean apply(T t) {
            try {
                return this.target.contains(t);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof InPredicate) {
                InPredicate inPredicate = (InPredicate)object;
                return ((Object)this.target).equals(inPredicate.target);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.target).hashCode();
        }

        public String toString() {
            return "In(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceOfPredicate
    implements Predicate<Object>,
    Serializable {
        private final Class<?> clazz;
        private static final long serialVersionUID = 0L;

        private InstanceOfPredicate(Class<?> clazz) {
            this.clazz = Preconditions.checkNotNull(clazz);
        }

        @Override
        public boolean apply(@Nullable Object object) {
            return Platform.isInstance(this.clazz, object);
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof InstanceOfPredicate) {
                InstanceOfPredicate instanceOfPredicate = (InstanceOfPredicate)object;
                return this.clazz == instanceOfPredicate.clazz;
            }
            return false;
        }

        public String toString() {
            return "IsInstanceOf(" + this.clazz.getName() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;
        private static final long serialVersionUID = 0L;

        private IsEqualToPredicate(T t) {
            this.target = t;
        }

        @Override
        public boolean apply(T t) {
            return this.target.equals(t);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof IsEqualToPredicate) {
                IsEqualToPredicate isEqualToPredicate = (IsEqualToPredicate)object;
                return this.target.equals(isEqualToPredicate.target);
            }
            return false;
        }

        public String toString() {
            return "IsEqualTo(" + this.target + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        final Predicate<T> predicate;
        private static final long serialVersionUID = 0L;

        NotPredicate(Predicate<T> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(T t) {
            return !this.predicate.apply(t);
        }

        public int hashCode() {
            return ~this.predicate.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof NotPredicate) {
                NotPredicate notPredicate = (NotPredicate)object;
                return ((Object)this.predicate).equals(notPredicate.predicate);
            }
            return false;
        }

        public String toString() {
            return "Not(" + this.predicate.toString() + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ObjectPredicate implements Predicate<Object>
    {
        ALWAYS_TRUE{

            public boolean apply(@Nullable Object object) {
                return true;
            }
        }
        ,
        ALWAYS_FALSE{

            public boolean apply(@Nullable Object object) {
                return false;
            }
        }
        ,
        IS_NULL{

            public boolean apply(@Nullable Object object) {
                return object == null;
            }
        }
        ,
        NOT_NULL{

            public boolean apply(@Nullable Object object) {
                return object != null;
            }
        };


        <T> Predicate<T> withNarrowedType() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Iterable<? extends Predicate<? super T>> components;
        private static final long serialVersionUID = 0L;

        private OrPredicate(Iterable<? extends Predicate<? super T>> iterable) {
            this.components = iterable;
        }

        @Override
        public boolean apply(T t) {
            for (Predicate<T> predicate : this.components) {
                if (!predicate.apply(t)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int n = 0;
            for (Predicate<T> predicate : this.components) {
                n |= predicate.hashCode();
            }
            return n;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof OrPredicate) {
                OrPredicate orPredicate = (OrPredicate)object;
                return Predicates.iterableElementsEqual(this.components, orPredicate.components);
            }
            return false;
        }

        public String toString() {
            return "Or(" + COMMA_JOINER.join(this.components) + ")";
        }
    }
}

