/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.python.google.common.primitives.Booleans;
import org.python.google.common.primitives.Ints;
import org.python.google.common.primitives.Longs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public abstract class ComparisonChain {
    private static final ComparisonChain ACTIVE = new ComparisonChain(){

        public ComparisonChain compare(Comparable comparable, Comparable comparable2) {
            return this.classify(comparable.compareTo(comparable2));
        }

        @Override
        public <T> ComparisonChain compare(@Nullable T t, @Nullable T t2, Comparator<T> comparator) {
            return this.classify(comparator.compare(t, t2));
        }

        @Override
        public ComparisonChain compare(int n, int n2) {
            return this.classify(Ints.compare(n, n2));
        }

        @Override
        public ComparisonChain compare(long l, long l2) {
            return this.classify(Longs.compare(l, l2));
        }

        @Override
        public ComparisonChain compare(float f, float f2) {
            return this.classify(Float.compare(f, f2));
        }

        @Override
        public ComparisonChain compare(double d, double d2) {
            return this.classify(Double.compare(d, d2));
        }

        @Override
        public ComparisonChain compare(boolean bl, boolean bl2) {
            return this.classify(Booleans.compare(bl, bl2));
        }

        ComparisonChain classify(int n) {
            return n < 0 ? LESS : (n > 0 ? GREATER : ACTIVE);
        }

        @Override
        public int result() {
            return 0;
        }
    };
    private static final ComparisonChain LESS = new InactiveComparisonChain(-1);
    private static final ComparisonChain GREATER = new InactiveComparisonChain(1);

    private ComparisonChain() {
    }

    public static ComparisonChain start() {
        return ACTIVE;
    }

    public abstract ComparisonChain compare(Comparable<?> var1, Comparable<?> var2);

    public abstract <T> ComparisonChain compare(@Nullable T var1, @Nullable T var2, Comparator<T> var3);

    public abstract ComparisonChain compare(int var1, int var2);

    public abstract ComparisonChain compare(long var1, long var3);

    public abstract ComparisonChain compare(float var1, float var2);

    public abstract ComparisonChain compare(double var1, double var3);

    public abstract ComparisonChain compare(boolean var1, boolean var2);

    public abstract int result();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InactiveComparisonChain
    extends ComparisonChain {
        final int result;

        InactiveComparisonChain(int n) {
            this.result = n;
        }

        public ComparisonChain compare(@Nullable Comparable comparable, @Nullable Comparable comparable2) {
            return this;
        }

        @Override
        public <T> ComparisonChain compare(@Nullable T t, @Nullable T t2, @Nullable Comparator<T> comparator) {
            return this;
        }

        @Override
        public ComparisonChain compare(int n, int n2) {
            return this;
        }

        @Override
        public ComparisonChain compare(long l, long l2) {
            return this;
        }

        @Override
        public ComparisonChain compare(float f, float f2) {
            return this;
        }

        @Override
        public ComparisonChain compare(double d, double d2) {
            return this;
        }

        @Override
        public ComparisonChain compare(boolean bl, boolean bl2) {
            return this;
        }

        @Override
        public int result() {
            return this.result;
        }
    }
}

