/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.Ordering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
final class CompoundOrdering<T>
extends Ordering<T>
implements Serializable {
    final ImmutableList<Comparator<? super T>> comparators;
    private static final long serialVersionUID = 0L;

    CompoundOrdering(Comparator<? super T> comparator, Comparator<? super T> comparator2) {
        this.comparators = ImmutableList.of(comparator, comparator2);
    }

    CompoundOrdering(Iterable<? extends Comparator<? super T>> iterable) {
        this.comparators = ImmutableList.copyOf(iterable);
    }

    CompoundOrdering(List<? extends Comparator<? super T>> list, Comparator<? super T> comparator) {
        this.comparators = ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(list)).add(comparator)).build();
    }

    @Override
    public int compare(T t, T t2) {
        for (Comparator comparator : this.comparators) {
            int n = comparator.compare(t, t2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompoundOrdering) {
            CompoundOrdering compoundOrdering = (CompoundOrdering)object;
            return this.comparators.equals(compoundOrdering.comparators);
        }
        return false;
    }

    public int hashCode() {
        return this.comparators.hashCode();
    }

    public String toString() {
        return "Ordering.compound(" + this.comparators + ")";
    }
}

