/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.python.google.common.base.Equivalence;
import org.python.google.common.base.Equivalences;
import org.python.google.common.base.FinalizableReferenceQueue;
import org.python.google.common.base.FinalizableSoftReference;
import org.python.google.common.base.FinalizableWeakReference;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.AbstractMapEntry;
import org.python.google.common.collect.ForwardingConcurrentMap;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.MapEvictionListener;
import org.python.google.common.collect.MapMaker;
import org.python.google.common.primitives.Ints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CustomConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    static final int RECENCY_THRESHOLD = 64;
    final transient int segmentMask;
    final transient int segmentShift;
    final transient Segment[] segments;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    final Strength keyStrength;
    final Strength valueStrength;
    final long expirationNanos;
    final boolean expires;
    final int maximumSize;
    final boolean evicts;
    final Queue<ReferenceEntry<K, V>> pendingEvictionNotifications;
    final MapEvictionListener<? super K, ? super V> evictionListener;
    final int concurrencyLevel;
    final transient EntryFactory entryFactory;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public Object get() {
            return null;
        }

        @Override
        public ValueReference<Object, Object> copyFor(ReferenceEntry<Object, Object> referenceEntry) {
            throw new AssertionError();
        }

        @Override
        public Object waitForValue() {
            throw new AssertionError();
        }

        @Override
        public void clear() {
        }
    };
    static final Queue<Object> discardingQueue = new AbstractQueue<Object>(){

        @Override
        public boolean offer(Object object) {
            return true;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }
    };
    Set<K> keySet;
    Collection<V> values;
    Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 3L;

    CustomConcurrentHashMap(MapMaker mapMaker) {
        int n;
        int n2;
        this.keyStrength = mapMaker.getKeyStrength();
        this.valueStrength = mapMaker.getValueStrength();
        this.keyEquivalence = mapMaker.getKeyEquivalence();
        this.valueEquivalence = mapMaker.getValueEquivalence();
        this.expirationNanos = mapMaker.getExpirationNanos();
        this.maximumSize = mapMaker.maximumSize;
        this.evicts = this.maximumSize != -1;
        this.expires = this.expirationNanos > 0L;
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, this.expires, this.evicts);
        MapEvictionListener mapEvictionListener = mapMaker.evictionListener;
        if (mapEvictionListener == null || mapEvictionListener.equals(NullListener.INSTANCE)) {
            NullListener nullListener;
            Queue<Object> queue = discardingQueue;
            this.pendingEvictionNotifications = queue;
            this.evictionListener = nullListener = NullListener.INSTANCE;
        } else {
            this.pendingEvictionNotifications = new ConcurrentLinkedQueue<ReferenceEntry<K, V>>();
            this.evictionListener = mapEvictionListener;
        }
        this.concurrencyLevel = CustomConcurrentHashMap.filterConcurrencyLevel(mapMaker.getConcurrencyLevel());
        int n3 = mapMaker.getInitialCapacity();
        if (n3 > 0x40000000) {
            n3 = 0x40000000;
        }
        int n4 = 0;
        for (n2 = 1; !(n2 >= this.concurrencyLevel || this.evicts && n2 * 2 > this.maximumSize); n2 <<= 1) {
            ++n4;
        }
        this.segmentShift = 32 - n4;
        this.segmentMask = n2 - 1;
        this.segments = this.newSegmentArray(n2);
        int n5 = n3 / n2;
        if (n5 * n2 < n3) {
            ++n5;
        }
        for (n = 1; n < n5; n <<= 1) {
        }
        if (this.evicts) {
            int n6 = this.maximumSize / n2 + 1;
            int n7 = this.maximumSize % n2;
            for (int i = 0; i < this.segments.length; ++i) {
                if (i == n7) {
                    --n6;
                }
                this.segments[i] = new Segment(n, n6);
            }
        } else {
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new Segment(n, -1);
            }
        }
    }

    static int filterConcurrencyLevel(int n) {
        return Math.min(n, 65536);
    }

    private static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    private static int rehash(int n) {
        n += n << 15 ^ 0xFFFFCD7D;
        n ^= n >>> 10;
        n += n << 3;
        n ^= n >>> 6;
        n += (n << 2) + (n << 14);
        return n ^ n >>> 16;
    }

    void setValueReference(ReferenceEntry<K, V> referenceEntry, ValueReference<K, V> valueReference) {
        referenceEntry.setValueReference(valueReference);
    }

    @GuardedBy(value="Segment.this")
    ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
        ValueReference<K, V> valueReference = referenceEntry.getValueReference();
        ReferenceEntry<K, V> referenceEntry3 = this.entryFactory.copyEntry(this, referenceEntry, referenceEntry2);
        referenceEntry3.setValueReference(valueReference.copyFor(referenceEntry3));
        return referenceEntry3;
    }

    int hash(Object object) {
        int n = this.keyEquivalence.hash(Preconditions.checkNotNull(object));
        return CustomConcurrentHashMap.rehash(n);
    }

    void reclaimValue(ReferenceEntry<K, V> referenceEntry) {
        int n = referenceEntry.getHash();
        if (this.segmentFor(n).reclaimValue(referenceEntry, n)) {
            ReferenceEntry referenceEntry2 = this.entryFactory.newEntry(this, referenceEntry.getKey(), n, null);
            this.pendingEvictionNotifications.offer(referenceEntry2);
        }
    }

    boolean removeEntry(ReferenceEntry<K, V> referenceEntry) {
        int n = referenceEntry.getHash();
        return this.segmentFor(n).removeEntry(referenceEntry, n);
    }

    @GuardedBy(value="Segment.this")
    static void connectExpirables(Expirable expirable, Expirable expirable2) {
        expirable.setNextExpirable(expirable2);
        expirable2.setPreviousExpirable(expirable);
    }

    @GuardedBy(value="Segment.this")
    static void nullifyExpirable(Expirable expirable) {
        expirable.setNextExpirable(NullExpirable.INSTANCE);
        expirable.setPreviousExpirable(NullExpirable.INSTANCE);
    }

    boolean isExpired(ReferenceEntry<K, V> referenceEntry) {
        return this.isExpired((Expirable)((Object)referenceEntry), System.nanoTime());
    }

    boolean isExpired(Expirable expirable, long l) {
        return l - expirable.getWriteTime() > this.expirationNanos;
    }

    V getUnexpiredValue(ReferenceEntry<K, V> referenceEntry) {
        V v = referenceEntry.getValueReference().get();
        return (V)(this.expires && this.isExpired(referenceEntry) ? null : v);
    }

    void processPendingNotifications() {
        ReferenceEntry<K, V> referenceEntry;
        while ((referenceEntry = this.pendingEvictionNotifications.poll()) != null) {
            this.evictionListener.onEviction(referenceEntry.getKey(), referenceEntry.getValueReference().get());
        }
    }

    @GuardedBy(value="Segment.this")
    static void connectEvictables(Evictable evictable, Evictable evictable2) {
        evictable.setNextEvictable(evictable2);
        evictable2.setPreviousEvictable(evictable);
    }

    @GuardedBy(value="Segment.this")
    static void nullifyEvictable(Evictable evictable) {
        evictable.setNextEvictable(NullEvictable.INSTANCE);
        evictable.setPreviousEvictable(NullEvictable.INSTANCE);
    }

    final Segment[] newSegmentArray(int n) {
        return (Segment[])Array.newInstance(Segment.class, n);
    }

    Segment segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    @Override
    public boolean isEmpty() {
        int n;
        Segment[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n2 = 0;
        for (n = 0; n < segmentArray.length; ++n) {
            if (segmentArray[n].count != 0) {
                return false;
            }
            nArray[n] = segmentArray[n].modCount;
            n2 += nArray[n];
        }
        if (n2 != 0) {
            for (n = 0; n < segmentArray.length; ++n) {
                if (segmentArray[n].count == 0 && nArray[n] == segmentArray[n].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        Segment[] segmentArray = this.segments;
        long l = 0L;
        long l2 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (int i = 0; i < 2; ++i) {
            int n;
            l2 = 0L;
            l = 0L;
            int n2 = 0;
            for (n = 0; n < segmentArray.length; ++n) {
                l += (long)segmentArray[n].count;
                nArray[n] = segmentArray[n].modCount;
                n2 += nArray[n];
            }
            if (n2 != 0) {
                for (n = 0; n < segmentArray.length; ++n) {
                    l2 += (long)segmentArray[n].count;
                    if (nArray[n] == segmentArray[n].modCount) continue;
                    l2 = -1L;
                    break;
                }
            }
            if (l2 == l) break;
        }
        if (l2 != l) {
            l = 0L;
            for (Segment segment : segmentArray) {
                segment.lock();
            }
            for (Segment segment : segmentArray) {
                l += (long)segment.count;
            }
            for (Segment segment : segmentArray) {
                segment.unlock();
            }
        }
        return Ints.saturatedCast(l);
    }

    @Override
    public V get(Object object) {
        int n = this.hash(object);
        return this.segmentFor(n).get(object, n);
    }

    @Override
    public boolean containsKey(Object object) {
        int n = this.hash(object);
        return this.segmentFor(n).containsKey(object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        Preconditions.checkNotNull(object, "value");
        Segment[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        for (int i = 0; i < 2; ++i) {
            int n;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                n = segmentArray[n2].count;
                nArray[n2] = segmentArray[n2].modCount;
                n3 += nArray[n2];
                if (!segmentArray[n2].containsValue(object)) continue;
                return true;
            }
            n2 = 1;
            if (n3 != 0) {
                for (n = 0; n < segmentArray.length; ++n) {
                    int bl = segmentArray[n].count;
                    if (nArray[n] == segmentArray[n].modCount) continue;
                    n2 = 0;
                    break;
                }
            }
            if (n2 == 0) continue;
            return false;
        }
        for (Segment segment : segmentArray) {
            segment.lock();
        }
        try {
            for (Segment segment : segmentArray) {
                if (!segment.containsValue(object)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            for (Segment segment : segmentArray) {
                segment.unlock();
            }
        }
        return false;
    }

    @Override
    public V put(K k, V v) {
        int n = this.hash(k);
        return this.segmentFor(n).put(k, n, v, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        int n = this.hash(k);
        return this.segmentFor(n).put(k, n, v, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n, this.expires);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        int n = this.hash(object);
        return this.segmentFor(n).remove(object, n, object2);
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        int n = this.hash(k);
        return this.segmentFor(n).replace(k, n, v, v2);
    }

    @Override
    public V replace(K k, V v) {
        int n = this.hash(k);
        return this.segmentFor(n).replace(k, n, v);
    }

    @Override
    public void clear() {
        for (Segment segment : this.segments) {
            segment.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    Object writeReplace() {
        return new SerializationProxy<K, V>(this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expirationNanos, this.maximumSize, this.concurrencyLevel, this.evictionListener, this);
    }

    static /* synthetic */ ValueReference access$200() {
        return CustomConcurrentHashMap.unset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractSerializationProxy<K, V>
    extends ForwardingConcurrentMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Strength keyStrength;
        final Strength valueStrength;
        final Equivalence<Object> keyEquivalence;
        final Equivalence<Object> valueEquivalence;
        final long expirationNanos;
        final int maximumSize;
        final int concurrencyLevel;
        final MapEvictionListener<? super K, ? super V> evictionListener;
        transient ConcurrentMap<K, V> delegate;

        AbstractSerializationProxy(Strength strength, Strength strength2, Equivalence<Object> equivalence, Equivalence<Object> equivalence2, long l, int n, int n2, MapEvictionListener<? super K, ? super V> mapEvictionListener, ConcurrentMap<K, V> concurrentMap) {
            this.keyStrength = strength;
            this.valueStrength = strength2;
            this.keyEquivalence = equivalence;
            this.valueEquivalence = equivalence2;
            this.expirationNanos = l;
            this.maximumSize = n;
            this.concurrencyLevel = n2;
            this.evictionListener = mapEvictionListener;
            this.delegate = concurrentMap;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return this.delegate;
        }

        void writeMapTo(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeInt(this.delegate.size());
            for (Map.Entry entry : this.delegate.entrySet()) {
                objectOutputStream.writeObject(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
            objectOutputStream.writeObject(null);
        }

        MapMaker readMapMaker(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            int n = objectInputStream.readInt();
            MapMaker mapMaker = new MapMaker().initialCapacity(n).setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).privateKeyEquivalence(this.keyEquivalence).privateValueEquivalence(this.valueEquivalence).concurrencyLevel(this.concurrencyLevel);
            mapMaker.evictionListener(this.evictionListener);
            if (this.expirationNanos != 0L) {
                mapMaker.expiration(this.expirationNanos, TimeUnit.NANOSECONDS);
            }
            if (this.maximumSize != -1) {
                mapMaker.maximumSize(this.maximumSize);
            }
            return mapMaker;
        }

        void readEntries(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            Object object;
            while ((object = objectInputStream.readObject()) != null) {
                Object object2 = objectInputStream.readObject();
                this.delegate.put(object, object2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EntryFactory {
        STRONG{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new StrongEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }
        }
        ,
        STRONG_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new StrongExpirableEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry3 = super.copyEntry(customConcurrentHashMap, referenceEntry, referenceEntry2);
                this.copyExpirableEntry(referenceEntry, referenceEntry3);
                return referenceEntry3;
            }
        }
        ,
        STRONG_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new StrongEvictableEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry3 = super.copyEntry(customConcurrentHashMap, referenceEntry, referenceEntry2);
                this.copyEvictableEntry(referenceEntry, referenceEntry3);
                return referenceEntry3;
            }
        }
        ,
        STRONG_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new StrongExpirableEvictableEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry3 = super.copyEntry(customConcurrentHashMap, referenceEntry, referenceEntry2);
                this.copyExpirableEntry(referenceEntry, referenceEntry3);
                this.copyEvictableEntry(referenceEntry, referenceEntry3);
                return referenceEntry3;
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new SoftEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }
        }
        ,
        SOFT_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new SoftExpirableEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry3 = super.copyEntry(customConcurrentHashMap, referenceEntry, referenceEntry2);
                this.copyExpirableEntry(referenceEntry, referenceEntry3);
                return referenceEntry3;
            }
        }
        ,
        SOFT_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new SoftEvictableEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry3 = super.copyEntry(customConcurrentHashMap, referenceEntry, referenceEntry2);
                this.copyEvictableEntry(referenceEntry, referenceEntry3);
                return referenceEntry3;
            }
        }
        ,
        SOFT_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new SoftExpirableEvictableEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry3 = super.copyEntry(customConcurrentHashMap, referenceEntry, referenceEntry2);
                this.copyExpirableEntry(referenceEntry, referenceEntry3);
                this.copyEvictableEntry(referenceEntry, referenceEntry3);
                return referenceEntry3;
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new WeakEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }
        }
        ,
        WEAK_EXPIRABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new WeakExpirableEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry3 = super.copyEntry(customConcurrentHashMap, referenceEntry, referenceEntry2);
                this.copyExpirableEntry(referenceEntry, referenceEntry3);
                return referenceEntry3;
            }
        }
        ,
        WEAK_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new WeakEvictableEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry3 = super.copyEntry(customConcurrentHashMap, referenceEntry, referenceEntry2);
                this.copyEvictableEntry(referenceEntry, referenceEntry3);
                return referenceEntry3;
            }
        }
        ,
        WEAK_EXPIRABLE_EVICTABLE{

            @Override
            <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
                return new WeakExpirableEvictableEntry<K, V>(customConcurrentHashMap, k, n, referenceEntry);
            }

            @Override
            <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
                ReferenceEntry<K, V> referenceEntry3 = super.copyEntry(customConcurrentHashMap, referenceEntry, referenceEntry2);
                this.copyExpirableEntry(referenceEntry, referenceEntry3);
                this.copyEvictableEntry(referenceEntry, referenceEntry3);
                return referenceEntry3;
            }
        };

        static final int EXPIRABLE_MASK = 1;
        static final int EVICTABLE_MASK = 2;
        static final EntryFactory[][] factories;

        static EntryFactory getFactory(Strength strength, boolean bl, boolean bl2) {
            int n = (bl ? 1 : 0) | (bl2 ? 2 : 0);
            return factories[strength.ordinal()][n];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(CustomConcurrentHashMap<K, V> var1, K var2, int var3, @Nullable ReferenceEntry<K, V> var4);

        @GuardedBy(value="Segment.this")
        <K, V> ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            return this.newEntry(customConcurrentHashMap, referenceEntry.getKey(), referenceEntry.getHash(), referenceEntry2);
        }

        @GuardedBy(value="Segment.this")
        <K, V> void copyExpirableEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            Expirable expirable = (Expirable)((Object)referenceEntry);
            Expirable expirable2 = (Expirable)((Object)referenceEntry2);
            expirable2.setWriteTime(expirable.getWriteTime());
            CustomConcurrentHashMap.connectExpirables(expirable.getPreviousExpirable(), expirable2);
            CustomConcurrentHashMap.connectExpirables(expirable2, expirable.getNextExpirable());
            CustomConcurrentHashMap.nullifyExpirable(expirable);
        }

        @GuardedBy(value="Segment.this")
        <K, V> void copyEvictableEntry(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            Evictable evictable = (Evictable)((Object)referenceEntry);
            Evictable evictable2 = (Evictable)((Object)referenceEntry2);
            CustomConcurrentHashMap.connectEvictables(evictable.getPreviousEvictable(), evictable2);
            CustomConcurrentHashMap.connectEvictables(evictable2, evictable.getNextEvictable());
            CustomConcurrentHashMap.nullifyEvictable(evictable);
        }

        static {
            factories = new EntryFactory[][]{{STRONG, STRONG_EXPIRABLE, STRONG_EVICTABLE, STRONG_EXPIRABLE_EVICTABLE}, {SOFT, SOFT_EXPIRABLE, SOFT_EVICTABLE, SOFT_EXPIRABLE_EVICTABLE}, {WEAK, WEAK_EXPIRABLE, WEAK_EVICTABLE, WEAK_EXPIRABLE_EVICTABLE}};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            if (k == null) {
                return false;
            }
            Object v = CustomConcurrentHashMap.this.get(k);
            return v != null && CustomConcurrentHashMap.this.valueEquivalence.equivalent(v, entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            return k != null && CustomConcurrentHashMap.this.remove(k, entry.getValue());
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    static interface Evictable {
        public Evictable getNextEvictable();

        public void setNextEvictable(Evictable var1);

        public Evictable getPreviousEvictable();

        public void setPreviousEvictable(Evictable var1);
    }

    static interface Expirable {
        public long getWriteTime();

        public void setWriteTime(long var1);

        public Expirable getNextExpirable();

        public void setNextExpirable(Expirable var1);

        public Expirable getPreviousExpirable();

        public void setPreviousExpirable(Expirable var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        ReferenceEntry<K, V> nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        HashIterator() {
            this.nextSegmentIndex = CustomConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment segment = CustomConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (segment.count == 0) continue;
                this.currentTable = segment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        boolean advanceTo(ReferenceEntry<K, V> referenceEntry) {
            Object k = referenceEntry.getKey();
            Object v = CustomConcurrentHashMap.this.getUnexpiredValue(referenceEntry);
            if (k != null && v != null) {
                this.nextExternal = new WriteThroughEntry(k, v);
                return true;
            }
            return false;
        }

        public boolean hasNext() {
            return this.nextExternal != null;
        }

        WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            Preconditions.checkState(this.lastReturned != null);
            CustomConcurrentHashMap.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return CustomConcurrentHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return CustomConcurrentHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NullEvictable implements Evictable
    {
        INSTANCE;


        @Override
        public Evictable getNextEvictable() {
            return this;
        }

        @Override
        public void setNextEvictable(Evictable evictable) {
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this;
        }

        @Override
        public void setPreviousEvictable(Evictable evictable) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NullExpirable implements Expirable
    {
        INSTANCE;


        @Override
        public long getWriteTime() {
            return 0L;
        }

        @Override
        public void setWriteTime(long l) {
        }

        @Override
        public Expirable getNextExpirable() {
            return this;
        }

        @Override
        public void setNextExpirable(Expirable expirable) {
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this;
        }

        @Override
        public void setPreviousExpirable(Expirable expirable) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NullListener implements MapEvictionListener
    {
        INSTANCE;


        public void onEviction(Object object, Object object2) {
        }
    }

    private static class QueueHolder {
        static final FinalizableReferenceQueue queue = new FinalizableReferenceQueue();

        private QueueHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        public void valueReclaimed();

        public ReferenceEntry<K, V> getNext();

        public int getHash();

        public K getKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Segment
    extends ReentrantLock {
        volatile int count;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        final int maxSegmentSize;
        final Queue<Evictable> recencyQueue;
        final AtomicInteger recencyQueueLength;
        @GuardedBy(value="Segment.this")
        final Evictable evictionHead = new Evictable(){
            @GuardedBy(value="Segment.this")
            Evictable nextEvictable = this;
            @GuardedBy(value="Segment.this")
            Evictable previousEvictable = this;

            public Evictable getNextEvictable() {
                return this.nextEvictable;
            }

            public void setNextEvictable(Evictable evictable) {
                this.nextEvictable = evictable;
            }

            public Evictable getPreviousEvictable() {
                return this.previousEvictable;
            }

            public void setPreviousEvictable(Evictable evictable) {
                this.previousEvictable = evictable;
            }
        };
        final Expirable expirationHead = new Expirable(){
            @GuardedBy(value="Segment.this")
            Expirable nextExpirable = this;
            @GuardedBy(value="Segment.this")
            Expirable previousExpirable = this;

            public long getWriteTime() {
                return Long.MAX_VALUE;
            }

            public void setWriteTime(long l) {
            }

            public Expirable getNextExpirable() {
                return this.nextExpirable;
            }

            public void setNextExpirable(Expirable expirable) {
                this.nextExpirable = expirable;
            }

            public Expirable getPreviousExpirable() {
                return this.previousExpirable;
            }

            public void setPreviousExpirable(Expirable expirable) {
                this.previousExpirable = expirable;
            }
        };

        Segment(int n, int n2) {
            this.setTable(this.newEntryArray(n));
            this.maxSegmentSize = n2;
            if (CustomConcurrentHashMap.this.evicts) {
                this.recencyQueue = new ConcurrentLinkedQueue<Evictable>();
                this.recencyQueueLength = new AtomicInteger();
            } else {
                this.recencyQueue = null;
                this.recencyQueueLength = null;
            }
        }

        AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int n) {
            return new AtomicReferenceArray(n);
        }

        @GuardedBy(value="Segment.this")
        void setValue(ReferenceEntry<K, V> referenceEntry, V v, boolean bl) {
            Object object;
            if (CustomConcurrentHashMap.this.expires) {
                object = (Expirable)((Object)referenceEntry);
                this.addExpirable((Expirable)object);
            }
            if (CustomConcurrentHashMap.this.evicts) {
                object = (Evictable)((Object)referenceEntry);
                this.addEvictableOnWrite((Evictable)object);
            }
            CustomConcurrentHashMap.this.setValueReference(referenceEntry, CustomConcurrentHashMap.this.valueStrength.referenceValue(referenceEntry, v));
        }

        @GuardedBy(value="Segment.this")
        void addExpirable(Expirable expirable) {
            CustomConcurrentHashMap.connectExpirables(expirable.getPreviousExpirable(), expirable.getNextExpirable());
            expirable.setWriteTime(System.nanoTime());
            CustomConcurrentHashMap.connectExpirables(this.expirationHead.getPreviousExpirable(), expirable);
            CustomConcurrentHashMap.connectExpirables(expirable, this.expirationHead);
        }

        @GuardedBy(value="Segment.this")
        void removeExpirable(Expirable expirable) {
            CustomConcurrentHashMap.connectExpirables(expirable.getPreviousExpirable(), expirable.getNextExpirable());
            CustomConcurrentHashMap.nullifyExpirable(expirable);
        }

        @GuardedBy(value="Segment.this")
        void expireEntries() {
            Expirable expirable = this.expirationHead.getNextExpirable();
            if (expirable == this.expirationHead) {
                return;
            }
            long l = System.nanoTime();
            while (expirable != this.expirationHead && CustomConcurrentHashMap.this.isExpired(expirable, l)) {
                ReferenceEntry referenceEntry = (ReferenceEntry)((Object)expirable);
                if (this.removeEntry(referenceEntry, referenceEntry.getHash())) {
                    CustomConcurrentHashMap.this.pendingEvictionNotifications.offer(referenceEntry);
                }
                this.removeExpirable(expirable);
                expirable = this.expirationHead.getNextExpirable();
            }
        }

        @GuardedBy(value="Segment.this")
        void clearExpirationQueue() {
            Expirable expirable = this.expirationHead.getNextExpirable();
            while (expirable != this.expirationHead) {
                Expirable expirable2 = expirable.getNextExpirable();
                CustomConcurrentHashMap.nullifyExpirable(expirable);
                expirable = expirable2;
            }
            this.expirationHead.setNextExpirable(this.expirationHead);
            this.expirationHead.setPreviousExpirable(this.expirationHead);
        }

        @GuardedBy(value="Segment.this")
        void evictEntry() {
            this.drainRecencyQueue();
            Evictable evictable = this.evictionHead.getNextEvictable();
            Preconditions.checkState(evictable != this.evictionHead);
            ReferenceEntry referenceEntry = (ReferenceEntry)((Object)evictable);
            if (!this.removeEntry(referenceEntry, referenceEntry.getHash())) {
                throw new AssertionError();
            }
            CustomConcurrentHashMap.this.pendingEvictionNotifications.offer(referenceEntry);
        }

        @GuardedBy(value="Segment.this")
        void addEvictableOnWrite(Evictable evictable) {
            this.drainRecencyQueue();
            this.addEvictable(evictable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addEvictableOnRead(Evictable evictable) {
            this.recencyQueue.add(evictable);
            if (this.recencyQueueLength.incrementAndGet() > 64 && this.tryLock()) {
                try {
                    this.drainRecencyQueue();
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="Segment.this")
        void drainRecencyQueue() {
            Evictable evictable;
            int n = 0;
            while ((evictable = this.recencyQueue.poll()) != null) {
                if (this.inEvictionList(evictable)) {
                    this.addEvictable(evictable);
                }
                ++n;
            }
            this.recencyQueueLength.addAndGet(-n);
        }

        @GuardedBy(value="Segment.this")
        void addEvictable(Evictable evictable) {
            if (evictable.getNextEvictable() != this.evictionHead) {
                CustomConcurrentHashMap.connectEvictables(evictable.getPreviousEvictable(), evictable.getNextEvictable());
                CustomConcurrentHashMap.connectEvictables(this.evictionHead.getPreviousEvictable(), evictable);
                CustomConcurrentHashMap.connectEvictables(evictable, this.evictionHead);
            }
        }

        @GuardedBy(value="Segment.this")
        void removeEvictable(Evictable evictable) {
            CustomConcurrentHashMap.connectEvictables(evictable.getPreviousEvictable(), evictable.getNextEvictable());
            CustomConcurrentHashMap.nullifyEvictable(evictable);
        }

        @GuardedBy(value="Segment.this")
        boolean inEvictionList(Evictable evictable) {
            return evictable.getNextEvictable() != NullEvictable.INSTANCE;
        }

        @GuardedBy(value="Segment.this")
        void clearEvictionQueue() {
            Evictable evictable = this.evictionHead.getNextEvictable();
            while (evictable != this.evictionHead) {
                Evictable evictable2 = evictable.getNextEvictable();
                CustomConcurrentHashMap.nullifyEvictable(evictable);
                evictable = evictable2;
            }
            this.evictionHead.setNextEvictable(this.evictionHead);
            this.evictionHead.setPreviousEvictable(this.evictionHead);
        }

        @GuardedBy(value="Segment.this")
        void setTable(AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray) {
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            if (this.threshold == this.maxSegmentSize) {
                ++this.threshold;
            }
            this.table = atomicReferenceArray;
        }

        ReferenceEntry<K, V> getFirst(int n) {
            AtomicReferenceArray atomicReferenceArray = this.table;
            return atomicReferenceArray.get(n & atomicReferenceArray.length() - 1);
        }

        public ReferenceEntry<K, V> getEntry(Object object, int n) {
            if (this.count != 0) {
                for (ReferenceEntry referenceEntry = this.getFirst(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                    Object k;
                    if (referenceEntry.getHash() != n || (k = referenceEntry.getKey()) == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(k, object) || CustomConcurrentHashMap.this.expires && CustomConcurrentHashMap.this.isExpired(referenceEntry)) continue;
                    if (CustomConcurrentHashMap.this.evicts) {
                        this.addEvictableOnRead((Evictable)((Object)referenceEntry));
                    }
                    return referenceEntry;
                }
            }
            return null;
        }

        V get(Object object, int n) {
            ReferenceEntry referenceEntry = this.getEntry(object, n);
            if (referenceEntry == null) {
                return null;
            }
            return referenceEntry.getValueReference().get();
        }

        boolean containsKey(Object object, int n) {
            if (this.count != 0) {
                for (ReferenceEntry referenceEntry = this.getFirst(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                    Object k;
                    if (referenceEntry.getHash() != n || (k = referenceEntry.getKey()) == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(k, object)) continue;
                    return CustomConcurrentHashMap.this.getUnexpiredValue(referenceEntry) != null;
                }
            }
            return false;
        }

        boolean containsValue(Object object) {
            if (this.count != 0) {
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n = atomicReferenceArray.length();
                for (int i = 0; i < n; ++i) {
                    for (ReferenceEntry referenceEntry = atomicReferenceArray.get(i); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                        Object v = CustomConcurrentHashMap.this.getUnexpiredValue(referenceEntry);
                        if (v == null || !CustomConcurrentHashMap.this.valueEquivalence.equivalent(v, object)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K k, int n, V v, V v2) {
            Preconditions.checkNotNull(v);
            Preconditions.checkNotNull(v2);
            this.lock();
            try {
                if (CustomConcurrentHashMap.this.expires) {
                    this.expireEntries();
                }
                for (ReferenceEntry referenceEntry = this.getFirst(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                    Object k2 = referenceEntry.getKey();
                    if (referenceEntry.getHash() != n || k2 == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(k, k2)) continue;
                    Object v3 = referenceEntry.getValueReference().get();
                    if (v3 == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (CustomConcurrentHashMap.this.valueEquivalence.equivalent(v3, v)) {
                        this.setValue(referenceEntry, v2, false);
                        boolean bl = true;
                        return bl;
                    }
                    if (!CustomConcurrentHashMap.this.evicts) continue;
                    this.addEvictableOnWrite((Evictable)((Object)referenceEntry));
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K k, int n, V v) {
            Preconditions.checkNotNull(v);
            this.lock();
            try {
                ReferenceEntry referenceEntry;
                if (CustomConcurrentHashMap.this.expires) {
                    this.expireEntries();
                }
                for (referenceEntry = this.getFirst(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                    Object k2 = referenceEntry.getKey();
                    if (referenceEntry.getHash() != n || k2 == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(k, k2)) continue;
                    Object v2 = referenceEntry.getValueReference().get();
                    if (v2 == null) {
                        Object v3 = null;
                        return v3;
                    }
                    this.setValue(referenceEntry, v, false);
                    Object v4 = v2;
                    return v4;
                }
                referenceEntry = null;
                return referenceEntry;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K k, int n, V v, boolean bl) {
            Preconditions.checkNotNull(v);
            this.lock();
            try {
                Object k2;
                ReferenceEntry referenceEntry;
                ReferenceEntry referenceEntry2;
                int n2;
                if (CustomConcurrentHashMap.this.expires) {
                    this.expireEntries();
                }
                if ((n2 = this.count + 1) > this.threshold) {
                    this.expand();
                }
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = n & atomicReferenceArray.length() - 1;
                for (referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    boolean bl2;
                    k2 = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != n || k2 == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(k, k2)) continue;
                    Object v2 = referenceEntry2.getValueReference().get();
                    boolean bl3 = bl2 = v2 == null;
                    if (bl && !bl2) {
                        if (CustomConcurrentHashMap.this.evicts) {
                            this.addEvictableOnWrite((Evictable)((Object)referenceEntry2));
                        }
                        Object v3 = v2;
                        return v3;
                    }
                    this.setValue(referenceEntry2, v, bl2);
                    Object v4 = v2;
                    return v4;
                }
                if (CustomConcurrentHashMap.this.evicts && n2 > this.maxSegmentSize) {
                    this.evictEntry();
                    n2 = this.count + 1;
                    referenceEntry = atomicReferenceArray.get(n3);
                }
                ++this.modCount;
                referenceEntry2 = CustomConcurrentHashMap.this.entryFactory.newEntry(CustomConcurrentHashMap.this, k, n, referenceEntry);
                this.setValue(referenceEntry2, v, true);
                atomicReferenceArray.set(n3, referenceEntry2);
                this.count = n2;
                k2 = null;
                return k2;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        @GuardedBy(value="Segment.this")
        void expand() {
            AtomicReferenceArray atomicReferenceArray = this.table;
            int n = atomicReferenceArray.length();
            if (n >= 0x40000000) {
                return;
            }
            AtomicReferenceArray atomicReferenceArray2 = this.newEntryArray(n << 1);
            this.threshold = atomicReferenceArray2.length() * 3 / 4;
            int n2 = atomicReferenceArray2.length() - 1;
            for (int i = 0; i < n; ++i) {
                ReferenceEntry referenceEntry;
                ReferenceEntry referenceEntry2 = atomicReferenceArray.get(i);
                if (referenceEntry2 == null) continue;
                ReferenceEntry referenceEntry3 = referenceEntry2.getNext();
                int n3 = referenceEntry2.getHash() & n2;
                if (referenceEntry3 == null) {
                    atomicReferenceArray2.set(n3, referenceEntry2);
                    continue;
                }
                ReferenceEntry referenceEntry4 = referenceEntry2;
                int n4 = n3;
                for (referenceEntry = referenceEntry3; referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                    int n5 = referenceEntry.getHash() & n2;
                    if (n5 == n4) continue;
                    n4 = n5;
                    referenceEntry4 = referenceEntry;
                }
                atomicReferenceArray2.set(n4, referenceEntry4);
                for (referenceEntry = referenceEntry2; referenceEntry != referenceEntry4; referenceEntry = referenceEntry.getNext()) {
                    Object k = referenceEntry.getKey();
                    if (k == null) continue;
                    int n6 = referenceEntry.getHash() & n2;
                    ReferenceEntry referenceEntry5 = atomicReferenceArray2.get(n6);
                    atomicReferenceArray2.set(n6, CustomConcurrentHashMap.this.copyEntry(referenceEntry, referenceEntry5));
                }
            }
            this.table = atomicReferenceArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object object, int n, boolean bl) {
            this.lock();
            try {
                ReferenceEntry referenceEntry;
                ReferenceEntry referenceEntry2;
                if (bl) {
                    this.expireEntries();
                }
                int n2 = this.count - 1;
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = n & atomicReferenceArray.length() - 1;
                for (referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    Object k = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != n || k == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(k, object)) continue;
                    Object v = referenceEntry2.getValueReference().get();
                    ++this.modCount;
                    ReferenceEntry referenceEntry3 = this.removeFromTable(referenceEntry, referenceEntry2);
                    atomicReferenceArray.set(n3, referenceEntry3);
                    this.count = n2;
                    Object v2 = v;
                    return v2;
                }
                referenceEntry2 = null;
                return referenceEntry2;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean remove(Object object, int n, Object object2) {
            Preconditions.checkNotNull(object2);
            this.lock();
            try {
                ReferenceEntry referenceEntry;
                if (CustomConcurrentHashMap.this.expires) {
                    this.expireEntries();
                }
                int n2 = this.count - 1;
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = n & atomicReferenceArray.length() - 1;
                for (ReferenceEntry referenceEntry2 = referenceEntry = atomicReferenceArray.get(n3); referenceEntry2 != null; referenceEntry2 = referenceEntry2.getNext()) {
                    Object k = referenceEntry2.getKey();
                    if (referenceEntry2.getHash() != n || k == null || !CustomConcurrentHashMap.this.keyEquivalence.equivalent(k, object)) continue;
                    Object v = referenceEntry2.getValueReference().get();
                    if (object2 == v || object2 != null && v != null && CustomConcurrentHashMap.this.valueEquivalence.equivalent(v, object2)) {
                        ++this.modCount;
                        ReferenceEntry referenceEntry3 = this.removeFromTable(referenceEntry, referenceEntry2);
                        atomicReferenceArray.set(n3, referenceEntry3);
                        this.count = n2;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
                CustomConcurrentHashMap.this.processPendingNotifications();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean reclaimValue(ReferenceEntry<K, V> referenceEntry, int n) {
            this.lock();
            try {
                ReferenceEntry referenceEntry2;
                int n2 = this.count - 1;
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = n & atomicReferenceArray.length() - 1;
                for (ReferenceEntry referenceEntry3 = referenceEntry2 = atomicReferenceArray.get(n3); referenceEntry3 != null; referenceEntry3 = referenceEntry3.getNext()) {
                    if (referenceEntry3 != referenceEntry) continue;
                    Object v = referenceEntry3.getValueReference().get();
                    if (v == null) {
                        ++this.modCount;
                        ReferenceEntry referenceEntry4 = this.removeFromTable(referenceEntry2, referenceEntry3);
                        atomicReferenceArray.set(n3, referenceEntry4);
                        this.count = n2;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeEntry(ReferenceEntry<K, V> referenceEntry, int n) {
            this.lock();
            try {
                ReferenceEntry referenceEntry2;
                int n2 = this.count - 1;
                AtomicReferenceArray atomicReferenceArray = this.table;
                int n3 = n & atomicReferenceArray.length() - 1;
                for (ReferenceEntry referenceEntry3 = referenceEntry2 = atomicReferenceArray.get(n3); referenceEntry3 != null; referenceEntry3 = referenceEntry3.getNext()) {
                    if (referenceEntry3 != referenceEntry) continue;
                    ++this.modCount;
                    ReferenceEntry referenceEntry4 = this.removeFromTable(referenceEntry2, referenceEntry3);
                    atomicReferenceArray.set(n3, referenceEntry4);
                    this.count = n2;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        @GuardedBy(value="Segment.this")
        private ReferenceEntry<K, V> removeFromTable(ReferenceEntry<K, V> referenceEntry, ReferenceEntry<K, V> referenceEntry2) {
            if (CustomConcurrentHashMap.this.expires) {
                this.removeExpirable((Expirable)((Object)referenceEntry2));
            }
            if (CustomConcurrentHashMap.this.evicts) {
                this.removeEvictable((Evictable)((Object)referenceEntry2));
            }
            ReferenceEntry referenceEntry3 = referenceEntry2.getNext();
            for (ReferenceEntry referenceEntry4 = referenceEntry; referenceEntry4 != referenceEntry2; referenceEntry4 = referenceEntry4.getNext()) {
                Object k = referenceEntry4.getKey();
                if (k == null) continue;
                referenceEntry3 = CustomConcurrentHashMap.this.copyEntry(referenceEntry4, referenceEntry3);
            }
            return referenceEntry3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    AtomicReferenceArray atomicReferenceArray = this.table;
                    for (int i = 0; i < atomicReferenceArray.length(); ++i) {
                        atomicReferenceArray.set(i, null);
                    }
                    this.clearExpirationQueue();
                    this.clearEvictionQueue();
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<K, V>
    extends AbstractSerializationProxy<K, V> {
        private static final long serialVersionUID = 1L;

        SerializationProxy(Strength strength, Strength strength2, Equivalence<Object> equivalence, Equivalence<Object> equivalence2, long l, int n, int n2, MapEvictionListener<? super K, ? super V> mapEvictionListener, ConcurrentMap<K, V> concurrentMap) {
            super(strength, strength2, equivalence, equivalence2, l, n, n2, mapEvictionListener, concurrentMap);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            this.writeMapTo(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(objectInputStream);
            this.delegate = mapMaker.makeMap();
            this.readEntries(objectInputStream);
        }

        private Object readResolve() {
            return this.delegate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftEntry<K, V>
    extends FinalizableSoftReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.access$200();

        SoftEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(k, QueueHolder.queue);
            this.map = customConcurrentHashMap;
            this.hash = n;
            this.next = referenceEntry;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            if (this.map.removeEntry(this)) {
                this.map.pendingEvictionNotifications.offer(this);
            }
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            if (this.valueReference != null) {
                this.valueReference.clear();
            }
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.map.reclaimValue(this);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements Evictable {
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        SoftEvictableEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(customConcurrentHashMap, k, n, referenceEntry);
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable evictable) {
            this.nextEvictable = evictable;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable evictable) {
            this.previousEvictable = evictable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftExpirableEntry<K, V>
    extends SoftEntry<K, V>
    implements Expirable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;

        SoftExpirableEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(customConcurrentHashMap, k, n, referenceEntry);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable expirable) {
            this.nextExpirable = expirable;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable expirable) {
            this.previousExpirable = expirable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftExpirableEvictableEntry<K, V>
    extends SoftEntry<K, V>
    implements Expirable,
    Evictable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        SoftExpirableEvictableEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(customConcurrentHashMap, k, n, referenceEntry);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable expirable) {
            this.nextExpirable = expirable;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable expirable) {
            this.previousExpirable = expirable;
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable evictable) {
            this.nextEvictable = evictable;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable evictable) {
            this.previousEvictable = evictable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoftValueReference<K, V>
    extends FinalizableSoftReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        SoftValueReference(V v, ReferenceEntry<K, V> referenceEntry) {
            super(v, QueueHolder.queue);
            this.entry = referenceEntry;
        }

        @Override
        public void finalizeReferent() {
            this.entry.valueReclaimed();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> referenceEntry) {
            return new SoftValueReference(this.get(), referenceEntry);
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Strength {
        STRONG{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> referenceEntry, V v) {
                return new StrongValueReference(v);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.equals();
            }
        }
        ,
        SOFT{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> referenceEntry, V v) {
                return new SoftValueReference<K, V>(v, referenceEntry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        }
        ,
        WEAK{

            @Override
            <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> referenceEntry, V v) {
                return new WeakValueReference<K, V>(v, referenceEntry);
            }

            @Override
            Equivalence<Object> defaultEquivalence() {
                return Equivalences.identity();
            }
        };


        abstract <K, V> ValueReference<K, V> referenceValue(ReferenceEntry<K, V> var1, V var2);

        abstract Equivalence<Object> defaultEquivalence();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongEntry<K, V>
    implements ReferenceEntry<K, V> {
        final K key;
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.access$200();

        StrongEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            this.map = customConcurrentHashMap;
            this.key = k;
            this.hash = n;
            this.next = referenceEntry;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            if (this.valueReference != null) {
                this.valueReference.clear();
            }
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.map.reclaimValue(this);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements Evictable {
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        StrongEvictableEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(customConcurrentHashMap, k, n, referenceEntry);
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable evictable) {
            this.nextEvictable = evictable;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable evictable) {
            this.previousEvictable = evictable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongExpirableEntry<K, V>
    extends StrongEntry<K, V>
    implements Expirable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;

        StrongExpirableEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(customConcurrentHashMap, k, n, referenceEntry);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable expirable) {
            this.nextExpirable = expirable;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable expirable) {
            this.previousExpirable = expirable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongExpirableEvictableEntry<K, V>
    extends StrongEntry<K, V>
    implements Expirable,
    Evictable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        StrongExpirableEvictableEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(customConcurrentHashMap, k, n, referenceEntry);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable expirable) {
            this.nextExpirable = expirable;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable expirable) {
            this.previousExpirable = expirable;
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable evictable) {
            this.nextEvictable = evictable;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable evictable) {
            this.previousEvictable = evictable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        final V referent;

        StrongValueReference(V v) {
            this.referent = v;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> referenceEntry) {
            return this;
        }

        @Override
        public V waitForValue() {
            return this.get();
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ValueReference<K, V> {
        public V get();

        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> var1);

        public V waitForValue() throws InterruptedException;

        public void clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return CustomConcurrentHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CustomConcurrentHashMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return CustomConcurrentHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            CustomConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEntry<K, V>
    extends FinalizableWeakReference<K>
    implements ReferenceEntry<K, V> {
        final CustomConcurrentHashMap<K, V> map;
        final int hash;
        final ReferenceEntry<K, V> next;
        volatile ValueReference<K, V> valueReference = CustomConcurrentHashMap.access$200();

        WeakEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(k, QueueHolder.queue);
            this.map = customConcurrentHashMap;
            this.hash = n;
            this.next = referenceEntry;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public void finalizeReferent() {
            if (this.map.removeEntry(this)) {
                this.map.pendingEvictionNotifications.offer(this);
            }
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            if (this.valueReference != null) {
                this.valueReference.clear();
            }
            this.valueReference = valueReference;
        }

        @Override
        public void valueReclaimed() {
            this.map.reclaimValue(this);
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements Evictable {
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        WeakEvictableEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(customConcurrentHashMap, k, n, referenceEntry);
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable evictable) {
            this.nextEvictable = evictable;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable evictable) {
            this.previousEvictable = evictable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakExpirableEntry<K, V>
    extends WeakEntry<K, V>
    implements Expirable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;

        WeakExpirableEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(customConcurrentHashMap, k, n, referenceEntry);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable expirable) {
            this.nextExpirable = expirable;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable expirable) {
            this.previousExpirable = expirable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakExpirableEvictableEntry<K, V>
    extends WeakEntry<K, V>
    implements Expirable,
    Evictable {
        volatile long writeTime = Long.MAX_VALUE;
        @GuardedBy(value="Segment.this")
        Expirable nextExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Expirable previousExpirable = NullExpirable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable nextEvictable = NullEvictable.INSTANCE;
        @GuardedBy(value="Segment.this")
        Evictable previousEvictable = NullEvictable.INSTANCE;

        WeakExpirableEvictableEntry(CustomConcurrentHashMap<K, V> customConcurrentHashMap, K k, int n, @Nullable ReferenceEntry<K, V> referenceEntry) {
            super(customConcurrentHashMap, k, n, referenceEntry);
        }

        @Override
        public long getWriteTime() {
            return this.writeTime;
        }

        @Override
        public void setWriteTime(long l) {
            this.writeTime = l;
        }

        @Override
        public Expirable getNextExpirable() {
            return this.nextExpirable;
        }

        @Override
        public void setNextExpirable(Expirable expirable) {
            this.nextExpirable = expirable;
        }

        @Override
        public Expirable getPreviousExpirable() {
            return this.previousExpirable;
        }

        @Override
        public void setPreviousExpirable(Expirable expirable) {
            this.previousExpirable = expirable;
        }

        @Override
        public Evictable getNextEvictable() {
            return this.nextEvictable;
        }

        @Override
        public void setNextEvictable(Evictable evictable) {
            this.nextEvictable = evictable;
        }

        @Override
        public Evictable getPreviousEvictable() {
            return this.previousEvictable;
        }

        @Override
        public void setPreviousEvictable(Evictable evictable) {
            this.previousEvictable = evictable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakValueReference<K, V>
    extends FinalizableWeakReference<V>
    implements ValueReference<K, V> {
        final ReferenceEntry<K, V> entry;

        WeakValueReference(V v, ReferenceEntry<K, V> referenceEntry) {
            super(v, QueueHolder.queue);
            this.entry = referenceEntry;
        }

        @Override
        public void finalizeReferent() {
            this.entry.valueReclaimed();
        }

        @Override
        public ValueReference<K, V> copyFor(ReferenceEntry<K, V> referenceEntry) {
            return new WeakValueReference(this.get(), referenceEntry);
        }

        @Override
        public V waitForValue() {
            return (V)this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        final K key;
        V value;

        WriteThroughEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.key.equals(entry.getKey()) && this.value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public V setValue(V v) {
            Object v2 = CustomConcurrentHashMap.this.put(this.key, v);
            this.value = v;
            return v2;
        }
    }
}

