/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.python.google.common.collect.ExplicitOrdering;
import org.python.google.common.collect.ImmutableCollection;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableMap;
import org.python.google.common.collect.ImmutableSortedAsList;
import org.python.google.common.collect.ImmutableSortedSet;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.ObjectArrays;
import org.python.google.common.collect.Platform;
import org.python.google.common.collect.RegularImmutableList;
import org.python.google.common.collect.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true, emulated=true)
final class ExplicitOrderedImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    private final Object[] elements;
    private final int fromIndex;
    private final int toIndex;

    static <E> ImmutableSortedSet<E> create(List<E> list) {
        ExplicitOrdering<E> explicitOrdering = new ExplicitOrdering<E>(list);
        if (explicitOrdering.rankMap.isEmpty()) {
            return ExplicitOrderedImmutableSortedSet.emptySet(explicitOrdering);
        }
        Object[] objectArray = ((ImmutableCollection)((Object)explicitOrdering.rankMap.keySet())).toArray();
        return new ExplicitOrderedImmutableSortedSet<E>(objectArray, explicitOrdering);
    }

    ExplicitOrderedImmutableSortedSet(Object[] objectArray, Comparator<? super E> comparator) {
        this(objectArray, comparator, 0, objectArray.length);
    }

    ExplicitOrderedImmutableSortedSet(Object[] objectArray, Comparator<? super E> comparator, int n, int n2) {
        super(comparator);
        this.elements = objectArray;
        this.fromIndex = n;
        this.toIndex = n2;
    }

    private ImmutableMap<E, Integer> rankMap() {
        return ((ExplicitOrdering)this.comparator()).rankMap;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.elements, this.fromIndex, this.size());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public boolean contains(Object object) {
        Integer n = this.rankMap().get(object);
        return n != null && n >= this.fromIndex && n < this.toIndex;
    }

    @Override
    boolean isPartialView() {
        return this.fromIndex != 0 || this.toIndex != this.elements.length;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Platform.unsafeArrayCopy(this.elements, this.fromIndex, objectArray, 0, this.size());
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size();
        if (TArray.length < n) {
            TArray = ObjectArrays.newArray(TArray, n);
        } else if (TArray.length > n) {
            TArray[n] = null;
        }
        Platform.unsafeArrayCopy(this.elements, this.fromIndex, TArray, 0, n);
        return TArray;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = this.fromIndex; i < this.toIndex; ++i) {
            n += this.elements[i].hashCode();
        }
        return n;
    }

    @Override
    public E first() {
        return (E)this.elements[this.fromIndex];
    }

    @Override
    public E last() {
        return (E)this.elements[this.toIndex - 1];
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E e) {
        return this.createSubset(this.fromIndex, this.findSubsetIndex(e));
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E e, E e2) {
        return this.createSubset(this.findSubsetIndex(e), this.findSubsetIndex(e2));
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E e) {
        return this.createSubset(this.findSubsetIndex(e), this.toIndex);
    }

    private int findSubsetIndex(E e) {
        Integer n = this.rankMap().get(e);
        if (n == null) {
            throw new ClassCastException();
        }
        if (n <= this.fromIndex) {
            return this.fromIndex;
        }
        if (n >= this.toIndex) {
            return this.toIndex;
        }
        return n;
    }

    private ImmutableSortedSet<E> createSubset(int n, int n2) {
        if (n < n2) {
            return new ExplicitOrderedImmutableSortedSet<E>(this.elements, this.comparator, n, n2);
        }
        return ExplicitOrderedImmutableSortedSet.emptySet(this.comparator);
    }

    @Override
    int indexOf(Object object) {
        Integer n = this.rankMap().get(object);
        return n != null && n >= this.fromIndex && n < this.toIndex ? n - this.fromIndex : -1;
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableSortedAsList(this, new RegularImmutableList(this.elements, this.fromIndex, this.size()));
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializedForm<E>
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        public SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableSortedSet.withExplicitOrder(Arrays.asList(this.elements));
        }
    }
}

