/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import org.python.google.common.base.Preconditions;

@GwtCompatible
final class Hashing {
    private static final int MAX_TABLE_SIZE = 0x40000000;
    private static final int CUTOFF = 0x20000000;

    private Hashing() {
    }

    static int smear(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    static int chooseTableSize(int n) {
        if (n < 0x20000000) {
            return Integer.highestOneBit(n) << 2;
        }
        Preconditions.checkArgument(n < 0x40000000, "collection too large");
        return 0x40000000;
    }
}

