/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.python.google.common.base.Function;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.ImmutableCollection;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableMap;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.ImmutableSortedMapFauxverideShim;
import org.python.google.common.collect.ImmutableSortedSet;
import org.python.google.common.collect.Iterators;
import org.python.google.common.collect.Lists;
import org.python.google.common.collect.Ordering;
import org.python.google.common.collect.RegularImmutableSortedSet;
import org.python.google.common.collect.SortedLists;
import org.python.google.common.collect.TransformedImmutableList;
import org.python.google.common.collect.UnmodifiableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true, emulated=true)
public class ImmutableSortedMap<K, V>
extends ImmutableSortedMapFauxverideShim<K, V>
implements SortedMap<K, V> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedMap<Comparable, Object> NATURAL_EMPTY_MAP = new ImmutableSortedMap(ImmutableList.of(), NATURAL_ORDER);
    final transient ImmutableList<Map.Entry<K, V>> entries;
    private final transient Comparator<? super K> comparator;
    final transient Function<Map.Entry<K, V>, K> keyFunction = new Function<Map.Entry<K, V>, K>(){

        @Override
        public K apply(Map.Entry<K, V> entry) {
            return entry.getKey();
        }
    };
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSortedSet<K> keySet;
    private transient ImmutableCollection<V> values;
    private static final long serialVersionUID = 0L;

    public static <K, V> ImmutableSortedMap<K, V> of() {
        return NATURAL_EMPTY_MAP;
    }

    private static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<? super K> comparator) {
        if (((Object)NATURAL_ORDER).equals(comparator)) {
            return NATURAL_EMPTY_MAP;
        }
        return new ImmutableSortedMap<K, V>(ImmutableList.<Map.Entry<K, V>>of(), comparator);
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v) {
        return new ImmutableSortedMap<K, V>(ImmutableList.of(ImmutableSortedMap.entryOf(k, v)), Ordering.natural());
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2) {
        return ((Builder)((Builder)new Builder(Ordering.natural()).put((Object)k, (Object)v)).put((Object)k2, (Object)v2)).build();
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3) {
        return ((Builder)((Builder)((Builder)new Builder(Ordering.natural()).put((Object)k, (Object)v)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).build();
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ((Builder)((Builder)((Builder)((Builder)new Builder(Ordering.natural()).put((Object)k, (Object)v)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).put((Object)k4, (Object)v4)).build();
    }

    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k, V v, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(Ordering.natural()).put((Object)k, (Object)v)).put((Object)k2, (Object)v2)).put((Object)k3, (Object)v3)).put((Object)k4, (Object)v4)).put((Object)k5, (Object)v5)).build();
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedMap.copyOfInternal(map, ordering);
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        return ImmutableSortedMap.copyOfInternal(map, Preconditions.checkNotNull(comparator));
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOfSorted(SortedMap<K, ? extends V> sortedMap) {
        Comparator<Object> comparator = sortedMap.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        return ImmutableSortedMap.copyOfInternal(sortedMap, comparator);
    }

    private static <K, V> ImmutableSortedMap<K, V> copyOfInternal(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        Map.Entry[] entryArray;
        boolean bl = false;
        if (map instanceof SortedMap) {
            entryArray = (Map.Entry[])map;
            Comparator comparator2 = entryArray.comparator();
            boolean bl2 = comparator2 == null ? comparator == NATURAL_ORDER : (bl = ((Object)comparator).equals(comparator2));
        }
        if (bl && map instanceof ImmutableSortedMap && !(entryArray = (ImmutableSortedMap)map).isPartialView()) {
            return entryArray;
        }
        entryArray = map.entrySet().toArray(new Map.Entry[0]);
        for (int i = 0; i < entryArray.length; ++i) {
            Map.Entry entry = entryArray[i];
            entryArray[i] = ImmutableSortedMap.entryOf(entry.getKey(), entry.getValue());
        }
        List<Map.Entry<K, V>> list = Arrays.asList(entryArray);
        if (!bl) {
            ImmutableSortedMap.sortEntries(list, comparator);
            ImmutableSortedMap.validateEntries(list, comparator);
        }
        return new ImmutableSortedMap<K, V>(ImmutableList.copyOf(list), comparator);
    }

    private static <K, V> void sortEntries(List<Map.Entry<K, V>> list, final Comparator<? super K> comparator) {
        Comparator comparator2 = new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> entry, Map.Entry<K, V> entry2) {
                return comparator.compare(entry.getKey(), entry2.getKey());
            }
        };
        Collections.sort(list, comparator2);
    }

    private static <K, V> void validateEntries(List<Map.Entry<K, V>> list, Comparator<? super K> comparator) {
        for (int i = 1; i < list.size(); ++i) {
            if (comparator.compare(list.get(i - 1).getKey(), list.get(i).getKey()) != 0) continue;
            throw new IllegalArgumentException("Duplicate keys in mappings " + list.get(i - 1) + " and " + list.get(i));
        }
    }

    public static <K extends Comparable<K>, V> Builder<K, V> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    public static <K, V> Builder<K, V> orderedBy(Comparator<K> comparator) {
        return new Builder(comparator);
    }

    public static <K extends Comparable<K>, V> Builder<K, V> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    ImmutableSortedMap(ImmutableList<Map.Entry<K, V>> immutableList, Comparator<? super K> comparator) {
        this.entries = immutableList;
        this.comparator = comparator;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    Comparator<Object> unsafeComparator() {
        return this.comparator;
    }

    @Override
    public V get(@Nullable Object object) {
        int n;
        if (object == null) {
            return null;
        }
        try {
            n = SortedLists.binarySearch(Lists.transform(this.entries, this.keyFunction), object, this.unsafeComparator(), SortedLists.Relation.EQUAL, false);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return n >= 0 ? (V)((Map.Entry)this.entries.get(n)).getValue() : null;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        return Iterators.contains(this.valueIterator(), object);
    }

    @Override
    boolean isPartialView() {
        return this.entries.isPartialView();
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = this.createEntrySet()) : immutableSet;
    }

    private ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new EntrySet(this);
    }

    @Override
    public ImmutableSortedSet<K> keySet() {
        ImmutableSortedSet<K> immutableSortedSet = this.keySet;
        return immutableSortedSet == null ? (this.keySet = this.createKeySet()) : immutableSortedSet;
    }

    private ImmutableSortedSet<K> createKeySet() {
        if (this.isEmpty()) {
            return ImmutableSortedSet.emptySet(this.comparator);
        }
        return new RegularImmutableSortedSet<K>(new TransformedImmutableList<Map.Entry<K, V>, K>(this.entries){

            @Override
            K transform(Map.Entry<K, V> entry) {
                return entry.getKey();
            }
        }, this.comparator);
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> immutableCollection = this.values;
        return immutableCollection == null ? (this.values = new Values(this)) : immutableCollection;
    }

    UnmodifiableIterator<V> valueIterator() {
        Iterator iterator = this.entries.iterator();
        return new UnmodifiableIterator<V>((UnmodifiableIterator)iterator){
            final /* synthetic */ UnmodifiableIterator val$entryIterator;
            {
                this.val$entryIterator = unmodifiableIterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$entryIterator.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)this.val$entryIterator.next()).getValue();
            }
        };
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public K firstKey() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return ((Map.Entry)this.entries.get(0)).getKey();
    }

    @Override
    public K lastKey() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return ((Map.Entry)this.entries.get(this.size() - 1)).getKey();
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K k) {
        int n = this.findSubmapIndex(Preconditions.checkNotNull(k));
        return this.createSubmap(0, n);
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K k, K k2) {
        Preconditions.checkNotNull(k);
        Preconditions.checkNotNull(k2);
        Preconditions.checkArgument(this.comparator.compare(k, k2) <= 0);
        int n = this.findSubmapIndex(k);
        int n2 = this.findSubmapIndex(k2);
        return this.createSubmap(n, n2);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K k) {
        int n = this.findSubmapIndex(Preconditions.checkNotNull(k));
        return this.createSubmap(n, this.size());
    }

    private int findSubmapIndex(K k) {
        return SortedLists.binarySearch(Lists.transform(this.entries, this.keyFunction), k, this.comparator, SortedLists.Relation.CEILING, false);
    }

    private ImmutableSortedMap<K, V> createSubmap(int n, int n2) {
        if (n < n2) {
            return new ImmutableSortedMap<K, V>(this.entries.subList(n, n2), this.comparator);
        }
        return ImmutableSortedMap.emptyMap(this.comparator);
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        private final Comparator<? super K> comparator;

        public Builder(Comparator<? super K> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public Builder<K, V> put(K k, V v) {
            this.entries.add(ImmutableMap.entryOf(k, v));
            return this;
        }

        @Override
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return this;
        }

        @Override
        public ImmutableSortedMap<K, V> build() {
            ImmutableSortedMap.sortEntries(this.entries, this.comparator);
            ImmutableSortedMap.validateEntries(this.entries, this.comparator);
            return new ImmutableSortedMap(ImmutableList.copyOf(this.entries), this.comparator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        final transient ImmutableSortedMap<K, V> map;

        EntrySet(ImmutableSortedMap<K, V> immutableSortedMap) {
            this.map = immutableSortedMap;
        }

        @Override
        boolean isPartialView() {
            return this.map.isPartialView();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.map.entries.iterator();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                V v = this.map.get(entry.getKey());
                return v != null && v.equals(entry.getValue());
            }
            return false;
        }

        @Override
        Object writeReplace() {
            return new EntrySetSerializedForm<K, V>(this.map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntrySetSerializedForm<K, V>
    implements Serializable {
        final ImmutableSortedMap<K, V> map;
        private static final long serialVersionUID = 0L;

        EntrySetSerializedForm(ImmutableSortedMap<K, V> immutableSortedMap) {
            this.map = immutableSortedMap;
        }

        Object readResolve() {
            return this.map.entrySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializedForm
    extends ImmutableMap.SerializedForm {
        private final Comparator<Object> comparator;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableSortedMap<?, ?> immutableSortedMap) {
            super(immutableSortedMap);
            this.comparator = immutableSortedMap.comparator();
        }

        @Override
        Object readResolve() {
            Builder<Object, Object> builder = new Builder<Object, Object>(this.comparator);
            return this.createMap(builder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Values<V>
    extends ImmutableCollection<V> {
        private final ImmutableSortedMap<?, V> map;

        Values(ImmutableSortedMap<?, V> immutableSortedMap) {
            this.map = immutableSortedMap;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return this.map.valueIterator();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        Object writeReplace() {
            return new ValuesSerializedForm<V>(this.map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValuesSerializedForm<V>
    implements Serializable {
        final ImmutableSortedMap<?, V> map;
        private static final long serialVersionUID = 0L;

        ValuesSerializedForm(ImmutableSortedMap<?, V> immutableSortedMap) {
            this.map = immutableSortedMap;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

