/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.EmptyImmutableSortedSet;
import org.python.google.common.collect.ExplicitOrderedImmutableSortedSet;
import org.python.google.common.collect.ImmutableList;
import org.python.google.common.collect.ImmutableSet;
import org.python.google.common.collect.ImmutableSortedSetFauxverideShim;
import org.python.google.common.collect.Lists;
import org.python.google.common.collect.Ordering;
import org.python.google.common.collect.RegularImmutableSortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedSet<E> {
    private static final Comparator NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedSet<Object> NATURAL_EMPTY_SET = new EmptyImmutableSortedSet<Object>(NATURAL_ORDER);
    final transient Comparator<? super E> comparator;

    private static <E> ImmutableSortedSet<E> emptySet() {
        return NATURAL_EMPTY_SET;
    }

    static <E> ImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (((Object)NATURAL_ORDER).equals(comparator)) {
            return ImmutableSortedSet.emptySet();
        }
        return new EmptyImmutableSortedSet<E>(comparator);
    }

    public static <E> ImmutableSortedSet<E> of() {
        return ImmutableSortedSet.emptySet();
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e) {
        return new RegularImmutableSortedSet<E>(ImmutableList.of(e), Ordering.natural());
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e, E e2) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(e, e2));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e, E e2, E e3) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(e, e2, e3));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e, E e2, E e3, E e4) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(e, e2, e3, e4));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e, E e2, E e3, E e4, E e5) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(e, e2, e3, e4, e5));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e, E e2, E e3, E e4, E e5, E e6, E ... EArray) {
        int n = EArray.length + 6;
        ArrayList arrayList = new ArrayList(n);
        Collections.addAll(arrayList, e, e2, e3, e4, e5, e6);
        Collections.addAll(arrayList, EArray);
        return ImmutableSortedSet.copyOf(Ordering.natural(), arrayList);
    }

    @Deprecated
    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E[] EArray) {
        return ImmutableSortedSet.copyOf(EArray);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> copyOf(E[] EArray) {
        return ImmutableSortedSet.copyOf(Ordering.natural(), Arrays.asList(EArray));
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterable<? extends E> iterable) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, iterable);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Collection<? extends E> collection) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, collection);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterator<? extends E> iterator) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOfInternal(ordering, iterator);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> iterator) {
        Preconditions.checkNotNull(comparator);
        return ImmutableSortedSet.copyOfInternal(comparator, iterator);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> iterable) {
        Preconditions.checkNotNull(comparator);
        return ImmutableSortedSet.copyOfInternal(comparator, iterable, false);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> collection) {
        Preconditions.checkNotNull(comparator);
        return ImmutableSortedSet.copyOfInternal(comparator, collection, false);
    }

    public static <E> ImmutableSortedSet<E> copyOfSorted(SortedSet<E> sortedSet) {
        Comparator comparator = sortedSet.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        return ImmutableSortedSet.copyOfInternal(comparator, sortedSet, true);
    }

    private static <E> ImmutableSortedSet<E> copyOfInternal(Comparator<? super E> comparator, Iterable<? extends E> iterable, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = bl || ImmutableSortedSet.hasSameComparator(iterable, comparator);
        if (bl2 && iterable instanceof ImmutableSortedSet) {
            ImmutableList<? extends E> immutableList;
            ImmutableSortedSet immutableSortedSet = (ImmutableSortedSet)iterable;
            if (immutableSortedSet.isEmpty()) {
                return immutableSortedSet;
            }
            ImmutableList immutableList2 = immutableSortedSet.asList();
            if (immutableList2 == (immutableList = ImmutableList.copyOf(iterable))) {
                return immutableSortedSet;
            }
            return new RegularImmutableSortedSet<E>(immutableList, comparator);
        }
        ImmutableList<E> immutableList = ImmutableSortedSet.immutableSortedUniqueCopy(comparator, Lists.newArrayList(iterable));
        if (immutableList.isEmpty()) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        return new RegularImmutableSortedSet<E>(immutableList, comparator);
    }

    private static <E> ImmutableSortedSet<E> copyOfInternal(Comparator<? super E> comparator, Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ImmutableList<? extends E> immutableList = ImmutableSortedSet.immutableSortedUniqueCopy(comparator, Lists.newArrayList(iterator));
        return new RegularImmutableSortedSet<E>(immutableList, comparator);
    }

    private static <E> ImmutableList<E> immutableSortedUniqueCopy(Comparator<? super E> comparator, List<E> list) {
        if (list.isEmpty()) {
            return ImmutableList.of();
        }
        Collections.sort(list, comparator);
        int n = 1;
        for (int i = 1; i < list.size(); ++i) {
            E e = list.get(i);
            if (comparator.compare(e, list.get(n - 1)) == 0) continue;
            list.set(n++, e);
        }
        return ImmutableList.copyOf(list.subList(0, n));
    }

    static boolean hasSameComparator(Iterable<?> iterable, Comparator<?> comparator) {
        if (iterable instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)iterable;
            Comparator comparator2 = sortedSet.comparator();
            return comparator2 == null ? comparator == Ordering.natural() : ((Object)comparator).equals(comparator2);
        }
        return false;
    }

    @Beta
    public static <E> ImmutableSortedSet<E> withExplicitOrder(List<E> list) {
        return ExplicitOrderedImmutableSortedSet.create(list);
    }

    @Beta
    public static <E> ImmutableSortedSet<E> withExplicitOrder(E e, E ... EArray) {
        return ImmutableSortedSet.withExplicitOrder(Lists.asList(e, EArray));
    }

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    public static <E extends Comparable<E>> Builder<E> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    public static <E extends Comparable<E>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    int unsafeCompare(Object object, Object object2) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, object, object2);
    }

    static int unsafeCompare(Comparator<?> comparator, Object object, Object object2) {
        Comparator<?> comparator2 = comparator;
        return comparator2.compare(object, object2);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public ImmutableSortedSet<E> headSet(E e) {
        return this.headSetImpl(Preconditions.checkNotNull(e));
    }

    @Override
    public ImmutableSortedSet<E> subSet(E e, E e2) {
        Preconditions.checkNotNull(e);
        Preconditions.checkNotNull(e2);
        Preconditions.checkArgument(this.comparator.compare(e, e2) <= 0);
        return this.subSetImpl(e, e2);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E e) {
        return this.tailSetImpl(Preconditions.checkNotNull(e));
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, E var2);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1);

    abstract int indexOf(Object var1);

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm<E>(this.comparator, this.toArray());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;

        public Builder(Comparator<? super E> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public Builder<E> add(E e) {
            super.add((Object)e);
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            super.add((Object[])EArray);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            super.addAll((Iterable)iterable);
            return this;
        }

        @Override
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll((Iterator)iterator);
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            return ImmutableSortedSet.copyOfInternal(this.comparator, this.contents.iterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializedForm<E>
    implements Serializable {
        final Comparator<? super E> comparator;
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        public SerializedForm(Comparator<? super E> comparator, Object[] objectArray) {
            this.comparator = comparator;
            this.elements = objectArray;
        }

        Object readResolve() {
            return ((Builder)new Builder<E>(this.comparator).add(this.elements)).build();
        }
    }
}

