/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import com.google.common.annotations.Beta;
import java.util.concurrent.ConcurrentMap;
import org.python.google.common.base.FinalizableReferenceQueue;
import org.python.google.common.base.FinalizableWeakReference;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.Interner;
import org.python.google.common.collect.MapMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Interners {
    private Interners() {
    }

    public static <E> Interner<E> newStrongInterner() {
        final ConcurrentMap concurrentMap = new MapMaker().makeMap();
        return new Interner<E>(){

            @Override
            public E intern(E e) {
                Object e2 = concurrentMap.putIfAbsent(Preconditions.checkNotNull(e), e);
                return e2 == null ? e : e2;
            }
        };
    }

    public static <E> Interner<E> newWeakInterner() {
        return new WeakInterner();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakInterner<E>
    implements Interner<E> {
        private final ConcurrentMap<InternReference, InternReference> map = new MapMaker().makeMap();
        private static final FinalizableReferenceQueue frq = new FinalizableReferenceQueue();

        private WeakInterner() {
        }

        @Override
        public E intern(final E e) {
            InternReference internReference;
            Object e2;
            Object object;
            final int n = e.hashCode();
            Object object2 = new Object(){

                public int hashCode() {
                    return n;
                }

                public boolean equals(Object object) {
                    if (object.hashCode() != n) {
                        return false;
                    }
                    InternReference internReference = (InternReference)object;
                    return e.equals(internReference.get());
                }
            };
            InternReference internReference2 = (InternReference)this.map.get(object2);
            if (internReference2 != null && (object = internReference2.get()) != null) {
                return object;
            }
            object = new InternReference(e, n);
            do {
                if ((internReference = this.map.putIfAbsent((InternReference)object, (InternReference)object)) != null) continue;
                return e;
            } while ((e2 = internReference.get()) == null);
            return e2;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternReference
        extends FinalizableWeakReference<E> {
            final int hashCode;

            InternReference(E e, int n) {
                super(e, frq);
                this.hashCode = n;
            }

            @Override
            public void finalizeReferent() {
                WeakInterner.this.map.remove(this);
            }

            @Override
            public E get() {
                Object t = super.get();
                if (t == null) {
                    this.finalizeReferent();
                }
                return t;
            }

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof InternReference) {
                    InternReference internReference = (InternReference)object;
                    if (internReference.hashCode != this.hashCode) {
                        return false;
                    }
                    Object t = super.get();
                    return t != null && t.equals(internReference.get());
                }
                return object.equals(this);
            }
        }
    }
}

